/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.builder.item;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.data.util.DataQueries;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.interfaces.data.IMixinCustomDataHolder;

public class SpongeItemStackDataBuilder
extends AbstractDataBuilder<ItemStack>
implements DataBuilder<ItemStack> {
    public SpongeItemStackDataBuilder() {
        super(ItemStack.class, 1);
    }

    @Override
    protected Optional<ItemStack> buildContent(DataView container) throws InvalidDataException {
        Preconditions.checkNotNull((Object)container);
        if (!(container.contains(DataQueries.ITEM_TYPE) && container.contains(DataQueries.ITEM_COUNT) && container.contains(DataQueries.ITEM_DAMAGE_VALUE))) {
            return Optional.empty();
        }
        String itemTypeId = DataUtil.getData(container, DataQueries.ITEM_TYPE, String.class);
        int count = DataUtil.getData(container, DataQueries.ITEM_COUNT, Integer.class);
        ItemType itemType = SpongeImpl.getRegistry().getType(ItemType.class, itemTypeId).get();
        int damage = DataUtil.getData(container, DataQueries.ITEM_DAMAGE_VALUE, Integer.class);
        net.minecraft.item.ItemStack itemStack = new net.minecraft.item.ItemStack((Item)itemType, count, damage);
        if (container.contains(DataQueries.UNSAFE_NBT)) {
            NBTTagCompound compound = NbtTranslator.getInstance().translateData(container.getView(DataQueries.UNSAFE_NBT).get());
            itemStack.func_77982_d(compound);
        }
        if (container.contains(DataQueries.DATA_MANIPULATORS)) {
            List<DataView> views = container.getViewList(DataQueries.DATA_MANIPULATORS).get();
            ImmutableList<DataManipulator<?, ?>> manipulators = DataUtil.deserializeManipulatorList(views);
            for (DataManipulator manipulator : manipulators) {
                ((IMixinCustomDataHolder)itemStack).offerCustom(manipulator, MergeFunction.IGNORE_ALL);
            }
        }
        return Optional.of((ItemStack)itemStack);
    }
}

