/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.builder.manipulator.immutable.block;

import java.util.Optional;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.ImmutableDataHolder;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulatorBuilder;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableTreeData;
import org.spongepowered.api.data.manipulator.mutable.block.TreeData;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.type.TreeType;
import org.spongepowered.api.data.type.TreeTypes;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeTreeData;
import org.spongepowered.common.data.util.DataUtil;

public class ImmutableSpongeTreeDataBuilder
extends AbstractDataBuilder<ImmutableTreeData>
implements ImmutableDataManipulatorBuilder<ImmutableTreeData, TreeData> {
    public ImmutableSpongeTreeDataBuilder() {
        super(ImmutableTreeData.class, 1);
    }

    @Override
    public ImmutableTreeData createImmutable() {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeTreeData.class, TreeTypes.OAK);
    }

    @Override
    public Optional<ImmutableTreeData> createFrom(DataHolder dataHolder) {
        return Optional.empty();
    }

    @Override
    public Optional<ImmutableTreeData> createFrom(ImmutableDataHolder<?> dataHolder) {
        return Optional.empty();
    }

    @Override
    public ImmutableDataManipulatorBuilder<ImmutableTreeData, TreeData> reset() {
        return this;
    }

    @Override
    protected Optional<ImmutableTreeData> buildContent(DataView container) throws InvalidDataException {
        DataUtil.checkDataExists(container, Keys.TREE_TYPE.getQuery());
        String treeTypeId = container.getString(Keys.TREE_TYPE.getQuery()).get();
        TreeType treeType = SpongeImpl.getRegistry().getType(TreeType.class, treeTypeId).get();
        return Optional.of(ImmutableDataCachingUtil.getManipulator(ImmutableSpongeTreeData.class, treeType));
    }
}

