/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable;

import java.util.Optional;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.ImmutableCommandData;
import org.spongepowered.api.data.manipulator.mutable.CommandData;
import org.spongepowered.api.data.value.immutable.ImmutableBoundedValue;
import org.spongepowered.api.data.value.immutable.ImmutableOptionalValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.text.Text;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.common.data.manipulator.mutable.SpongeCommandData;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeOptionalValue;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;

public class ImmutableSpongeCommandData
extends AbstractImmutableData<ImmutableCommandData, CommandData>
implements ImmutableCommandData {
    private final String storedCommand;
    private final int success;
    private final boolean tracks;
    private final Text lastOutput;
    private final ImmutableValue<String> storedValue;
    private final ImmutableBoundedValue<Integer> successValue;
    private final ImmutableValue<Boolean> tracksValue;
    private final ImmutableOptionalValue<Text> lastOutputValue;

    public ImmutableSpongeCommandData(String storedCommand, int success, boolean tracks, Text lastOutput) {
        super(ImmutableCommandData.class);
        this.storedCommand = storedCommand;
        this.success = success;
        this.tracks = tracks;
        this.lastOutput = lastOutput;
        this.storedValue = new ImmutableSpongeValue<String>(Keys.COMMAND, this.storedCommand);
        this.successValue = SpongeValueFactory.boundedBuilder(Keys.SUCCESS_COUNT).actualValue(this.success).defaultValue(0).minimum(0).maximum(Integer.MAX_VALUE).build().asImmutable();
        this.tracksValue = ImmutableSpongeValue.cachedOf(Keys.TRACKS_OUTPUT, false, this.tracks);
        this.lastOutputValue = new ImmutableSpongeOptionalValue<Text>(Keys.LAST_COMMAND_OUTPUT, Optional.ofNullable(this.lastOutput));
        this.registerGetters();
    }

    @Override
    public ImmutableValue<String> storedCommand() {
        return this.storedValue;
    }

    public ImmutableBoundedValue<Integer> successCount() {
        return this.successValue;
    }

    @Override
    public ImmutableValue<Boolean> doesTrackOutput() {
        return this.tracksValue;
    }

    @Override
    public ImmutableOptionalValue<Text> lastOutput() {
        return this.lastOutputValue;
    }

    @Override
    public CommandData asMutable() {
        return new SpongeCommandData().setSuccessCount(this.success).setStoredCommand(this.storedCommand).shouldTrackOutput(this.tracks).setLastOutput(this.lastOutput == null ? Text.of() : this.lastOutput);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.COMMAND, (Object)this.storedCommand).set(Keys.SUCCESS_COUNT, (Object)this.success).set(Keys.TRACKS_OUTPUT, (Object)this.tracks).set(Keys.LAST_COMMAND_OUTPUT.getQuery(), this.lastOutput == null ? "" : this.lastOutput.toString());
    }

    public String getStoredCommand() {
        return this.storedCommand;
    }

    public int getSuccess() {
        return this.success;
    }

    public boolean getTracks() {
        return this.tracks;
    }

    public Text getLastOutput() {
        return this.lastOutput;
    }

    @Override
    protected void registerGetters() {
        this.registerKeyValue(Keys.COMMAND, this::storedCommand);
        this.registerKeyValue(Keys.SUCCESS_COUNT, () -> this.successCount());
        this.registerKeyValue(Keys.TRACKS_OUTPUT, this::doesTrackOutput);
        this.registerKeyValue(Keys.LAST_COMMAND_OUTPUT, this::lastOutput);
        this.registerFieldGetter(Keys.COMMAND, this::getStoredCommand);
        this.registerFieldGetter(Keys.SUCCESS_COUNT, this::getSuccess);
        this.registerFieldGetter(Keys.TRACKS_OUTPUT, this::getTracks);
        this.registerFieldGetter(Keys.LAST_COMMAND_OUTPUT, this::getLastOutput);
    }
}

