/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable;

import com.google.common.base.Preconditions;
import java.util.stream.Collectors;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.ImmutableMobSpawnerData;
import org.spongepowered.api.data.manipulator.mutable.MobSpawnerData;
import org.spongepowered.api.data.value.immutable.ImmutableBoundedValue;
import org.spongepowered.api.data.value.immutable.ImmutableWeightedCollectionValue;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.util.weighted.WeightedSerializableObject;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.common.data.manipulator.mutable.SpongeMobSpawnerData;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeEntityToSpawnValue;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeWeightedCollectionValue;
import org.spongepowered.common.entity.SpongeEntitySnapshotBuilder;

public class ImmutableSpongeMobSpawnerData
extends AbstractImmutableData<ImmutableMobSpawnerData, MobSpawnerData>
implements ImmutableMobSpawnerData {
    private final short remaining;
    private final short minSpawnDelay;
    private final short maxSpawnDelay;
    private final short count;
    private final short maxNearby;
    private final short playerRange;
    private final short spawnRange;
    private final WeightedSerializableObject<EntitySnapshot> nextToSpawn;
    private final WeightedTable<EntitySnapshot> entitiesToSpawn;
    private final ImmutableBoundedValue<Short> remainingValue;
    private final ImmutableBoundedValue<Short> minValue;
    private final ImmutableBoundedValue<Short> maxValue;
    private final ImmutableBoundedValue<Short> countValue;
    private final ImmutableBoundedValue<Short> nearbyValue;
    private final ImmutableBoundedValue<Short> playerRangeValue;
    private final ImmutableBoundedValue<Short> spawnRangeValue;
    private final ImmutableMobSpawnerData.ImmutableNextEntityToSpawnValue nextValue;
    private final ImmutableWeightedCollectionValue<EntitySnapshot> toSpawnValue;

    public ImmutableSpongeMobSpawnerData() {
        this(20, 200, 800, 4, 6, 16, 4, new WeightedSerializableObject<EntitySnapshot>(new SpongeEntitySnapshotBuilder().type(EntityTypes.PIG).build(), 1), new WeightedTable<EntitySnapshot>());
    }

    public ImmutableSpongeMobSpawnerData(short remaining, short minSpawnDelay, short maxSpawnDelay, short count, short maxNearby, short playerRange, short spawnRange, WeightedSerializableObject<EntitySnapshot> nextToSpawn, WeightedTable<EntitySnapshot> entitiesToSpawn) {
        super(ImmutableMobSpawnerData.class);
        this.remaining = remaining;
        this.minSpawnDelay = minSpawnDelay;
        this.maxSpawnDelay = maxSpawnDelay;
        this.count = count;
        this.maxNearby = maxNearby;
        this.playerRange = playerRange;
        this.spawnRange = spawnRange;
        this.nextToSpawn = (WeightedSerializableObject)Preconditions.checkNotNull(nextToSpawn);
        this.entitiesToSpawn = ((WeightedTable)Preconditions.checkNotNull(entitiesToSpawn)).stream().collect(Collectors.toCollection(WeightedTable::new));
        this.remainingValue = SpongeValueFactory.boundedBuilder(Keys.SPAWNER_REMAINING_DELAY).defaultValue((short)20).minimum((short)0).maximum((short)Short.MAX_VALUE).actualValue(remaining).build().asImmutable();
        this.minValue = SpongeValueFactory.boundedBuilder(Keys.SPAWNER_MINIMUM_DELAY).defaultValue((short)200).minimum((short)0).maximum((short)Short.MAX_VALUE).actualValue(minSpawnDelay).build().asImmutable();
        this.maxValue = SpongeValueFactory.boundedBuilder(Keys.SPAWNER_MAXIMUM_DELAY).defaultValue((short)800).minimum((short)1).maximum((short)Short.MAX_VALUE).actualValue(maxSpawnDelay).build().asImmutable();
        this.countValue = SpongeValueFactory.boundedBuilder(Keys.SPAWNER_SPAWN_COUNT).defaultValue((short)4).minimum((short)0).maximum((short)Short.MAX_VALUE).actualValue(count).build().asImmutable();
        this.nearbyValue = SpongeValueFactory.boundedBuilder(Keys.SPAWNER_MAXIMUM_NEARBY_ENTITIES).defaultValue((short)6).minimum((short)0).maximum((short)Short.MAX_VALUE).actualValue(maxNearby).build().asImmutable();
        this.playerRangeValue = SpongeValueFactory.boundedBuilder(Keys.SPAWNER_REQUIRED_PLAYER_RANGE).defaultValue((short)16).minimum((short)0).maximum((short)Short.MAX_VALUE).actualValue(playerRange).build().asImmutable();
        this.spawnRangeValue = SpongeValueFactory.boundedBuilder(Keys.SPAWNER_SPAWN_RANGE).defaultValue((short)4).minimum((short)0).maximum((short)Short.MAX_VALUE).actualValue(spawnRange).build().asImmutable();
        this.nextValue = new ImmutableSpongeEntityToSpawnValue(this.nextToSpawn);
        this.toSpawnValue = new ImmutableSpongeWeightedCollectionValue<EntitySnapshot>(Keys.SPAWNER_ENTITIES, this.entitiesToSpawn);
        this.registerGetters();
    }

    @Override
    public ImmutableBoundedValue<Short> remainingDelay() {
        return this.remainingValue;
    }

    @Override
    public ImmutableBoundedValue<Short> minimumSpawnDelay() {
        return this.minValue;
    }

    @Override
    public ImmutableBoundedValue<Short> maximumSpawnDelay() {
        return this.maxValue;
    }

    @Override
    public ImmutableBoundedValue<Short> spawnCount() {
        return this.countValue;
    }

    @Override
    public ImmutableBoundedValue<Short> maximumNearbyEntities() {
        return this.nearbyValue;
    }

    @Override
    public ImmutableBoundedValue<Short> requiredPlayerRange() {
        return this.playerRangeValue;
    }

    @Override
    public ImmutableBoundedValue<Short> spawnRange() {
        return this.spawnRangeValue;
    }

    @Override
    public ImmutableMobSpawnerData.ImmutableNextEntityToSpawnValue nextEntityToSpawn() {
        return this.nextValue;
    }

    @Override
    public ImmutableWeightedCollectionValue<EntitySnapshot> possibleEntitiesToSpawn() {
        return this.toSpawnValue;
    }

    public short getRemaining() {
        return this.remaining;
    }

    public short getMinSpawnDelay() {
        return this.minSpawnDelay;
    }

    public short getMaxSpawnDelay() {
        return this.maxSpawnDelay;
    }

    public short getCount() {
        return this.count;
    }

    public short getMaxNearby() {
        return this.maxNearby;
    }

    public short getPlayerRange() {
        return this.playerRange;
    }

    public short getSpawnRange() {
        return this.spawnRange;
    }

    public WeightedSerializableObject<EntitySnapshot> getNextToSpawn() {
        return this.nextToSpawn;
    }

    public WeightedTable<EntitySnapshot> getEntitiesToSpawn() {
        return this.entitiesToSpawn;
    }

    @Override
    public MobSpawnerData asMutable() {
        return new SpongeMobSpawnerData(this.remaining, this.minSpawnDelay, this.maxSpawnDelay, this.count, this.maxNearby, this.playerRange, this.spawnRange, this.nextToSpawn, this.entitiesToSpawn);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.SPAWNER_REMAINING_DELAY, (Object)this.remaining).set(Keys.SPAWNER_MINIMUM_DELAY, (Object)this.minSpawnDelay).set(Keys.SPAWNER_MAXIMUM_DELAY, (Object)this.maxSpawnDelay).set(Keys.SPAWNER_SPAWN_COUNT, (Object)this.count).set(Keys.SPAWNER_MAXIMUM_NEARBY_ENTITIES, (Object)this.maxNearby).set(Keys.SPAWNER_REQUIRED_PLAYER_RANGE, (Object)this.playerRange).set(Keys.SPAWNER_SPAWN_RANGE, (Object)this.spawnRange).set(Keys.SPAWNER_NEXT_ENTITY_TO_SPAWN, (Object)this.nextToSpawn).set(Keys.SPAWNER_ENTITIES, (Object)this.entitiesToSpawn);
    }

    @Override
    protected void registerGetters() {
        this.registerKeyValue(Keys.SPAWNER_REMAINING_DELAY, this::remainingDelay);
        this.registerKeyValue(Keys.SPAWNER_MINIMUM_DELAY, this::minimumSpawnDelay);
        this.registerKeyValue(Keys.SPAWNER_MAXIMUM_DELAY, this::maximumSpawnDelay);
        this.registerKeyValue(Keys.SPAWNER_SPAWN_COUNT, this::spawnCount);
        this.registerKeyValue(Keys.SPAWNER_MAXIMUM_NEARBY_ENTITIES, this::maximumNearbyEntities);
        this.registerKeyValue(Keys.SPAWNER_REQUIRED_PLAYER_RANGE, this::requiredPlayerRange);
        this.registerKeyValue(Keys.SPAWNER_SPAWN_RANGE, this::spawnRange);
        this.registerKeyValue(Keys.SPAWNER_NEXT_ENTITY_TO_SPAWN, this::nextEntityToSpawn);
        this.registerKeyValue(Keys.SPAWNER_ENTITIES, this::possibleEntitiesToSpawn);
        this.registerFieldGetter(Keys.SPAWNER_REMAINING_DELAY, this::getRemaining);
        this.registerFieldGetter(Keys.SPAWNER_MINIMUM_DELAY, this::getMinSpawnDelay);
        this.registerFieldGetter(Keys.SPAWNER_MAXIMUM_DELAY, this::getMaxSpawnDelay);
        this.registerFieldGetter(Keys.SPAWNER_SPAWN_COUNT, this::getCount);
        this.registerFieldGetter(Keys.SPAWNER_MAXIMUM_NEARBY_ENTITIES, this::getMaxNearby);
        this.registerFieldGetter(Keys.SPAWNER_REQUIRED_PLAYER_RANGE, this::getPlayerRange);
        this.registerFieldGetter(Keys.SPAWNER_SPAWN_RANGE, this::getSpawnRange);
        this.registerFieldGetter(Keys.SPAWNER_NEXT_ENTITY_TO_SPAWN, this::getNextToSpawn);
        this.registerFieldGetter(Keys.SPAWNER_ENTITIES, this::getEntitiesToSpawn);
    }
}

