/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.entity;

import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableBreathingData;
import org.spongepowered.api.data.manipulator.mutable.entity.BreathingData;
import org.spongepowered.api.data.value.immutable.ImmutableBoundedValue;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeBreathingData;
import org.spongepowered.common.data.value.SpongeValueFactory;

public class ImmutableSpongeBreathingData
extends AbstractImmutableData<ImmutableBreathingData, BreathingData>
implements ImmutableBreathingData {
    private final int maxAir;
    private final int remainingAir;
    private final ImmutableBoundedValue<Integer> remainingAirValue;
    private final ImmutableBoundedValue<Integer> maxAirValue;

    public ImmutableSpongeBreathingData(int maxAir, int remainingAir) {
        super(ImmutableBreathingData.class);
        this.maxAir = maxAir;
        this.remainingAir = remainingAir;
        this.remainingAirValue = SpongeValueFactory.boundedBuilder(Keys.REMAINING_AIR).actualValue(remainingAir).defaultValue(this.maxAir).minimum(-20).maximum(this.maxAir).build().asImmutable();
        this.maxAirValue = SpongeValueFactory.boundedBuilder(Keys.MAX_AIR).actualValue(this.maxAir).defaultValue(300).minimum(0).maximum(Integer.MAX_VALUE).build().asImmutable();
        this.registerGetters();
    }

    @Override
    public BreathingData asMutable() {
        return new SpongeBreathingData(this.maxAir, this.remainingAir);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.MAX_AIR.getQuery(), (Object)this.maxAir).set(Keys.REMAINING_AIR.getQuery(), (Object)this.remainingAir);
    }

    @Override
    public ImmutableBoundedValue<Integer> remainingAir() {
        return this.remainingAirValue;
    }

    @Override
    public ImmutableBoundedValue<Integer> maxAir() {
        return this.maxAirValue;
    }

    public int getMaxAir() {
        return this.maxAir;
    }

    public int getRemainingAir() {
        return this.remainingAir;
    }

    @Override
    protected void registerGetters() {
        this.registerFieldGetter(Keys.MAX_AIR, this::getMaxAir);
        this.registerKeyValue(Keys.MAX_AIR, this::maxAir);
        this.registerFieldGetter(Keys.REMAINING_AIR, this::getRemainingAir);
        this.registerKeyValue(Keys.REMAINING_AIR, this::remainingAir);
    }
}

