/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.entity;

import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableHorseData;
import org.spongepowered.api.data.manipulator.mutable.entity.HorseData;
import org.spongepowered.api.data.type.HorseColor;
import org.spongepowered.api.data.type.HorseColors;
import org.spongepowered.api.data.type.HorseStyle;
import org.spongepowered.api.data.type.HorseStyles;
import org.spongepowered.api.data.type.HorseVariant;
import org.spongepowered.api.data.type.HorseVariants;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeHorseData;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;

public class ImmutableSpongeHorseData
extends AbstractImmutableData<ImmutableHorseData, HorseData>
implements ImmutableHorseData {
    private final HorseColor horseColor;
    private final HorseStyle horseStyle;
    private final HorseVariant horseVariant;
    private final ImmutableValue<HorseColor> colorValue;
    private final ImmutableValue<HorseStyle> styleValue;
    private final ImmutableValue<HorseVariant> variantValue;

    public ImmutableSpongeHorseData(HorseColor horseColor, HorseStyle horseStyle, HorseVariant horseVariant) {
        super(ImmutableHorseData.class);
        this.horseColor = horseColor;
        this.horseStyle = horseStyle;
        this.horseVariant = horseVariant;
        this.colorValue = ImmutableSpongeValue.cachedOf(Keys.HORSE_COLOR, HorseColors.BLACK, this.horseColor);
        this.styleValue = ImmutableSpongeValue.cachedOf(Keys.HORSE_STYLE, HorseStyles.NONE, this.horseStyle);
        this.variantValue = ImmutableSpongeValue.cachedOf(Keys.HORSE_VARIANT, HorseVariants.HORSE, this.horseVariant);
        this.registerGetters();
    }

    @Override
    protected void registerGetters() {
        this.registerFieldGetter(Keys.HORSE_COLOR, this::getHorseColor);
        this.registerKeyValue(Keys.HORSE_COLOR, this::color);
        this.registerFieldGetter(Keys.HORSE_STYLE, this::getHorseStyle);
        this.registerKeyValue(Keys.HORSE_STYLE, this::style);
        this.registerFieldGetter(Keys.HORSE_VARIANT, this::getHorseVariant);
        this.registerKeyValue(Keys.HORSE_VARIANT, this::variant);
    }

    @Override
    public ImmutableValue<HorseColor> color() {
        return this.colorValue;
    }

    @Override
    public ImmutableValue<HorseStyle> style() {
        return this.styleValue;
    }

    @Override
    public ImmutableValue<HorseVariant> variant() {
        return this.variantValue;
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.HORSE_COLOR.getQuery(), (Object)this.horseColor.getId()).set(Keys.HORSE_STYLE.getQuery(), (Object)this.horseStyle.getId()).set(Keys.HORSE_VARIANT.getQuery(), (Object)this.horseVariant.getId());
    }

    @Override
    public HorseData asMutable() {
        return new SpongeHorseData(this.horseColor, this.horseStyle, this.horseVariant);
    }

    private HorseColor getHorseColor() {
        return this.horseColor;
    }

    private HorseStyle getHorseStyle() {
        return this.horseStyle;
    }

    private HorseVariant getHorseVariant() {
        return this.horseVariant;
    }
}

