/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.entity;

import java.util.Optional;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableZombieData;
import org.spongepowered.api.data.manipulator.mutable.entity.ZombieData;
import org.spongepowered.api.data.type.Profession;
import org.spongepowered.api.data.type.ZombieType;
import org.spongepowered.api.data.value.immutable.ImmutableOptionalValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeZombieData;
import org.spongepowered.common.data.util.DataConstants;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeOptionalValue;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;

public class ImmutableSpongeZombieData
extends AbstractImmutableData<ImmutableZombieData, ZombieData>
implements ImmutableZombieData {
    private final ZombieType type;
    private final Optional<Profession> profession;
    private final ImmutableValue<ZombieType> typeValue;
    private final ImmutableOptionalValue<Profession> professionValue;

    public ImmutableSpongeZombieData(ZombieType type, Optional<Profession> profession) {
        this.type = type;
        this.profession = profession;
        this.typeValue = ImmutableSpongeValue.cachedOf(Keys.ZOMBIE_TYPE, DataConstants.Catalog.DEFAULT_ZOMBIE_TYPE, type);
        this.professionValue = new ImmutableSpongeOptionalValue<Profession>(Keys.VILLAGER_ZOMBIE_PROFESSION, profession);
    }

    @Override
    public int getContentVersion() {
        return 0;
    }

    @Override
    public ImmutableValue<ZombieType> type() {
        return this.typeValue;
    }

    @Override
    public ImmutableOptionalValue<Profession> profession() {
        return this.professionValue;
    }

    @Override
    protected void registerGetters() {
        this.registerFieldGetter(Keys.ZOMBIE_TYPE, this::getType);
        this.registerFieldGetter(Keys.VILLAGER_ZOMBIE_PROFESSION, this::getProfession);
        this.registerKeyValue(Keys.ZOMBIE_TYPE, this::type);
        this.registerKeyValue(Keys.VILLAGER_ZOMBIE_PROFESSION, this::profession);
    }

    private ZombieType getType() {
        return this.type;
    }

    private Optional<Profession> getProfession() {
        return this.profession;
    }

    @Override
    public ZombieData asMutable() {
        return new SpongeZombieData(this.type, this.profession);
    }

    @Override
    public DataContainer toContainer() {
        DataContainer data = super.toContainer();
        data.set(Keys.ZOMBIE_TYPE.getQuery(), (Object)this.getType().getId());
        if (this.getProfession().isPresent()) {
            data.set(Keys.VILLAGER_ZOMBIE_PROFESSION.getQuery(), (Object)this.getProfession().get().getId());
        }
        return data;
    }
}

