/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable;

import com.google.common.base.Preconditions;
import java.util.stream.Collectors;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.ImmutableMobSpawnerData;
import org.spongepowered.api.data.manipulator.mutable.MobSpawnerData;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.api.data.value.mutable.WeightedCollectionValue;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.util.weighted.WeightedSerializableObject;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.common.data.manipulator.immutable.ImmutableSpongeMobSpawnerData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.data.value.mutable.SpongeNextEntityToSpawnValue;
import org.spongepowered.common.data.value.mutable.SpongeWeightedCollectionValue;
import org.spongepowered.common.entity.SpongeEntitySnapshotBuilder;

public class SpongeMobSpawnerData
extends AbstractData<MobSpawnerData, ImmutableMobSpawnerData>
implements MobSpawnerData {
    private short remainingDelay;
    private short minimumDelay;
    private short maximumDelay;
    private short count;
    private short maximumEntities;
    private short playerRange;
    private short spawnRange;
    private WeightedSerializableObject<EntitySnapshot> nextEntityToSpawn;
    private WeightedTable<EntitySnapshot> entities;

    public SpongeMobSpawnerData(short remainingDelay, short minimumDelay, short maximumDelay, short count, short maximumEntities, short playerRange, short spawnRange, WeightedSerializableObject<EntitySnapshot> nextEntityToSpawn, WeightedTable<EntitySnapshot> entities) {
        super(MobSpawnerData.class);
        this.remainingDelay = remainingDelay;
        this.minimumDelay = minimumDelay;
        this.maximumDelay = maximumDelay;
        this.count = count;
        this.maximumEntities = maximumEntities;
        this.playerRange = playerRange;
        this.spawnRange = spawnRange;
        this.nextEntityToSpawn = (WeightedSerializableObject)Preconditions.checkNotNull(nextEntityToSpawn);
        ((WeightedTable)Preconditions.checkNotNull(entities)).forEach(Preconditions::checkNotNull);
        this.entities = entities.stream().collect(Collectors.toCollection(WeightedTable::new));
        this.registerGettersAndSetters();
    }

    public SpongeMobSpawnerData() {
        this(20, 200, 800, 4, 6, 16, 4, new WeightedSerializableObject<EntitySnapshot>(new SpongeEntitySnapshotBuilder().type(EntityTypes.PIG).build(), 1), new WeightedTable<EntitySnapshot>());
    }

    @Override
    public MutableBoundedValue<Short> remainingDelay() {
        return SpongeValueFactory.boundedBuilder(Keys.SPAWNER_REMAINING_DELAY).minimum((short)0).maximum(this.maximumDelay).defaultValue((short)20).actualValue(this.remainingDelay).build();
    }

    @Override
    public MutableBoundedValue<Short> minimumSpawnDelay() {
        return SpongeValueFactory.boundedBuilder(Keys.SPAWNER_MINIMUM_DELAY).minimum((short)0).maximum((short)Short.MAX_VALUE).defaultValue((short)200).actualValue(this.minimumDelay).build();
    }

    @Override
    public MutableBoundedValue<Short> maximumSpawnDelay() {
        return SpongeValueFactory.boundedBuilder(Keys.SPAWNER_MAXIMUM_DELAY).minimum((short)1).maximum((short)Short.MAX_VALUE).defaultValue((short)800).actualValue(this.maximumDelay).build();
    }

    @Override
    public MutableBoundedValue<Short> spawnCount() {
        return SpongeValueFactory.boundedBuilder(Keys.SPAWNER_SPAWN_COUNT).minimum((short)0).maximum((short)Short.MAX_VALUE).defaultValue((short)4).actualValue(this.count).build();
    }

    @Override
    public MutableBoundedValue<Short> maximumNearbyEntities() {
        return SpongeValueFactory.boundedBuilder(Keys.SPAWNER_MAXIMUM_NEARBY_ENTITIES).minimum((short)0).maximum((short)Short.MAX_VALUE).defaultValue((short)6).actualValue(this.maximumEntities).build();
    }

    @Override
    public MutableBoundedValue<Short> requiredPlayerRange() {
        return SpongeValueFactory.boundedBuilder(Keys.SPAWNER_REQUIRED_PLAYER_RANGE).minimum((short)0).maximum((short)Short.MAX_VALUE).defaultValue((short)16).actualValue(this.playerRange).build();
    }

    @Override
    public MutableBoundedValue<Short> spawnRange() {
        return SpongeValueFactory.boundedBuilder(Keys.SPAWNER_SPAWN_RANGE).minimum((short)0).maximum((short)Short.MAX_VALUE).defaultValue((short)4).actualValue(this.spawnRange).build();
    }

    @Override
    public MobSpawnerData.NextEntityToSpawnValue nextEntityToSpawn() {
        return new SpongeNextEntityToSpawnValue(this.nextEntityToSpawn);
    }

    @Override
    public WeightedCollectionValue<EntitySnapshot> possibleEntitiesToSpawn() {
        return new SpongeWeightedCollectionValue<EntitySnapshot>(Keys.SPAWNER_ENTITIES, this.entities);
    }

    @Override
    public MobSpawnerData copy() {
        return new SpongeMobSpawnerData(this.remainingDelay, this.minimumDelay, this.maximumDelay, this.count, this.maximumEntities, this.playerRange, this.spawnRange, this.nextEntityToSpawn, this.entities);
    }

    @Override
    public ImmutableMobSpawnerData asImmutable() {
        return new ImmutableSpongeMobSpawnerData(this.remainingDelay, this.minimumDelay, this.maximumDelay, this.count, this.maximumEntities, this.playerRange, this.spawnRange, this.nextEntityToSpawn, this.entities);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.SPAWNER_REMAINING_DELAY.getQuery(), (Object)this.remainingDelay).set(Keys.SPAWNER_MINIMUM_DELAY.getQuery(), (Object)this.minimumDelay).set(Keys.SPAWNER_MAXIMUM_DELAY.getQuery(), (Object)this.maximumDelay).set(Keys.SPAWNER_SPAWN_COUNT.getQuery(), (Object)this.count).set(Keys.SPAWNER_MAXIMUM_NEARBY_ENTITIES.getQuery(), (Object)this.maximumEntities).set(Keys.SPAWNER_REQUIRED_PLAYER_RANGE.getQuery(), (Object)this.playerRange).set(Keys.SPAWNER_SPAWN_RANGE.getQuery(), (Object)this.spawnRange).set(Keys.SPAWNER_NEXT_ENTITY_TO_SPAWN.getQuery(), this.nextEntityToSpawn).set(Keys.SPAWNER_ENTITIES.getQuery(), this.entities);
    }

    public short getRemainingDelay() {
        return this.remainingDelay;
    }

    public void setRemainingDelay(short remainingDelay) {
        this.remainingDelay = remainingDelay;
    }

    public short getMinimumDelay() {
        return this.minimumDelay;
    }

    public void setMinimumDelay(short minimumDelay) {
        this.minimumDelay = minimumDelay;
    }

    public short getMaximumDelay() {
        return this.maximumDelay;
    }

    public void setMaximumDelay(short maximumDelay) {
        this.maximumDelay = maximumDelay;
    }

    public short getCount() {
        return this.count;
    }

    public void setCount(short count) {
        this.count = count;
    }

    public short getMaximumEntities() {
        return this.maximumEntities;
    }

    public void setMaximumEntities(short maximumEntities) {
        this.maximumEntities = maximumEntities;
    }

    public short getPlayerRange() {
        return this.playerRange;
    }

    public void setPlayerRange(short playerRange) {
        this.playerRange = playerRange;
    }

    public short getSpawnRange() {
        return this.spawnRange;
    }

    public void setSpawnRange(short spawnRange) {
        this.spawnRange = spawnRange;
    }

    public WeightedSerializableObject<EntitySnapshot> getNextEntityToSpawn() {
        return this.nextEntityToSpawn;
    }

    public void setNextEntityToSpawn(WeightedSerializableObject<EntitySnapshot> nextEntityToSpawn) {
        this.nextEntityToSpawn = (WeightedSerializableObject)Preconditions.checkNotNull(nextEntityToSpawn);
    }

    public WeightedTable<EntitySnapshot> getEntities() {
        return this.entities;
    }

    public void setEntities(WeightedTable<EntitySnapshot> entities) {
        ((WeightedTable)Preconditions.checkNotNull(entities)).forEach(Preconditions::checkNotNull);
        this.entities = entities;
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerKeyValue(Keys.SPAWNER_REMAINING_DELAY, this::remainingDelay);
        this.registerKeyValue(Keys.SPAWNER_MINIMUM_DELAY, this::minimumSpawnDelay);
        this.registerKeyValue(Keys.SPAWNER_MAXIMUM_DELAY, this::maximumSpawnDelay);
        this.registerKeyValue(Keys.SPAWNER_SPAWN_COUNT, this::spawnCount);
        this.registerKeyValue(Keys.SPAWNER_MAXIMUM_NEARBY_ENTITIES, this::maximumNearbyEntities);
        this.registerKeyValue(Keys.SPAWNER_REQUIRED_PLAYER_RANGE, this::requiredPlayerRange);
        this.registerKeyValue(Keys.SPAWNER_SPAWN_RANGE, this::spawnRange);
        this.registerKeyValue(Keys.SPAWNER_NEXT_ENTITY_TO_SPAWN, this::nextEntityToSpawn);
        this.registerKeyValue(Keys.SPAWNER_ENTITIES, this::possibleEntitiesToSpawn);
        this.registerFieldGetter(Keys.SPAWNER_REMAINING_DELAY, this::getRemainingDelay);
        this.registerFieldGetter(Keys.SPAWNER_MINIMUM_DELAY, this::getMinimumDelay);
        this.registerFieldGetter(Keys.SPAWNER_MAXIMUM_DELAY, this::getMaximumDelay);
        this.registerFieldGetter(Keys.SPAWNER_SPAWN_COUNT, this::getCount);
        this.registerFieldGetter(Keys.SPAWNER_MAXIMUM_NEARBY_ENTITIES, this::getMaximumEntities);
        this.registerFieldGetter(Keys.SPAWNER_REQUIRED_PLAYER_RANGE, this::getPlayerRange);
        this.registerFieldGetter(Keys.SPAWNER_SPAWN_RANGE, this::getSpawnRange);
        this.registerFieldGetter(Keys.SPAWNER_NEXT_ENTITY_TO_SPAWN, this::getNextEntityToSpawn);
        this.registerFieldGetter(Keys.SPAWNER_ENTITIES, this::getEntities);
        this.registerFieldSetter(Keys.SPAWNER_REMAINING_DELAY, this::setRemainingDelay);
        this.registerFieldSetter(Keys.SPAWNER_MINIMUM_DELAY, this::setMinimumDelay);
        this.registerFieldSetter(Keys.SPAWNER_MAXIMUM_DELAY, this::setMaximumDelay);
        this.registerFieldSetter(Keys.SPAWNER_SPAWN_COUNT, this::setCount);
        this.registerFieldSetter(Keys.SPAWNER_MAXIMUM_NEARBY_ENTITIES, this::setMaximumEntities);
        this.registerFieldSetter(Keys.SPAWNER_REQUIRED_PLAYER_RANGE, this::setPlayerRange);
        this.registerFieldSetter(Keys.SPAWNER_SPAWN_RANGE, this::setSpawnRange);
        this.registerFieldSetter(Keys.SPAWNER_NEXT_ENTITY_TO_SPAWN, this::setNextEntityToSpawn);
        this.registerFieldSetter(Keys.SPAWNER_ENTITIES, this::setEntities);
    }
}

