/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.entity;

import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableFallingBlockData;
import org.spongepowered.api.data.manipulator.mutable.entity.FallingBlockData;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.immutable.entity.ImmutableSpongeFallingBlockData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.util.DataConstants;
import org.spongepowered.common.data.util.ImplementationRequiredForTest;
import org.spongepowered.common.data.value.mutable.SpongeValue;

@ImplementationRequiredForTest
public class SpongeFallingBlockData
extends AbstractData<FallingBlockData, ImmutableFallingBlockData>
implements FallingBlockData {
    private double fallDamagePerBlock;
    private double maxFallDamage;
    private BlockState blockState;
    private boolean canPlaceAsBlock;
    private boolean canDropAsItem;
    private int fallTime;
    private boolean canHurtEntities;

    public SpongeFallingBlockData(double fallDamagePerBlock, double maxFallDamage, BlockState blockState, boolean canPlaceAsBlock, boolean canDropAsItem, int fallTime, boolean canHurtEntities) {
        super(FallingBlockData.class);
        this.fallDamagePerBlock = fallDamagePerBlock;
        this.maxFallDamage = maxFallDamage;
        this.blockState = blockState;
        this.canPlaceAsBlock = canPlaceAsBlock;
        this.canDropAsItem = canDropAsItem;
        this.fallTime = fallTime;
        this.canHurtEntities = canHurtEntities;
        this.registerGettersAndSetters();
    }

    public SpongeFallingBlockData() {
        this(2.0, 40.0, DataConstants.Catalog.DEFAULT_FALLING_BLOCK_BLOCKSTATE, false, true, 1, false);
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerFieldGetter(Keys.FALL_DAMAGE_PER_BLOCK, this::getFallDamagePerBlock);
        this.registerFieldSetter(Keys.FALL_DAMAGE_PER_BLOCK, this::setFallDamagePerBlock);
        this.registerKeyValue(Keys.FALL_DAMAGE_PER_BLOCK, this::fallDamagePerBlock);
        this.registerFieldGetter(Keys.MAX_FALL_DAMAGE, this::getMaxFallDamage);
        this.registerFieldSetter(Keys.MAX_FALL_DAMAGE, this::setMaxFallDamage);
        this.registerKeyValue(Keys.MAX_FALL_DAMAGE, this::maxFallDamage);
        this.registerFieldGetter(Keys.FALLING_BLOCK_STATE, this::getBlockState);
        this.registerFieldSetter(Keys.FALLING_BLOCK_STATE, this::setBlockState);
        this.registerKeyValue(Keys.FALLING_BLOCK_STATE, this::blockState);
        this.registerFieldGetter(Keys.CAN_PLACE_AS_BLOCK, this::getCanPlaceAsBlock);
        this.registerFieldSetter(Keys.CAN_PLACE_AS_BLOCK, this::setCanPlaceAsBlock);
        this.registerKeyValue(Keys.CAN_PLACE_AS_BLOCK, this::canPlaceAsBlock);
        this.registerFieldGetter(Keys.CAN_DROP_AS_ITEM, this::getCanDropAsItem);
        this.registerFieldSetter(Keys.CAN_DROP_AS_ITEM, this::setCanDropAsItem);
        this.registerKeyValue(Keys.CAN_DROP_AS_ITEM, this::canDropAsItem);
        this.registerFieldGetter(Keys.FALL_TIME, this::getFallTime);
        this.registerFieldSetter(Keys.FALL_TIME, this::setFallTime);
        this.registerKeyValue(Keys.FALL_TIME, this::fallTime);
        this.registerFieldGetter(Keys.FALLING_BLOCK_CAN_HURT_ENTITIES, this::getCanHurtEntities);
        this.registerFieldSetter(Keys.FALLING_BLOCK_CAN_HURT_ENTITIES, this::setCanHurtEntities);
        this.registerKeyValue(Keys.FALLING_BLOCK_CAN_HURT_ENTITIES, this::canHurtEntities);
    }

    public void setFallDamagePerBlock(double value) {
        this.fallDamagePerBlock = value;
    }

    public double getFallDamagePerBlock() {
        return this.fallDamagePerBlock;
    }

    @Override
    public Value<Double> fallDamagePerBlock() {
        return new SpongeValue<Double>(Keys.FALL_DAMAGE_PER_BLOCK, 2.0, this.fallDamagePerBlock);
    }

    public void setMaxFallDamage(double value) {
        this.maxFallDamage = value;
    }

    public double getMaxFallDamage() {
        return this.maxFallDamage;
    }

    @Override
    public Value<Double> maxFallDamage() {
        return new SpongeValue<Double>(Keys.MAX_FALL_DAMAGE, 40.0, this.maxFallDamage);
    }

    public void setBlockState(BlockState value) {
        this.blockState = value;
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    @Override
    public Value<BlockState> blockState() {
        return new SpongeValue<BlockState>(Keys.FALLING_BLOCK_STATE, DataConstants.Catalog.DEFAULT_FALLING_BLOCK_BLOCKSTATE, this.blockState);
    }

    public void setCanPlaceAsBlock(boolean value) {
        this.canPlaceAsBlock = value;
    }

    public boolean getCanPlaceAsBlock() {
        return this.canPlaceAsBlock;
    }

    @Override
    public Value<Boolean> canPlaceAsBlock() {
        return new SpongeValue<Boolean>(Keys.CAN_PLACE_AS_BLOCK, false, this.canPlaceAsBlock);
    }

    public void setCanDropAsItem(boolean value) {
        this.canDropAsItem = value;
    }

    public boolean getCanDropAsItem() {
        return this.canDropAsItem;
    }

    @Override
    public Value<Boolean> canDropAsItem() {
        return new SpongeValue<Boolean>(Keys.CAN_DROP_AS_ITEM, true, this.canDropAsItem);
    }

    public void setFallTime(int value) {
        this.fallTime = value;
    }

    public int getFallTime() {
        return this.fallTime;
    }

    @Override
    public Value<Integer> fallTime() {
        return new SpongeValue<Integer>(Keys.FALL_TIME, 1, this.fallTime);
    }

    public void setCanHurtEntities(boolean value) {
        this.canHurtEntities = value;
    }

    public boolean getCanHurtEntities() {
        return this.canHurtEntities;
    }

    @Override
    public Value<Boolean> canHurtEntities() {
        return new SpongeValue<Boolean>(Keys.FALLING_BLOCK_CAN_HURT_ENTITIES, false, this.canHurtEntities);
    }

    @Override
    public FallingBlockData copy() {
        return new SpongeFallingBlockData(this.fallDamagePerBlock, this.maxFallDamage, this.blockState, this.canPlaceAsBlock, this.canDropAsItem, this.fallTime, this.canHurtEntities);
    }

    @Override
    public ImmutableFallingBlockData asImmutable() {
        return new ImmutableSpongeFallingBlockData(this.fallDamagePerBlock, this.maxFallDamage, this.blockState, this.canPlaceAsBlock, this.canDropAsItem, this.fallTime, this.canHurtEntities);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.FALL_DAMAGE_PER_BLOCK.getQuery(), (Object)this.fallDamagePerBlock).set(Keys.MAX_FALL_DAMAGE.getQuery(), (Object)this.maxFallDamage).set(Keys.FALLING_BLOCK_STATE.getQuery(), (Object)this.blockState).set(Keys.CAN_PLACE_AS_BLOCK.getQuery(), (Object)this.canPlaceAsBlock).set(Keys.CAN_DROP_AS_ITEM.getQuery(), (Object)this.canDropAsItem).set(Keys.FALL_TIME.getQuery(), (Object)this.fallTime).set(Keys.FALLING_BLOCK_CAN_HURT_ENTITIES, (Object)this.canHurtEntities);
    }
}

