/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.entity;

import java.util.Optional;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableZombieData;
import org.spongepowered.api.data.manipulator.mutable.entity.ZombieData;
import org.spongepowered.api.data.type.Profession;
import org.spongepowered.api.data.type.ZombieType;
import org.spongepowered.api.data.value.mutable.OptionalValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.immutable.entity.ImmutableSpongeZombieData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.util.DataConstants;
import org.spongepowered.common.data.util.ImplementationRequiredForTest;
import org.spongepowered.common.data.value.mutable.SpongeOptionalValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

@ImplementationRequiredForTest
public class SpongeZombieData
extends AbstractData<ZombieData, ImmutableZombieData>
implements ZombieData {
    private ZombieType type;
    private Optional<Profession> profession;

    public SpongeZombieData() {
        this(DataConstants.Catalog.DEFAULT_ZOMBIE_TYPE, Optional.empty());
    }

    public SpongeZombieData(ZombieType type, Optional<Profession> profession) {
        super(ZombieData.class);
        this.type = type;
        this.profession = profession;
    }

    private ZombieType getType() {
        return this.type;
    }

    private void setType(ZombieType type) {
        this.type = type;
    }

    private Optional<Profession> getProfession() {
        return this.profession;
    }

    private void setProfession(Optional<Profession> profession) {
        this.profession = profession;
    }

    @Override
    public Value<ZombieType> type() {
        return new SpongeValue<ZombieType>(Keys.ZOMBIE_TYPE, DataConstants.Catalog.DEFAULT_ZOMBIE_TYPE, this.type);
    }

    @Override
    public OptionalValue<Profession> profession() {
        return new SpongeOptionalValue<Profession>(Keys.VILLAGER_ZOMBIE_PROFESSION, this.getProfession());
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerFieldGetter(Keys.ZOMBIE_TYPE, this::getType);
        this.registerFieldGetter(Keys.VILLAGER_ZOMBIE_PROFESSION, this::getProfession);
        this.registerFieldSetter(Keys.ZOMBIE_TYPE, this::setType);
        this.registerFieldSetter(Keys.VILLAGER_ZOMBIE_PROFESSION, this::setProfession);
        this.registerKeyValue(Keys.ZOMBIE_TYPE, this::type);
        this.registerKeyValue(Keys.VILLAGER_ZOMBIE_PROFESSION, this::profession);
    }

    @Override
    public ZombieData copy() {
        return new SpongeZombieData(this.type, this.profession);
    }

    @Override
    public ImmutableZombieData asImmutable() {
        return new ImmutableSpongeZombieData(this.type, this.profession);
    }

    @Override
    public DataContainer toContainer() {
        DataContainer data = super.toContainer();
        data.set(Keys.ZOMBIE_TYPE, (Object)this.getType());
        if (this.getProfession().isPresent()) {
            data.set(Keys.VILLAGER_ZOMBIE_PROFESSION.getQuery(), (Object)this.getProfession().get());
        }
        return data;
    }
}

