/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.tileentity;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.tileentity.ImmutableBannerData;
import org.spongepowered.api.data.manipulator.mutable.tileentity.BannerData;
import org.spongepowered.api.data.meta.PatternLayer;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.api.data.type.DyeColors;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.mutable.PatternListValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.immutable.tileentity.ImmutableSpongeBannerData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.util.ImplementationRequiredForTest;
import org.spongepowered.common.data.value.mutable.SpongePatternListValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

@ImplementationRequiredForTest
public class SpongeBannerData
extends AbstractData<BannerData, ImmutableBannerData>
implements BannerData {
    private DyeColor base;
    private List<PatternLayer> layers;

    public SpongeBannerData(DyeColor base, List<PatternLayer> layers) {
        super(BannerData.class);
        this.base = (DyeColor)Preconditions.checkNotNull((Object)base, (Object)"base");
        this.layers = Lists.newArrayList((Iterable)((Iterable)Preconditions.checkNotNull(layers, (Object)"layers")));
        this.registerGettersAndSetters();
    }

    public SpongeBannerData() {
        this(DyeColors.WHITE, Collections.emptyList());
    }

    public DyeColor getBase() {
        return this.base;
    }

    public void setBase(DyeColor base) {
        this.base = (DyeColor)Preconditions.checkNotNull((Object)base, (Object)"Null DyeColor!");
    }

    public List<PatternLayer> getLayers() {
        return Lists.newArrayList(this.layers);
    }

    public void setLayers(List<PatternLayer> layers) {
        this.layers = new ArrayList<PatternLayer>((Collection)Preconditions.checkNotNull(layers, (Object)"Null pattern layers!"));
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerFieldGetter(Keys.BANNER_BASE_COLOR, this::getBase);
        this.registerFieldSetter(Keys.BANNER_BASE_COLOR, this::setBase);
        this.registerKeyValue(Keys.BANNER_BASE_COLOR, this::baseColor);
        this.registerFieldGetter(Keys.BANNER_PATTERNS, this::getLayers);
        this.registerFieldSetter(Keys.BANNER_PATTERNS, this::setLayers);
        this.registerKeyValue(Keys.BANNER_PATTERNS, this::patternsList);
    }

    @Override
    public BannerData copy() {
        return new SpongeBannerData(this.base, this.layers);
    }

    @Override
    public ImmutableBannerData asImmutable() {
        return new ImmutableSpongeBannerData(this.base, this.layers);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.BANNER_BASE_COLOR.getQuery(), (Object)this.base.getId()).set(Keys.BANNER_PATTERNS, (Object)this.layers);
    }

    @Override
    public Value<DyeColor> baseColor() {
        return new SpongeValue<DyeColor>(Keys.BANNER_BASE_COLOR, DyeColors.WHITE, this.base);
    }

    @Override
    public PatternListValue patternsList() {
        return new SpongePatternListValue((Key<? extends BaseValue<List<PatternLayer>>>)Keys.BANNER_PATTERNS, this.getLayers());
    }
}

