/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.persistence;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.persistence.DataFormat;
import org.spongepowered.api.data.persistence.InvalidDataFormatException;
import org.spongepowered.common.SpongeCatalogType;
import org.spongepowered.common.data.persistence.ConfigurateTranslator;

public class HoconDataFormat
extends SpongeCatalogType
implements DataFormat {
    public HoconDataFormat(String id) {
        super(id);
    }

    @Override
    public DataContainer readFrom(InputStream input) throws InvalidDataFormatException, IOException {
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setSource(() -> new BufferedReader(new InputStreamReader(input)))).build();
        CommentedConfigurationNode node = (CommentedConfigurationNode)loader.load();
        return ConfigurateTranslator.instance().translateFrom(node);
    }

    @Override
    public void writeTo(OutputStream output, DataView data) throws IOException {
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setSink(() -> new BufferedWriter(new OutputStreamWriter(output)))).build();
        ConfigurationNode node = ConfigurateTranslator.instance().translateData(data);
        loader.save(node);
    }
}

