/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.persistence;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.tileentity.TileEntityArchetype;
import org.spongepowered.api.block.tileentity.TileEntityType;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.MemoryDataContainer;
import org.spongepowered.api.data.persistence.DataTranslator;
import org.spongepowered.api.data.persistence.DataTranslators;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.world.extent.worker.procedure.BlockVolumeVisitor;
import org.spongepowered.api.world.schematic.Schematic;
import org.spongepowered.common.block.SpongeTileEntityArchetypeBuilder;
import org.spongepowered.common.data.util.DataQueries;
import org.spongepowered.common.registry.type.block.TileEntityTypeRegistryModule;
import org.spongepowered.common.util.gen.CharArrayMutableBlockBuffer;
import org.spongepowered.common.world.schematic.GlobalPalette;
import org.spongepowered.common.world.schematic.SpongeSchematic;

public class LegacySchematicTranslator
implements DataTranslator<Schematic> {
    private static final LegacySchematicTranslator INSTANCE = new LegacySchematicTranslator();
    private static final TypeToken<Schematic> TYPE_TOKEN = TypeToken.of(Schematic.class);
    private static final int MAX_SIZE = 65535;
    private final Cause cause = Cause.source(this).build();

    public static LegacySchematicTranslator get() {
        return INSTANCE;
    }

    private LegacySchematicTranslator() {
    }

    @Override
    public String getId() {
        return "sponge:legacy_schematic";
    }

    @Override
    public String getName() {
        return "Legacy Schematic translator";
    }

    @Override
    public TypeToken<Schematic> getToken() {
        return TYPE_TOKEN;
    }

    @Override
    public Schematic translate(DataView view) throws InvalidDataException {
        String materials = view.getString(DataQueries.Schematic.LEGACY_MATERIALS).orElse("Sponge");
        if ("Sponge".equalsIgnoreCase(materials)) {
            return DataTranslators.SCHEMATIC.translate(view);
        }
        if (!"Alpha".equalsIgnoreCase(materials)) {
            throw new InvalidDataException(String.format("Schematic specifies unknown materials %s", materials));
        }
        int width = view.getShort(DataQueries.Schematic.WIDTH).get().shortValue();
        int height = view.getShort(DataQueries.Schematic.HEIGHT).get().shortValue();
        int length = view.getShort(DataQueries.Schematic.LENGTH).get().shortValue();
        if (width > 65535 || height > 65535 || length > 65535) {
            throw new InvalidDataException(String.format("Schematic is larger than maximum allowable size (found: (%d, %d, %d) max: (%d, %<d, %<d)", width, height, length, 65535));
        }
        int offsetX = view.getInt(DataQueries.Schematic.LEGACY_OFFSET_X).orElse(0);
        int offsetY = view.getInt(DataQueries.Schematic.LEGACY_OFFSET_Y).orElse(0);
        int offsetZ = view.getInt(DataQueries.Schematic.LEGACY_OFFSET_Z).orElse(0);
        GlobalPalette palette = GlobalPalette.instance;
        CharArrayMutableBlockBuffer buffer = new CharArrayMutableBlockBuffer(palette, new Vector3i(-offsetX, -offsetY, -offsetZ), new Vector3i(width, height, length));
        byte[] block_ids = (byte[])view.get(DataQueries.Schematic.LEGACY_BLOCKS).get();
        byte[] block_data = (byte[])view.get(DataQueries.Schematic.LEGACY_BLOCK_DATA).get();
        byte[] add_block = view.get(DataQueries.Schematic.LEGACY_ADD_BLOCKS).orElse(null);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    int index = (y * length + z) * width + x;
                    int palette_id = block_ids[index] << 4 | block_data[index] & 0xFF;
                    if (add_block != null) {
                        palette_id |= add_block[index] << 12;
                    }
                    BlockState block = palette.get(palette_id).get();
                    buffer.setBlock(x - offsetX, y - offsetY, z - offsetZ, block, this.cause);
                }
            }
        }
        HashMap tiles = Maps.newHashMap();
        List tiledata = view.getViewList(DataQueries.Schematic.LEGACY_TILEDATA).orElse(null);
        if (tiledata != null) {
            for (DataView tile : tiledata) {
                int x = tile.getInt(DataQueries.X_POS).get();
                int y = tile.getInt(DataQueries.Y_POS).get();
                int z = tile.getInt(DataQueries.Z_POS).get();
                CatalogType type = TileEntityTypeRegistryModule.getInstance().getForClass((Class)TileEntity.field_145855_i.get(tile.getString(DataQuery.of("id")).get()));
                TileEntityArchetype archetype = new SpongeTileEntityArchetypeBuilder().state(buffer.getBlock(x - offsetX, y - offsetY, z - offsetZ)).tileData(tile).tile((TileEntityType)type).build();
                tiles.put(new Vector3i(x - offsetX, y - offsetY, z - offsetZ), archetype);
            }
        }
        SpongeSchematic schematic = new SpongeSchematic(buffer, tiles);
        return schematic;
    }

    @Override
    public DataContainer translate(Schematic schematic) throws InvalidDataException {
        MemoryDataContainer data = new MemoryDataContainer(DataView.SafetyMode.NO_DATA_CLONED);
        int xMin = schematic.getBlockMin().getX();
        int yMin = schematic.getBlockMin().getY();
        int zMin = schematic.getBlockMin().getZ();
        int width = schematic.getBlockSize().getX();
        int height = schematic.getBlockSize().getY();
        int length = schematic.getBlockSize().getZ();
        if (width > 65535 || height > 65535 || length > 65535) {
            throw new IllegalArgumentException(String.format("Schematic is larger than maximum allowable size (found: (%d, %d, %d) max: (%d, %<d, %<d)", width, height, length, 65535));
        }
        data.set(DataQueries.Schematic.WIDTH, (Object)width);
        data.set(DataQueries.Schematic.HEIGHT, (Object)height);
        data.set(DataQueries.Schematic.LENGTH, (Object)length);
        data.set(DataQueries.Schematic.LEGACY_MATERIALS, (Object)"Alpha");
        data.set(DataQueries.Schematic.LEGACY_OFFSET_X, (Object)(-xMin));
        data.set(DataQueries.Schematic.LEGACY_OFFSET_Y, (Object)(-yMin));
        data.set(DataQueries.Schematic.LEGACY_OFFSET_Z, (Object)(-zMin));
        SaveIterator itr = new SaveIterator(width, height, length);
        schematic.getBlockWorker(this.cause).iterate(itr);
        byte[] blockids = itr.blockids;
        byte[] extraids = itr.extraids;
        byte[] blockdata = itr.blockdata;
        data.set(DataQueries.Schematic.LEGACY_BLOCKS, (Object)blockids);
        data.set(DataQueries.Schematic.LEGACY_BLOCK_DATA, (Object)blockdata);
        if (extraids != null) {
            data.set(DataQueries.Schematic.LEGACY_ADD_BLOCKS, (Object)extraids);
        }
        ArrayList tileEntities = Lists.newArrayList();
        for (Map.Entry<Vector3i, TileEntityArchetype> entry : schematic.getTileEntityArchetypes().entrySet()) {
            Vector3i pos = entry.getKey();
            DataContainer tiledata = entry.getValue().getTileData();
            tiledata.set(DataQueries.X_POS, (Object)(pos.getX() - xMin));
            tiledata.set(DataQueries.Y_POS, (Object)(pos.getY() - yMin));
            tiledata.set(DataQueries.Z_POS, (Object)(pos.getZ() - zMin));
            tileEntities.add(tiledata);
        }
        data.set(DataQueries.Schematic.LEGACY_TILEDATA, (Object)tileEntities);
        return data;
    }

    private static class SaveIterator
    implements BlockVolumeVisitor<Schematic> {
        private final int width;
        private final int length;
        public byte[] blockids;
        public byte[] extraids;
        public byte[] blockdata;

        public SaveIterator(int width, int height, int length) {
            this.width = width;
            this.length = length;
            this.blockids = new byte[width * height * length];
            this.extraids = null;
            this.blockdata = new byte[width * height * length];
        }

        @Override
        public void visit(Schematic volume, int x, int y, int z) {
            int x0 = x - volume.getBlockMin().getX();
            int y0 = y - volume.getBlockMin().getY();
            int z0 = z - volume.getBlockMin().getZ();
            int id = GlobalPalette.instance.get(volume.getBlock(x, y, z)).get();
            int blockid = id >> 4;
            int dataid = id & 0xF;
            int index = (y0 * this.length + z0) * this.width + x0;
            this.blockids[index] = (byte)(blockid & 0xFF);
            if (blockid > 255) {
                if (this.extraids == null) {
                    this.extraids = new byte[(this.blockdata.length >> 2) + 1];
                }
                this.extraids[index >> 1] = (byte)((index & 1) == 0 ? this.extraids[index >> 1] & 0xF0 | blockid >> 8 & 0xF : this.extraids[index >> 1] & 0xF | (blockid >> 8 & 0xF) << 4);
            }
            this.blockdata[index] = (byte)dataid;
        }
    }
}

