/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.common;

import com.google.common.collect.Iterables;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntitySkull;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.type.SkullType;
import org.spongepowered.api.data.type.SkullTypes;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.GameProfileManager;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.manipulator.mutable.SpongeRepresentedPlayerData;
import org.spongepowered.common.interfaces.block.tile.IMixinTileEntitySkull;

public class SkullUtils {
    public static final SkullType DEFAULT_TYPE = SkullTypes.SKELETON;

    public static boolean supportsObject(Object object) {
        return object instanceof TileEntitySkull || SkullUtils.isValidItemStack(object);
    }

    public static SkullType getSkullType(int skullType) {
        return (SkullType)Iterables.get(SpongeImpl.getRegistry().getAllOf(SkullType.class), (int)skullType);
    }

    public static boolean isValidItemStack(Object container) {
        return container instanceof ItemStack && ((ItemStack)container).func_77973_b().equals(Items.field_151144_bL);
    }

    public static SkullType getSkullType(TileEntitySkull tileEntitySkull) {
        return SkullUtils.getSkullType(tileEntitySkull.func_145904_a());
    }

    public static void setSkullType(TileEntitySkull tileEntitySkull, int skullType) {
        tileEntitySkull.func_152107_a(skullType);
        tileEntitySkull.func_70296_d();
        tileEntitySkull.func_145831_w().func_184138_a(tileEntitySkull.func_174877_v(), tileEntitySkull.func_145831_w().func_180495_p(tileEntitySkull.func_174877_v()), tileEntitySkull.func_145831_w().func_180495_p(tileEntitySkull.func_174877_v()), 3);
    }

    public static SkullType getSkullType(ItemStack itemStack) {
        return SkullUtils.getSkullType(itemStack.func_77960_j());
    }

    public static Optional<GameProfile> getProfile(TileEntitySkull entity) {
        return Optional.ofNullable((GameProfile)entity.func_152108_a());
    }

    public static boolean setProfile(TileEntitySkull tileEntitySkull, @Nullable GameProfile profile) {
        if (SkullUtils.getSkullType(tileEntitySkull).equals(SkullTypes.PLAYER)) {
            GameProfile newProfile = SpongeRepresentedPlayerData.NULL_PROFILE.equals(profile) ? null : SkullUtils.resolveProfileIfNecessary(profile);
            tileEntitySkull.func_152106_a((com.mojang.authlib.GameProfile)newProfile);
            tileEntitySkull.func_70296_d();
            tileEntitySkull.func_145831_w().func_184138_a(tileEntitySkull.func_174877_v(), tileEntitySkull.func_145831_w().func_180495_p(tileEntitySkull.func_174877_v()), tileEntitySkull.func_145831_w().func_180495_p(tileEntitySkull.func_174877_v()), 3);
            return true;
        }
        return false;
    }

    public static Optional<GameProfile> getProfile(ItemStack skull) {
        if (SkullUtils.isValidItemStack(skull) && SkullUtils.getSkullType(skull).equals(SkullTypes.PLAYER)) {
            NBTTagCompound nbt = skull.func_179543_a("SkullOwner", false);
            com.mojang.authlib.GameProfile mcProfile = nbt == null ? null : NBTUtil.func_152459_a((NBTTagCompound)nbt);
            return Optional.ofNullable((GameProfile)mcProfile);
        }
        return Optional.empty();
    }

    public static boolean setProfile(ItemStack skull, @Nullable GameProfile profile) {
        if (SkullUtils.isValidItemStack(skull) && SkullUtils.getSkullType(skull).equals(SkullTypes.PLAYER)) {
            if (profile == null || profile.equals(SpongeRepresentedPlayerData.NULL_PROFILE)) {
                if (skull.func_77978_p() != null) {
                    skull.func_77978_p().func_82580_o("SkullOwner");
                }
            } else {
                NBTTagCompound nbt = new NBTTagCompound();
                NBTUtil.func_180708_a((NBTTagCompound)nbt, (com.mojang.authlib.GameProfile)((com.mojang.authlib.GameProfile)SkullUtils.resolveProfileIfNecessary(profile)));
                skull.func_77983_a("SkullOwner", (NBTBase)nbt);
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static GameProfile resolveProfileIfNecessary(@Nullable GameProfile profile) {
        if (profile == null) {
            return null;
        }
        GameProfileManager resolver = Sponge.getGame().getServer().getGameProfileManager();
        if (!profile.getName().isPresent() || profile.getName().get().isEmpty()) {
            CompletableFuture<GameProfile> future = resolver.get(profile.getUniqueId());
            try {
                return future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                SpongeImpl.getLogger().debug("Exception while trying to resolve GameProfile: ", (Throwable)e);
                return null;
            }
        }
        if (profile.getUniqueId() == null) {
            CompletableFuture<GameProfile> future = resolver.get(profile.getName().get());
            try {
                return future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                SpongeImpl.getLogger().debug("Exception while trying to resolve GameProfile: ", (Throwable)e);
                return null;
            }
        }
        return profile;
    }

    public static void updatePlayerProfile(IMixinTileEntitySkull skull) {
        GameProfile profile = (GameProfile)skull.getPlayerProfile();
        if (profile != null && profile.getName().isPresent() && !profile.getName().get().isEmpty()) {
            if (profile.isFilled() && profile.getPropertyMap().containsKey((Object)"textures")) {
                skull.markDirty();
            } else {
                Sponge.getServer().getGameProfileManager().get(profile.getName().get()).handle((newProfile, thrown) -> {
                    if (newProfile != null) {
                        skull.setPlayerProfile((com.mojang.authlib.GameProfile)newProfile, false);
                        skull.markDirty();
                    } else {
                        SpongeImpl.getLogger().warn("Could not update player GameProfile for Skull: ", new Object[]{thrown.getMessage()});
                    }
                    return newProfile;
                });
            }
        } else {
            skull.markDirty();
        }
    }
}

