/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.PotionEffect;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.ImmutablePotionEffectData;
import org.spongepowered.api.data.manipulator.mutable.PotionEffectData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.ListValue;
import org.spongepowered.common.data.manipulator.mutable.SpongePotionEffectData;
import org.spongepowered.common.data.processor.common.AbstractSingleDataSingleTargetProcessor;
import org.spongepowered.common.data.util.PotionUtil;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeListValue;
import org.spongepowered.common.data.value.mutable.SpongeListValue;

public class EntityPotionDataProcessor
extends AbstractSingleDataSingleTargetProcessor<EntityLivingBase, List<org.spongepowered.api.effect.potion.PotionEffect>, ListValue<org.spongepowered.api.effect.potion.PotionEffect>, PotionEffectData, ImmutablePotionEffectData> {
    public EntityPotionDataProcessor() {
        super(Keys.POTION_EFFECTS, EntityLivingBase.class);
    }

    @Override
    protected boolean set(EntityLivingBase dataHolder, List<org.spongepowered.api.effect.potion.PotionEffect> value) {
        dataHolder.func_70674_bp();
        for (org.spongepowered.api.effect.potion.PotionEffect effect : value) {
            PotionEffect mcEffect = PotionUtil.copyToNative(effect);
            dataHolder.func_70690_d(mcEffect);
        }
        return true;
    }

    @Override
    protected Optional<List<org.spongepowered.api.effect.potion.PotionEffect>> getVal(EntityLivingBase dataHolder) {
        Collection effects = dataHolder.func_70651_bq();
        if (effects.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<org.spongepowered.api.effect.potion.PotionEffect> apiEffects = new ArrayList<org.spongepowered.api.effect.potion.PotionEffect>();
        for (PotionEffect potionEffect : effects) {
            apiEffects.add(PotionUtil.copyToApi(potionEffect));
        }
        return Optional.of(apiEffects);
    }

    @Override
    protected ImmutableValue<List<org.spongepowered.api.effect.potion.PotionEffect>> constructImmutableValue(List<org.spongepowered.api.effect.potion.PotionEffect> value) {
        return new ImmutableSpongeListValue<org.spongepowered.api.effect.potion.PotionEffect>(Keys.POTION_EFFECTS, ImmutableList.copyOf(value));
    }

    @Override
    protected ListValue<org.spongepowered.api.effect.potion.PotionEffect> constructValue(List<org.spongepowered.api.effect.potion.PotionEffect> actualValue) {
        return new SpongeListValue<org.spongepowered.api.effect.potion.PotionEffect>(Keys.POTION_EFFECTS, actualValue);
    }

    @Override
    protected PotionEffectData createManipulator() {
        return new SpongePotionEffectData();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (!(container instanceof EntityLivingBase)) {
            return DataTransactionResult.failNoData();
        }
        Optional<List<org.spongepowered.api.effect.potion.PotionEffect>> effects = this.getVal((EntityLivingBase)container);
        if (effects.isPresent()) {
            ((EntityLivingBase)container).func_70674_bp();
            return DataTransactionResult.successRemove(this.constructImmutableValue(effects.get()));
        }
        return DataTransactionResult.successNoData();
    }
}

