/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.entity.EntityLivingBase;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableFallDistanceData;
import org.spongepowered.api.data.manipulator.mutable.entity.FallDistanceData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeFallDistanceData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.value.SpongeValueFactory;

public class FallDistanceDataProcessor
extends AbstractEntitySingleDataProcessor<EntityLivingBase, Float, MutableBoundedValue<Float>, FallDistanceData, ImmutableFallDistanceData> {
    public FallDistanceDataProcessor() {
        super(EntityLivingBase.class, Keys.FALL_DISTANCE);
    }

    @Override
    protected boolean set(EntityLivingBase entity, Float value) {
        entity.field_70143_R = ((Float)Preconditions.checkNotNull((Object)value)).floatValue();
        return true;
    }

    @Override
    protected Optional<Float> getVal(EntityLivingBase entity) {
        return Optional.of(Float.valueOf(entity.field_70143_R));
    }

    @Override
    protected MutableBoundedValue<Float> constructValue(Float value) {
        return SpongeValueFactory.boundedBuilder(this.key).actualValue(value).defaultValue(Float.valueOf(0.0f)).minimum(Float.valueOf(0.0f)).maximum(Float.valueOf(Float.MAX_VALUE)).build();
    }

    @Override
    protected ImmutableValue<Float> constructImmutableValue(Float value) {
        return this.constructValue(value).asImmutable();
    }

    @Override
    protected FallDistanceData createManipulator() {
        return new SpongeFallDistanceData();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

