/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import java.util.Optional;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.GameType;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableGameModeData;
import org.spongepowered.api.data.manipulator.mutable.entity.GameModeData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeGameModeData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class GameModeDataProcessor
extends AbstractEntitySingleDataProcessor<EntityPlayerMP, GameMode, Value<GameMode>, GameModeData, ImmutableGameModeData> {
    public GameModeDataProcessor() {
        super(EntityPlayerMP.class, Keys.GAME_MODE);
    }

    @Override
    protected GameModeData createManipulator() {
        return new SpongeGameModeData();
    }

    @Override
    protected boolean set(EntityPlayerMP entity, GameMode value) {
        entity.func_71033_a((GameType)value);
        return true;
    }

    @Override
    protected Optional<GameMode> getVal(EntityPlayerMP entity) {
        return Optional.of((GameMode)entity.field_71134_c.func_73081_b());
    }

    @Override
    protected ImmutableValue<GameMode> constructImmutableValue(GameMode value) {
        return ImmutableSpongeValue.cachedOf(Keys.GAME_MODE, GameModes.SURVIVAL, value);
    }

    @Override
    protected Value<GameMode> constructValue(GameMode actualValue) {
        return new SpongeValue<GameMode>(Keys.GAME_MODE, GameModes.SURVIVAL, actualValue);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

