/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.passive.EntityHorse;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableTameableData;
import org.spongepowered.api.data.manipulator.mutable.entity.TameableData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.OptionalValue;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeTameableData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeOptionalValue;

public class HorseTameableDataProcessor
extends AbstractEntitySingleDataProcessor<EntityHorse, Optional<UUID>, OptionalValue<UUID>, TameableData, ImmutableTameableData> {
    public HorseTameableDataProcessor() {
        super(EntityHorse.class, Keys.TAMED_OWNER);
    }

    @Override
    protected Optional<Optional<UUID>> getVal(EntityHorse tameable) {
        return Optional.of(Optional.ofNullable(tameable.func_184780_dh()));
    }

    @Override
    public Optional<TameableData> fill(DataContainer container, TameableData tameableData) {
        if (!container.contains(Keys.TAMED_OWNER.getQuery())) {
            return Optional.empty();
        }
        String uuid = container.getString(Keys.TAMED_OWNER.getQuery()).get();
        if (uuid.equals("none")) {
            return Optional.of(tameableData);
        }
        UUID ownerUUID = UUID.fromString(uuid);
        return Optional.of(tameableData.set(Keys.TAMED_OWNER, Optional.of(ownerUUID)));
    }

    @Override
    protected boolean set(EntityHorse horse, Optional<UUID> uuidOptional) {
        horse.func_184779_b((UUID)uuidOptional.orElse(null));
        if (uuidOptional.isPresent()) {
            horse.func_110234_j(true);
        } else {
            horse.func_110234_j(false);
        }
        return true;
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }

    @Override
    protected OptionalValue<UUID> constructValue(Optional<UUID> defaultValue) {
        return new SpongeOptionalValue<UUID>(this.getKey(), defaultValue);
    }

    @Override
    protected ImmutableValue<Optional<UUID>> constructImmutableValue(Optional<UUID> value) {
        return new ImmutableSpongeValue<Optional<UUID>>(Keys.TAMED_OWNER, Optional.empty(), value);
    }

    @Override
    protected TameableData createManipulator() {
        return new SpongeTameableData();
    }
}

