/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutablePassengerData;
import org.spongepowered.api.data.manipulator.mutable.entity.PassengerData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableListValue;
import org.spongepowered.api.data.value.mutable.ListValue;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.util.GuavaCollectors;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongePassengerData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeListValue;
import org.spongepowered.common.data.value.mutable.SpongeListValue;
import org.spongepowered.common.entity.EntityUtil;

public class PassengerDataProcessor
extends AbstractEntitySingleDataProcessor<Entity, List<EntitySnapshot>, ListValue<EntitySnapshot>, PassengerData, ImmutablePassengerData> {
    public PassengerDataProcessor() {
        super(Entity.class, Keys.PASSENGERS);
    }

    @Override
    protected boolean set(Entity entity, List<EntitySnapshot> snapshots) {
        List passengers = snapshots.stream().map(EntitySnapshot::restore).filter(Optional::isPresent).map(Optional::get).map(EntityUtil::toNative).collect(Collectors.toList());
        for (Entity passenger : passengers) {
            if (entity.func_184196_w(passenger)) continue;
            entity.func_184188_bt().add(passenger);
        }
        return true;
    }

    @Override
    protected Optional<List<EntitySnapshot>> getVal(Entity dataHolder) {
        if (dataHolder.func_184188_bt().isEmpty()) {
            return Optional.empty();
        }
        List passengers = dataHolder.func_184188_bt().stream().map(EntityUtil::fromNative).map(org.spongepowered.api.entity.Entity::createSnapshot).collect(Collectors.toList());
        return Optional.of(passengers);
    }

    @Override
    protected ImmutableListValue<EntitySnapshot> constructImmutableValue(List<EntitySnapshot> value) {
        return new ImmutableSpongeListValue<EntitySnapshot>(Keys.PASSENGERS, ImmutableList.copyOf(value));
    }

    @Override
    protected ListValue<EntitySnapshot> constructValue(List<EntitySnapshot> actualValue) {
        return new SpongeListValue<EntitySnapshot>(Keys.PASSENGERS, actualValue);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (this.supports(container)) {
            Entity entity = (Entity)container;
            if (entity.func_184188_bt().isEmpty()) {
                ImmutableList passengers = entity.func_184188_bt().stream().map(EntityUtil::fromNative).map(org.spongepowered.api.entity.Entity::createSnapshot).collect(GuavaCollectors.toImmutableList());
                entity.func_184226_ay();
                return DataTransactionResult.builder().result(DataTransactionResult.Type.SUCCESS).replace(this.constructImmutableValue((List<EntitySnapshot>)passengers)).build();
            }
            return DataTransactionResult.successNoData();
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    public Optional<PassengerData> fill(DataContainer container, PassengerData passengerData) {
        passengerData.set(Keys.PASSENGERS, container.getSerializableList(Keys.PASSENGERS.getQuery(), EntitySnapshot.class).get());
        return Optional.of(passengerData);
    }

    @Override
    protected PassengerData createManipulator() {
        return new SpongePassengerData();
    }
}

