/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import java.util.Optional;
import net.minecraft.entity.monster.EntitySkeleton;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableSkeletonData;
import org.spongepowered.api.data.manipulator.mutable.entity.SkeletonData;
import org.spongepowered.api.data.type.SkeletonType;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeSkeletonData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.util.DataConstants;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class SkeletonDataProcessor
extends AbstractEntitySingleDataProcessor<EntitySkeleton, SkeletonType, Value<SkeletonType>, SkeletonData, ImmutableSkeletonData> {
    public SkeletonDataProcessor() {
        super(EntitySkeleton.class, Keys.SKELETON_TYPE);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> entity) {
        return DataTransactionResult.failNoData();
    }

    @Override
    protected boolean set(EntitySkeleton entity, SkeletonType value) {
        if (value instanceof net.minecraft.entity.monster.SkeletonType) {
            entity.func_189768_a((net.minecraft.entity.monster.SkeletonType)value);
            return true;
        }
        return false;
    }

    @Override
    protected Optional<SkeletonType> getVal(EntitySkeleton entity) {
        return Optional.ofNullable((SkeletonType)entity.func_189771_df());
    }

    @Override
    protected Value<SkeletonType> constructValue(SkeletonType actualValue) {
        return new SpongeValue<SkeletonType>(Keys.SKELETON_TYPE, DataConstants.Catalog.DEFAULT_SKELETON, actualValue);
    }

    @Override
    protected ImmutableValue<SkeletonType> constructImmutableValue(SkeletonType value) {
        return ImmutableSpongeValue.cachedOf(Keys.SKELETON_TYPE, DataConstants.Catalog.DEFAULT_SKELETON, value);
    }

    @Override
    protected SkeletonData createManipulator() {
        return new SpongeSkeletonData();
    }
}

