/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.monster.EntityZombie;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableZombieData;
import org.spongepowered.api.data.manipulator.mutable.entity.ZombieData;
import org.spongepowered.api.data.type.Profession;
import org.spongepowered.api.data.type.ZombieType;
import org.spongepowered.api.data.type.ZombieTypes;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeZombieData;
import org.spongepowered.common.data.processor.common.AbstractEntityDataProcessor;
import org.spongepowered.common.entity.EntityUtil;

public class ZombieDataProcessor
extends AbstractEntityDataProcessor<EntityZombie, ZombieData, ImmutableZombieData> {
    public ZombieDataProcessor() {
        super(EntityZombie.class);
    }

    @Override
    protected boolean doesDataExist(EntityZombie dataHolder) {
        return true;
    }

    @Override
    protected boolean set(EntityZombie dataHolder, Map<Key<?>, Object> keyValues) {
        ZombieType type = (ZombieType)keyValues.get(Keys.ZOMBIE_TYPE);
        Optional profession = (Optional)keyValues.get(Keys.VILLAGER_ZOMBIE_PROFESSION);
        dataHolder.func_189778_a(EntityUtil.toNative(type, profession.orElse(null)));
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(EntityZombie dataHolder) {
        HashMap values = Maps.newHashMap();
        net.minecraft.entity.monster.ZombieType nativeType = dataHolder.func_189777_di();
        ZombieType type = EntityUtil.typeFromNative(nativeType);
        values.put(Keys.ZOMBIE_TYPE, type);
        if (type != ZombieTypes.VILLAGER) {
            values.put(Keys.VILLAGER_ZOMBIE_PROFESSION, Optional.empty());
            return values;
        }
        values.put(Keys.VILLAGER_ZOMBIE_PROFESSION, EntityUtil.profFromNative(nativeType));
        return values;
    }

    @Override
    protected ZombieData createManipulator() {
        return new SpongeZombieData();
    }

    @Override
    public Optional<ZombieData> fill(DataContainer container, ZombieData zombieData) {
        if (container.contains(Keys.ZOMBIE_TYPE)) {
            zombieData.set(Keys.ZOMBIE_TYPE, container.getCatalogType(Keys.ZOMBIE_TYPE.getQuery(), ZombieType.class).get());
        }
        if (container.contains(Keys.VILLAGER_ZOMBIE_PROFESSION)) {
            zombieData.set(Keys.VILLAGER_ZOMBIE_PROFESSION, container.getCatalogType(Keys.VILLAGER_ZOMBIE_PROFESSION.getQuery(), Profession.class));
        }
        return Optional.of(zombieData);
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.failNoData();
    }
}

