/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.item;

import java.util.Optional;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.ImmutableFireworkRocketData;
import org.spongepowered.api.data.manipulator.mutable.FireworkRocketData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.common.data.manipulator.mutable.SpongeFireworkRocketData;
import org.spongepowered.common.data.processor.common.AbstractItemSingleDataProcessor;
import org.spongepowered.common.data.util.ComparatorUtil;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeBoundedValue;
import org.spongepowered.common.data.value.mutable.SpongeBoundedValue;

public class ItemFireworkRocketDataProcessor
extends AbstractItemSingleDataProcessor<Integer, MutableBoundedValue<Integer>, FireworkRocketData, ImmutableFireworkRocketData> {
    public ItemFireworkRocketDataProcessor() {
        super((ItemStack stack) -> stack.func_77973_b().equals(Items.field_151152_bP), Keys.FIREWORK_FLIGHT_MODIFIER);
    }

    @Override
    protected FireworkRocketData createManipulator() {
        return new SpongeFireworkRocketData();
    }

    @Override
    public boolean supports(EntityType entityType) {
        return entityType.equals(EntityTypes.FIREWORK);
    }

    @Override
    protected Optional<Integer> getVal(ItemStack itemStack) {
        NBTTagCompound fireworks = itemStack.func_179543_a("Fireworks", true);
        if (fireworks.func_74764_b("Flight")) {
            return Optional.of(Integer.valueOf(fireworks.func_74771_c("Flight")));
        }
        return Optional.empty();
    }

    @Override
    protected boolean set(ItemStack itemStack, Integer modifier) {
        NBTTagCompound fireworks = itemStack.func_179543_a("Fireworks", true);
        fireworks.func_74774_a("Flight", modifier.byteValue());
        return true;
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (container instanceof ItemStack) {
            NBTTagCompound fireworks = ((ItemStack)container).func_179543_a("Fireworks", false);
            if (fireworks != null) {
                fireworks.func_82580_o("Flight");
            }
            return DataTransactionResult.successNoData();
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    protected MutableBoundedValue<Integer> constructValue(Integer value) {
        return new SpongeBoundedValue<Integer>(Keys.FIREWORK_FLIGHT_MODIFIER, 0, ComparatorUtil.intComparator(), 0, Integer.MAX_VALUE, value);
    }

    @Override
    protected ImmutableValue<Integer> constructImmutableValue(Integer value) {
        return new ImmutableSpongeBoundedValue<Integer>(Keys.FIREWORK_FLIGHT_MODIFIER, value, 0, ComparatorUtil.intComparator(), 0, Integer.MAX_VALUE);
    }
}

