/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.item;

import java.util.Optional;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Items;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.item.ImmutableSpawnableData;
import org.spongepowered.api.data.manipulator.mutable.item.SpawnableData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.common.data.manipulator.mutable.item.SpongeSpawnableData;
import org.spongepowered.common.data.processor.common.AbstractItemSingleDataProcessor;
import org.spongepowered.common.data.util.NbtDataUtil;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.registry.type.entity.EntityTypeRegistryModule;

public class SpawnableDataProcessor
extends AbstractItemSingleDataProcessor<EntityType, Value<EntityType>, SpawnableData, ImmutableSpawnableData> {
    public SpawnableDataProcessor() {
        super((ItemStack input) -> input.func_77973_b().equals(Items.field_151063_bx), Keys.SPAWNABLE_ENTITY_TYPE);
    }

    @Override
    public boolean set(ItemStack itemStack, EntityType value) {
        String name = (String)EntityList.field_75626_c.get(value.getEntityClass());
        if (EntityList.field_75627_a.containsKey(name)) {
            NBTTagCompound mainCompound = NbtDataUtil.getOrCreateCompound(itemStack);
            NBTTagCompound subCompound = NbtDataUtil.getOrCreateSubCompound(mainCompound, "EntityTag");
            subCompound.func_74778_a("id", name);
            return true;
        }
        return false;
    }

    @Override
    public Optional<EntityType> getVal(ItemStack itemStack) {
        String name = ItemMonsterPlacer.func_185080_h((ItemStack)itemStack);
        if (name != null) {
            Class entity = (Class)EntityList.field_75625_b.get(name);
            return Optional.ofNullable(EntityTypeRegistryModule.getInstance().getForClass(entity));
        }
        return Optional.empty();
    }

    @Override
    protected Value<EntityType> constructValue(EntityType actualValue) {
        return new SpongeValue<EntityType>(Keys.SPAWNABLE_ENTITY_TYPE, EntityTypes.CREEPER, actualValue);
    }

    @Override
    public ImmutableValue<EntityType> constructImmutableValue(EntityType value) {
        return ImmutableSpongeValue.cachedOf(Keys.SPAWNABLE_ENTITY_TYPE, EntityTypes.CREEPER, value);
    }

    @Override
    public SpawnableData createManipulator() {
        return new SpongeSpawnableData();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (!this.supports(container)) {
            return DataTransactionResult.failNoData();
        }
        ItemStack itemStack = (ItemStack)container;
        Optional<EntityType> old = this.getVal(itemStack);
        if (!old.isPresent()) {
            return DataTransactionResult.successNoData();
        }
        try {
            NbtDataUtil.getItemCompound(itemStack).get().func_82580_o("EntityTag");
            return DataTransactionResult.successRemove(this.constructImmutableValue(old.get()));
        }
        catch (Exception e) {
            return DataTransactionResult.builder().result(DataTransactionResult.Type.ERROR).build();
        }
    }
}

