/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.passive.EntityHorse;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableHorseData;
import org.spongepowered.api.data.manipulator.mutable.entity.HorseData;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeHorseData;
import org.spongepowered.common.data.processor.common.AbstractEntityDataProcessor;
import org.spongepowered.common.data.processor.common.HorseUtils;
import org.spongepowered.common.entity.SpongeHorseColor;
import org.spongepowered.common.entity.SpongeHorseStyle;
import org.spongepowered.common.entity.SpongeHorseVariant;
import org.spongepowered.common.registry.SpongeGameRegistry;

public class HorseDataProcessor
extends AbstractEntityDataProcessor<EntityHorse, HorseData, ImmutableHorseData> {
    public HorseDataProcessor() {
        super(EntityHorse.class);
    }

    @Override
    protected HorseData createManipulator() {
        return new SpongeHorseData();
    }

    @Override
    protected boolean doesDataExist(EntityHorse entity) {
        return true;
    }

    @Override
    protected boolean set(EntityHorse entity, Map<Key<?>, Object> keyValues) {
        SpongeHorseColor horseColor = (SpongeHorseColor)keyValues.get(Keys.HORSE_COLOR);
        SpongeHorseStyle horseStyle = (SpongeHorseStyle)keyValues.get(Keys.HORSE_STYLE);
        SpongeHorseVariant horseVariant = (SpongeHorseVariant)keyValues.get(Keys.HORSE_VARIANT);
        int variant = HorseUtils.getInternalVariant(horseColor, horseStyle);
        entity.func_184778_a(horseVariant.getType());
        entity.func_110235_q(variant);
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(EntityHorse entity) {
        return ImmutableMap.of(Keys.HORSE_COLOR, (Object)HorseUtils.getHorseColor(entity), Keys.HORSE_STYLE, (Object)HorseUtils.getHorseStyle(entity), Keys.HORSE_VARIANT, (Object)HorseUtils.getHorseVariant(entity.func_184781_cZ()));
    }

    @Override
    public Optional<HorseData> fill(DataContainer container, HorseData horseData) {
        SpongeGameRegistry registry = SpongeImpl.getRegistry();
        horseData.set(Keys.HORSE_COLOR, HorseUtils.getHorseColor(container));
        horseData.set(Keys.HORSE_STYLE, HorseUtils.getHorseStyle(container));
        horseData.set(Keys.HORSE_VARIANT, HorseUtils.getHorseVariant(container));
        return Optional.of(horseData);
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.failNoData();
    }
}

