/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.Entity;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableIgniteableData;
import org.spongepowered.api.data.manipulator.mutable.entity.IgniteableData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeIgniteableData;
import org.spongepowered.common.data.processor.common.AbstractEntityDataProcessor;
import org.spongepowered.common.data.util.DataUtil;

public class IgniteableDataProcessor
extends AbstractEntityDataProcessor<Entity, IgniteableData, ImmutableIgniteableData> {
    public IgniteableDataProcessor() {
        super(Entity.class);
    }

    @Override
    public Optional<IgniteableData> fill(DataContainer container, IgniteableData igniteableData) {
        igniteableData.set(Keys.FIRE_TICKS, DataUtil.getData(container, Keys.FIRE_TICKS));
        igniteableData.set(Keys.FIRE_DAMAGE_DELAY, DataUtil.getData(container, Keys.FIRE_DAMAGE_DELAY));
        return Optional.of(igniteableData);
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        if (dataHolder instanceof Entity && ((Entity)dataHolder).field_70151_c > 0) {
            DataTransactionResult.Builder builder = DataTransactionResult.builder();
            builder.replace(((IgniteableData)this.from(dataHolder).get()).getValues());
            ((Entity)dataHolder).func_70066_B();
            return builder.result(DataTransactionResult.Type.SUCCESS).build();
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    protected IgniteableData createManipulator() {
        return new SpongeIgniteableData();
    }

    @Override
    protected boolean doesDataExist(Entity entity) {
        return entity.field_70151_c > 0;
    }

    @Override
    protected boolean set(Entity entity, Map<Key<?>, Object> keyValues) {
        entity.field_70151_c = (Integer)keyValues.get(Keys.FIRE_TICKS);
        entity.field_70174_ab = (Integer)keyValues.get(Keys.FIRE_DAMAGE_DELAY);
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(Entity entity) {
        int fireTicks = entity.field_70151_c;
        int fireDamageDelay = entity.field_70174_ab;
        return ImmutableMap.of(Keys.FIRE_TICKS, (Object)fireTicks, Keys.FIRE_DAMAGE_DELAY, (Object)fireDamageDelay);
    }
}

