/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.Entity;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableVehicleData;
import org.spongepowered.api.data.manipulator.mutable.entity.VehicleData;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeVehicleData;
import org.spongepowered.common.data.processor.common.AbstractEntityDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;

public class VehicleDataProcessor
extends AbstractEntityDataProcessor<Entity, VehicleData, ImmutableVehicleData> {
    public VehicleDataProcessor() {
        super(Entity.class);
    }

    @Override
    protected boolean doesDataExist(Entity entity) {
        return entity.field_184239_as != null;
    }

    @Override
    protected boolean set(Entity entity, Map<Key<?>, Object> keyValues) {
        return ((org.spongepowered.api.entity.Entity)entity).setVehicle(((EntitySnapshot)keyValues.get(Keys.VEHICLE)).restore().orElse(null)).isSuccessful();
    }

    @Override
    protected Map<Key<?>, ?> getValues(Entity entity) {
        return ImmutableMap.of(Keys.VEHICLE, (Object)((org.spongepowered.api.entity.Entity)entity.field_184239_as).createSnapshot(), Keys.BASE_VEHICLE, (Object)((org.spongepowered.api.entity.Entity)entity.func_184208_bv()).createSnapshot());
    }

    @Override
    public Optional<VehicleData> fill(DataContainer container, VehicleData vehicleData) {
        if (!container.contains(Keys.VEHICLE.getQuery(), Keys.BASE_VEHICLE.getQuery())) {
            return Optional.empty();
        }
        EntitySnapshot vehicle = container.getSerializable(Keys.VEHICLE.getQuery(), EntitySnapshot.class).get();
        EntitySnapshot baseVehicle = container.getSerializable(Keys.BASE_VEHICLE.getQuery(), EntitySnapshot.class).get();
        return Optional.of(((VehicleData)vehicleData.set(Keys.VEHICLE, vehicle)).set(Keys.BASE_VEHICLE, baseVehicle));
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        if (this.supports(dataHolder)) {
            Entity entity = (Entity)dataHolder;
            if (entity.field_184239_as != null) {
                EntitySnapshot previousVehicle = ((org.spongepowered.api.entity.Entity)entity.func_184187_bx()).createSnapshot();
                entity.func_184210_p();
                return DataTransactionResult.successResult(new ImmutableSpongeValue<EntitySnapshot>(Keys.VEHICLE, previousVehicle));
            }
            return DataTransactionResult.builder().result(DataTransactionResult.Type.SUCCESS).build();
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    protected VehicleData createManipulator() {
        return new SpongeVehicleData();
    }
}

