/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.tileentity;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.tileentity.TileEntityFurnace;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.tileentity.ImmutableFurnaceData;
import org.spongepowered.api.data.manipulator.mutable.tileentity.FurnaceData;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.manipulator.mutable.tileentity.SpongeFurnaceData;
import org.spongepowered.common.data.processor.common.AbstractTileEntityDataProcessor;
import org.spongepowered.common.data.util.ImplementationRequiredForTest;

@ImplementationRequiredForTest
public class FurnaceDataProcessor
extends AbstractTileEntityDataProcessor<TileEntityFurnace, FurnaceData, ImmutableFurnaceData> {
    private Cause cause;

    public FurnaceDataProcessor() {
        super(TileEntityFurnace.class);
    }

    @Override
    protected boolean doesDataExist(TileEntityFurnace tileEntity) {
        return true;
    }

    @Override
    protected boolean set(TileEntityFurnace tileEntity, Map<Key<?>, Object> keyValues) {
        boolean needsUpdate;
        if (this.cause == null) {
            this.cause = Cause.source(SpongeImpl.getPlugin()).build();
        }
        int passedBurnTime = (Integer)keyValues.get(Keys.PASSED_BURN_TIME);
        int maxBurnTime = (Integer)keyValues.get(Keys.MAX_BURN_TIME);
        int passedCookTime = (Integer)keyValues.get(Keys.PASSED_COOK_TIME);
        int maxCookTime = (Integer)keyValues.get(Keys.MAX_COOK_TIME);
        if (passedBurnTime > maxBurnTime || passedCookTime > maxCookTime) {
            return false;
        }
        boolean bl = needsUpdate = !tileEntity.func_145950_i() && maxBurnTime > 0 || tileEntity.func_145950_i() && maxBurnTime == 0;
        if (needsUpdate) {
            World world = (World)tileEntity.func_145831_w();
            world.setBlockType(tileEntity.func_174877_v().func_177958_n(), tileEntity.func_174877_v().func_177956_o(), tileEntity.func_174877_v().func_177952_p(), maxBurnTime > 0 ? BlockTypes.LIT_FURNACE : BlockTypes.FURNACE, this.cause);
            tileEntity = (TileEntityFurnace)tileEntity.func_145831_w().func_175625_s(tileEntity.func_174877_v());
        }
        tileEntity.func_174885_b(0, maxBurnTime - passedBurnTime);
        tileEntity.func_174885_b(1, maxBurnTime);
        tileEntity.func_174885_b(2, passedCookTime);
        tileEntity.func_174885_b(3, maxCookTime);
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(TileEntityFurnace tileEntity) {
        HashMap values = Maps.newHashMapWithExpectedSize((int)3);
        int passedBurnTime = tileEntity.func_174887_a_(1) - tileEntity.func_174887_a_(0);
        int maxBurnTime = tileEntity.func_174887_a_(1);
        int passedCookTime = tileEntity.func_174887_a_(2);
        int maxCookTime = tileEntity.func_174887_a_(3);
        values.put(Keys.PASSED_BURN_TIME, passedBurnTime);
        values.put(Keys.MAX_BURN_TIME, maxBurnTime);
        values.put(Keys.PASSED_COOK_TIME, passedCookTime);
        values.put(Keys.MAX_COOK_TIME, maxCookTime);
        return values;
    }

    @Override
    protected FurnaceData createManipulator() {
        return new SpongeFurnaceData();
    }

    @Override
    public Optional<FurnaceData> fill(DataContainer container, FurnaceData furnaceData) {
        if (!(container.contains(Keys.PASSED_BURN_TIME.getQuery()) && container.contains(Keys.MAX_BURN_TIME.getQuery()) && container.contains(Keys.PASSED_COOK_TIME.getQuery()) && container.contains(Keys.MAX_COOK_TIME.getQuery()))) {
            return Optional.empty();
        }
        int passedBurnTime = container.getInt(Keys.PASSED_BURN_TIME.getQuery()).get();
        int maxBurnTime = container.getInt(Keys.MAX_BURN_TIME.getQuery()).get();
        int passedCookTime = container.getInt(Keys.PASSED_COOK_TIME.getQuery()).get();
        int maxCookTime = container.getInt(Keys.MAX_COOK_TIME.getQuery()).get();
        furnaceData.set(Keys.PASSED_BURN_TIME, passedBurnTime);
        furnaceData.set(Keys.MAX_BURN_TIME, maxBurnTime);
        furnaceData.set(Keys.PASSED_COOK_TIME, passedCookTime);
        furnaceData.set(Keys.MAX_COOK_TIME, maxCookTime);
        return Optional.of(furnaceData);
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.failNoData();
    }
}

