/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.entity;

import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableBoundedValue;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.processor.common.ExperienceHolderUtils;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.interfaces.entity.player.IMixinEntityPlayerMP;

public class ExperienceLevelValueProcessor
extends AbstractSpongeValueProcessor<EntityPlayer, Integer, MutableBoundedValue<Integer>> {
    public ExperienceLevelValueProcessor() {
        super(EntityPlayer.class, Keys.EXPERIENCE_LEVEL);
    }

    @Override
    public DataTransactionResult offerToStore(ValueContainer<?> container, Integer value) {
        ImmutableBoundedValue<Integer> newValue = this.constructImmutableValue(value);
        if (this.supports(container)) {
            EntityPlayer player = (EntityPlayer)container;
            Integer oldValue = player.field_71068_ca;
            int totalExp = 0;
            for (int i = 0; i < value; ++i) {
                totalExp += ExperienceHolderUtils.getExpBetweenLevels(i);
            }
            player.field_71067_cb = totalExp;
            player.field_71106_cc = 0.0f;
            player.field_71068_ca = value;
            ((IMixinEntityPlayerMP)container).refreshExp();
            ImmutableBoundedValue<Integer> oldImmutableValue = this.constructImmutableValue(oldValue);
            return DataTransactionResult.successReplaceResult(newValue, oldImmutableValue);
        }
        return DataTransactionResult.failResult(newValue);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }

    @Override
    public MutableBoundedValue<Integer> constructValue(Integer defaultValue) {
        return SpongeValueFactory.boundedBuilder(Keys.EXPERIENCE_LEVEL).defaultValue(0).minimum(0).maximum(Integer.MAX_VALUE).actualValue(defaultValue).build();
    }

    @Override
    protected boolean set(EntityPlayer container, Integer value) {
        return false;
    }

    @Override
    protected Optional<Integer> getVal(EntityPlayer container) {
        return Optional.of(container.field_71068_ca);
    }

    @Override
    protected ImmutableBoundedValue<Integer> constructImmutableValue(Integer value) {
        return this.constructValue(value).asImmutable();
    }
}

