/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.entity;

import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.processor.common.ExperienceHolderUtils;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.interfaces.entity.player.IMixinEntityPlayerMP;

public class TotalExperienceValueProcessor
extends AbstractSpongeValueProcessor<EntityPlayer, Integer, MutableBoundedValue<Integer>> {
    public TotalExperienceValueProcessor() {
        super(EntityPlayer.class, Keys.TOTAL_EXPERIENCE);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }

    @Override
    public MutableBoundedValue<Integer> constructValue(Integer defaultValue) {
        return SpongeValueFactory.boundedBuilder(Keys.TOTAL_EXPERIENCE).defaultValue(0).minimum(0).maximum(Integer.MAX_VALUE).actualValue(defaultValue).build();
    }

    @Override
    protected boolean set(EntityPlayer container, Integer value) {
        int experienceForCurrentLevel;
        int level = -1;
        int experienceAtNextLevel = -1;
        do {
            experienceForCurrentLevel = experienceAtNextLevel;
        } while ((experienceAtNextLevel += ExperienceHolderUtils.getExpBetweenLevels(++level)) <= value);
        container.field_71106_cc = (float)(value - experienceForCurrentLevel) / (float)ExperienceHolderUtils.getExpBetweenLevels(level);
        container.field_71068_ca = level;
        container.field_71067_cb = value;
        ((IMixinEntityPlayerMP)container).refreshExp();
        return true;
    }

    @Override
    protected Optional<Integer> getVal(EntityPlayer container) {
        return Optional.of(container.field_71067_cb);
    }

    @Override
    protected ImmutableValue<Integer> constructImmutableValue(Integer value) {
        return this.constructValue(value).asImmutable();
    }
}

