/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.entity;

import java.util.Optional;
import net.minecraft.entity.monster.EntityZombie;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.ZombieType;
import org.spongepowered.api.data.type.ZombieTypes;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.util.DataConstants;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.entity.EntityUtil;

public class ZombieTypeValueProcessor
extends AbstractSpongeValueProcessor<EntityZombie, ZombieType, Value<ZombieType>> {
    public ZombieTypeValueProcessor() {
        super(EntityZombie.class, Keys.ZOMBIE_TYPE);
    }

    @Override
    protected Value<ZombieType> constructValue(ZombieType actualValue) {
        return new SpongeValue<ZombieType>(Keys.ZOMBIE_TYPE, DataConstants.Catalog.DEFAULT_ZOMBIE_TYPE, actualValue);
    }

    @Override
    protected boolean set(EntityZombie container, ZombieType value) {
        if (value == ZombieTypes.VILLAGER) {
            return false;
        }
        container.func_189778_a(EntityUtil.toNative(value, null));
        return true;
    }

    @Override
    protected Optional<ZombieType> getVal(EntityZombie container) {
        return Optional.of(EntityUtil.typeFromNative(container.func_189777_di()));
    }

    @Override
    protected ImmutableValue<ZombieType> constructImmutableValue(ZombieType value) {
        return ImmutableSpongeValue.cachedOf(Keys.ZOMBIE_TYPE, DataConstants.Catalog.DEFAULT_ZOMBIE_TYPE, value);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

