/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.item;

import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.value.SpongeValueFactory;

public abstract class AbstractHideFlagsValueProcessor
extends AbstractSpongeValueProcessor<ItemStack, Boolean, Value<Boolean>> {
    private final int flag;

    protected AbstractHideFlagsValueProcessor(Key<Value<Boolean>> key, int flag) {
        super(ItemStack.class, key);
        this.flag = flag;
    }

    @Override
    protected Value<Boolean> constructValue(Boolean actualValue) {
        return SpongeValueFactory.getInstance().createValue(this.key, actualValue, false);
    }

    @Override
    protected boolean set(ItemStack container, Boolean value) {
        if (!container.func_77942_o()) {
            container.func_77982_d(new NBTTagCompound());
        }
        if (container.func_77978_p().func_150297_b("HideFlags", 3)) {
            int flag = container.func_77978_p().func_74762_e("HideFlags");
            if (value.booleanValue()) {
                container.func_77978_p().func_74768_a("HideFlags", flag | this.flag);
            } else {
                container.func_77978_p().func_74768_a("HideFlags", flag & ~this.flag);
            }
        } else if (value.booleanValue()) {
            container.func_77978_p().func_74768_a("HideFlags", this.flag);
        }
        return true;
    }

    @Override
    protected Optional<Boolean> getVal(ItemStack container) {
        if (container.func_77942_o() && container.func_77978_p().func_150297_b("HideFlags", 3)) {
            int flag = container.func_77978_p().func_74762_e("HideFlags");
            if ((flag & this.flag) != 0) {
                return Optional.of(true);
            }
            return Optional.of(false);
        }
        return Optional.of(false);
    }

    @Override
    protected ImmutableValue<Boolean> constructImmutableValue(Boolean value) {
        return this.constructValue(value).asImmutable();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

