/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.property;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.data.Property;
import org.spongepowered.api.data.property.PropertyHolder;
import org.spongepowered.api.data.property.PropertyRegistry;
import org.spongepowered.api.data.property.PropertyStore;
import org.spongepowered.common.data.property.PropertyStoreDelegate;
import org.spongepowered.common.data.util.ComparatorUtil;

public class SpongePropertyRegistry
implements PropertyRegistry {
    private static final SpongePropertyRegistry INSTANCE = new SpongePropertyRegistry();
    private final Map<Class<? extends Property<?, ?>>, List<PropertyStore<?>>> propertyStoreMap = Maps.newConcurrentMap();
    private final Map<Class<? extends Property<?, ?>>, PropertyStoreDelegate<?>> delegateMap = Maps.newConcurrentMap();
    private static boolean allowRegistrations = true;

    private SpongePropertyRegistry() {
    }

    public static SpongePropertyRegistry getInstance() {
        return INSTANCE;
    }

    public static void completeRegistration() {
        allowRegistrations = false;
        SpongePropertyRegistry registry = SpongePropertyRegistry.getInstance();
        for (Map.Entry<Class<Property<?, ?>>, List<PropertyStore<?>>> entry : registry.propertyStoreMap.entrySet()) {
            ImmutableList.Builder propertyStoreBuilder = ImmutableList.builder();
            Collections.sort(entry.getValue(), ComparatorUtil.PROPERTY_STORE_COMPARATOR);
            propertyStoreBuilder.addAll((Iterable)entry.getValue());
            PropertyStoreDelegate delegate = new PropertyStoreDelegate(propertyStoreBuilder.build());
            registry.delegateMap.put(entry.getKey(), delegate);
        }
        registry.propertyStoreMap.clear();
    }

    @Override
    public <T extends Property<?, ?>> void register(Class<T> propertyClass, PropertyStore<T> propertyStore) {
        Preconditions.checkState((boolean)allowRegistrations, (Object)"Registrations are no longer allowed!");
        Preconditions.checkArgument((propertyClass != null ? 1 : 0) != 0, (Object)"The property class can not be null!");
        if (!this.propertyStoreMap.containsKey(propertyClass)) {
            this.propertyStoreMap.put(propertyClass, Collections.synchronizedList(Lists.newArrayList()));
        }
        List<PropertyStore<?>> propertyStores = this.propertyStoreMap.get(propertyClass);
        propertyStores.add((PropertyStore<?>)Preconditions.checkNotNull(propertyStore));
    }

    @Override
    public <T extends Property<?, ?>> Optional<PropertyStore<T>> getStore(Class<T> propertyClass) {
        Preconditions.checkArgument((propertyClass != null ? 1 : 0) != 0, (Object)"The property class can not be null!");
        if (!this.delegateMap.containsKey(propertyClass)) {
            return Optional.empty();
        }
        return Optional.of((PropertyStore)this.delegateMap.get(propertyClass));
    }

    public Collection<Property<?, ?>> getPropertiesFor(PropertyHolder holder) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry<Class<Property<?, ?>>, PropertyStoreDelegate<?>> entry : this.delegateMap.entrySet()) {
            Optional<?> optional = entry.getValue().getFor(holder);
            if (!optional.isPresent()) continue;
            builder.add(optional.get());
        }
        return builder.build();
    }
}

