/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.type;

import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.Property;
import org.spongepowered.api.data.property.PropertyStore;
import org.spongepowered.api.extra.fluid.FluidType;
import org.spongepowered.common.SpongeCatalogType;
import org.spongepowered.common.data.property.SpongePropertyRegistry;

public final class SpongeCommonFluidType
extends SpongeCatalogType
implements FluidType {
    @Nullable
    private final BlockType base;

    public SpongeCommonFluidType(String id) {
        this(id, null);
    }

    public SpongeCommonFluidType(String id, BlockType base) {
        super(id);
        this.base = base;
    }

    @Override
    public Optional<BlockType> getBlockTypeBase() {
        return Optional.ofNullable(this.base);
    }

    @Override
    public <T extends Property<?, ?>> Optional<T> getProperty(Class<T> propertyClass) {
        Optional<PropertyStore<T>> optional = SpongePropertyRegistry.getInstance().getStore(propertyClass);
        if (optional.isPresent()) {
            return optional.get().getFor(this);
        }
        return Optional.empty();
    }

    @Override
    public Collection<Property<?, ?>> getApplicableProperties() {
        return SpongePropertyRegistry.getInstance().getPropertiesFor(this);
    }
}

