/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.type;

import org.spongepowered.api.data.type.SkullType;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.common.SpongeCatalogType;
import org.spongepowered.common.text.translation.SpongeTranslation;

public class SpongeSkullType
extends SpongeCatalogType.Translatable
implements SkullType {
    private final byte id;

    public SpongeSkullType(byte dataId, String name) {
        this(dataId, name, SpongeSkullType.translate(name));
    }

    public SpongeSkullType(byte dataId, String name, Translation translation) {
        super(name, translation);
        this.id = dataId;
    }

    protected static Translation translate(String name) {
        if (name.equalsIgnoreCase("SKELETON")) {
            return new SpongeTranslation("item.skull.skeleton.name");
        }
        if (name.equalsIgnoreCase("WITHER_SKELETON")) {
            return new SpongeTranslation("item.skull.wither.name");
        }
        if (name.equalsIgnoreCase("ZOMBIE")) {
            return new SpongeTranslation("item.skull.zombie.name");
        }
        if (name.equalsIgnoreCase("PLAYER")) {
            return new SpongeTranslation("item.skull.char.name");
        }
        if (name.equalsIgnoreCase("CREEPER")) {
            return new SpongeTranslation("item.skull.creeper.name");
        }
        if (name.equalsIgnoreCase("ENDER_DRAGON")) {
            return new SpongeTranslation("item.skull.dragon.name");
        }
        throw new IllegalArgumentException("Unsupported Skull Type \"" + name + "\"!");
    }

    public byte getByteId() {
        return this.id;
    }
}

