/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.type;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.block.tileentity.TileEntityType;
import org.spongepowered.common.SpongeCatalogType;
import org.spongepowered.common.SpongeImplHooks;

public class SpongeTileEntityType
extends SpongeCatalogType
implements TileEntityType {
    private final String name;
    private final String modId;
    private final Class<? extends TileEntity> clazz;
    private final boolean canTick;

    public SpongeTileEntityType(Class<? extends TileEntity> clazz, String name, String id, boolean canTick) {
        super(id);
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.clazz = (Class)Preconditions.checkNotNull(clazz, (Object)"clazz");
        this.canTick = canTick;
        this.modId = SpongeImplHooks.getModIdFromClass(clazz);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getModId() {
        return this.modId;
    }

    public boolean canTick() {
        return this.canTick;
    }

    @Override
    public Class<? extends TileEntity> getTileEntityType() {
        return this.clazz;
    }

    @Override
    protected Objects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("TileEntityClass", this.clazz);
    }
}

