/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.util;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.MemoryDataContainer;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.DataManipulatorBuilder;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.fixer.entity.EntityTrackedUser;
import org.spongepowered.common.data.fixer.entity.player.PlayerRespawnData;
import org.spongepowered.common.data.fixer.world.SpongeLevelFixer;
import org.spongepowered.common.data.util.DataQueries;

public class DataUtil {
    public static final int DATA_VERSION = 1;
    public static final DataFixer spongeDataFixer = new DataFixer(1);
    private static final Supplier<InvalidDataException> INVALID_DATA_EXCEPTION_SUPPLIER = InvalidDataException::new;

    public static DataView checkDataExists(DataView dataView, DataQuery query) throws InvalidDataException {
        if (!((DataView)Preconditions.checkNotNull((Object)dataView)).contains((DataQuery)Preconditions.checkNotNull((Object)query))) {
            throw new InvalidDataException("Missing data for query: " + query.asString('.'));
        }
        return dataView;
    }

    public static <T> T getData(DataView dataView, Key<? extends BaseValue<T>> key) throws InvalidDataException {
        DataUtil.checkDataExists(dataView, ((Key)Preconditions.checkNotNull(key)).getQuery());
        Object object = dataView.get(key.getQuery()).get();
        return (T)object;
    }

    public static <T> T getData(DataView dataView, Key<?> key, Class<T> clazz) throws InvalidDataException {
        DataUtil.checkDataExists(dataView, ((Key)Preconditions.checkNotNull(key)).getQuery());
        Object object = dataView.get(key.getQuery()).get();
        if (clazz.isInstance(object)) {
            return (T)object;
        }
        throw new InvalidDataException("Could not cast to the correct class type!");
    }

    public static <T> T getData(DataView dataView, DataQuery query, Class<T> data) throws InvalidDataException {
        DataUtil.checkDataExists(dataView, query);
        Object object = dataView.get(query).get();
        if (data.isInstance(object)) {
            return (T)object;
        }
        throw new InvalidDataException("Data does not match!");
    }

    public static List<DataView> getSerializedManipulatorList(Iterable<DataManipulator<?, ?>> manipulators) {
        Preconditions.checkNotNull(manipulators);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DataManipulator<?, ?> manipulator : manipulators) {
            MemoryDataContainer container = new MemoryDataContainer();
            container.set(DataQueries.DATA_CLASS, (Object)manipulator.getClass().getName()).set(DataQueries.INTERNAL_DATA, (Object)manipulator.toContainer());
            builder.add((Object)container);
        }
        return builder.build();
    }

    public static List<DataView> getSerializedImmutableManipulatorList(Iterable<ImmutableDataManipulator<?, ?>> manipulators) {
        Preconditions.checkNotNull(manipulators);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ImmutableDataManipulator<?, ?> manipulator : manipulators) {
            MemoryDataContainer container = new MemoryDataContainer();
            container.set(DataQueries.DATA_CLASS, (Object)manipulator.getClass().getName()).set(DataQueries.INTERNAL_DATA, (Object)manipulator.toContainer());
            builder.add((Object)container);
        }
        return builder.build();
    }

    public static ImmutableList<DataManipulator<?, ?>> deserializeManipulatorList(List<DataView> containers) {
        Preconditions.checkNotNull(containers);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DataView view : containers) {
            String clazzName = view.getString(DataQueries.DATA_CLASS).get();
            DataView manipulatorView = view.getView(DataQueries.INTERNAL_DATA).get();
            try {
                Optional manipulatorOptional;
                Class<?> clazz = Class.forName(clazzName);
                Optional<DataBuilder<?>> optional = SpongeDataManager.getInstance().getBuilder(clazz);
                if (!optional.isPresent() || !(manipulatorOptional = ((DataManipulatorBuilder)optional.get()).build(manipulatorView)).isPresent()) continue;
                builder.add(manipulatorOptional.get());
            }
            catch (Exception e) {
                new InvalidDataException("Could not translate " + clazzName + "! Don't worry though, we'll try to translate the rest of the data.", e).printStackTrace();
            }
        }
        return builder.build();
    }

    public static ImmutableList<ImmutableDataManipulator<?, ?>> deserializeImmutableManipulatorList(List<DataView> containers) {
        Preconditions.checkNotNull(containers);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DataView view : containers) {
            String clazzName = view.getString(DataQueries.DATA_CLASS).get();
            DataView manipulatorView = view.getView(DataQueries.INTERNAL_DATA).get();
            try {
                Optional manipulatorOptional;
                Class<?> clazz = Class.forName(clazzName);
                Optional optional = SpongeDataManager.getInstance().getImmutableManipulatorBuilder(clazz);
                if (!optional.isPresent() || !(manipulatorOptional = optional.get().build(manipulatorView)).isPresent()) continue;
                builder.add(((DataManipulator)manipulatorOptional.get()).asImmutable());
            }
            catch (Exception e) {
                new InvalidDataException("Could not translate " + clazzName + "!", e).printStackTrace();
            }
        }
        return builder.build();
    }

    public static Location<World> getLocation(DataView view, boolean castToInt) {
        UUID worldUuid = UUID.fromString(view.getString(Queries.WORLD_ID).get());
        double x = view.getDouble(Queries.POSITION_X).get();
        double y = view.getDouble(Queries.POSITION_Y).get();
        double z = view.getDouble(Queries.POSITION_Z).get();
        if (castToInt) {
            return new Location<Extent>((Extent)SpongeImpl.getGame().getServer().getWorld(worldUuid).get(), (int)x, (int)y, (int)z);
        }
        return new Location<Extent>((Extent)SpongeImpl.getGame().getServer().getWorld(worldUuid).get(), x, y, z);
    }

    public static Vector3i getPosition3i(DataView view) {
        return DataUtil.getPosition3i(view, DataQueries.SNAPSHOT_WORLD_POSITION);
    }

    public static Vector3i getPosition3i(DataView view, DataQuery query) {
        DataUtil.checkDataExists(view, DataQueries.SNAPSHOT_WORLD_POSITION);
        DataView internal = view.getView(DataQueries.SNAPSHOT_WORLD_POSITION).get();
        int x = internal.getInt(Queries.POSITION_X).get();
        int y = internal.getInt(Queries.POSITION_Y).get();
        int z = internal.getInt(Queries.POSITION_Z).get();
        return new Vector3i(x, y, z);
    }

    public static Vector3d getPosition3d(DataView view) {
        return DataUtil.getPosition3d(view, DataQueries.SNAPSHOT_WORLD_POSITION);
    }

    public static Vector3d getPosition3d(DataView view, DataQuery query) {
        DataUtil.checkDataExists(view, query);
        DataView internal = view.getView(query).get();
        double x = internal.getDouble(Queries.POSITION_X).get();
        double y = internal.getDouble(Queries.POSITION_Y).get();
        double z = internal.getDouble(Queries.POSITION_Z).get();
        return new Vector3d(x, y, z);
    }

    public static Supplier<InvalidDataException> dataNotFound() {
        return INVALID_DATA_EXCEPTION_SUPPLIER;
    }

    static {
        spongeDataFixer.func_188256_a((IFixType)FixTypes.LEVEL, (IFixableData)new SpongeLevelFixer());
        spongeDataFixer.func_188256_a((IFixType)FixTypes.ENTITY, (IFixableData)new EntityTrackedUser());
        spongeDataFixer.func_188256_a((IFixType)FixTypes.PLAYER, (IFixableData)new PlayerRespawnData());
    }
}

