/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.effect.particle;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.MemoryDataContainer;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.particle.ParticleOption;
import org.spongepowered.common.data.util.DataQueries;
import org.spongepowered.common.effect.particle.ICachedParticleEffect;
import org.spongepowered.common.effect.particle.SpongeParticleType;

public class SpongeParticleEffect
implements ParticleEffect {
    @Nullable
    ICachedParticleEffect cachedParticle;
    private final SpongeParticleType type;
    private final Map<ParticleOption<?>, Object> options;

    public SpongeParticleEffect(SpongeParticleType type, Map<ParticleOption<?>, Object> options) {
        this.options = ImmutableMap.copyOf(options);
        this.type = type;
    }

    @Override
    public SpongeParticleType getType() {
        return this.type;
    }

    @Override
    public <V> Optional<V> getOption(ParticleOption<V> option) {
        return Optional.ofNullable(this.options.get(option));
    }

    @Override
    public Map<ParticleOption<?>, Object> getOptions() {
        return this.options;
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        MemoryDataContainer dataContainer = new MemoryDataContainer();
        dataContainer.set(DataQueries.PARTICLE_TYPE, (Object)this.type);
        dataContainer.set(DataQueries.PARTICLE_OPTIONS, this.options.entrySet().stream().map(entry -> new MemoryDataContainer().set(DataQueries.PARTICLE_OPTION_KEY, entry.getKey()).set(DataQueries.PARTICLE_OPTION_VALUE, entry.getValue())).collect(Collectors.toList()));
        return dataContainer;
    }
}

