/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.network.play.server.SPacketDestroyEntities;
import net.minecraft.network.play.server.SPacketEffect;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketEntityStatus;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.network.play.server.SPacketSpawnPainting;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.type.Profession;
import org.spongepowered.api.data.type.Professions;
import org.spongepowered.api.data.type.ZombieType;
import org.spongepowered.api.data.type.ZombieTypes;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.event.cause.entity.spawn.EntitySpawnCause;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.cause.entity.teleport.PortalTeleportCause;
import org.spongepowered.api.event.cause.entity.teleport.TeleportTypes;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.Dimension;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.PortalAgent;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.type.ConfigBase;
import org.spongepowered.common.entity.SpongeProfession;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.ItemDropData;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.entity.EntityPhase;
import org.spongepowered.common.interfaces.IMixinPlayerList;
import org.spongepowered.common.interfaces.entity.IMixinEntity;
import org.spongepowered.common.interfaces.entity.player.IMixinEntityPlayer;
import org.spongepowered.common.interfaces.entity.player.IMixinEntityPlayerMP;
import org.spongepowered.common.interfaces.network.IMixinNetHandlerPlayServer;
import org.spongepowered.common.interfaces.world.IMixinTeleporter;
import org.spongepowered.common.interfaces.world.IMixinWorldProvider;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.registry.type.entity.ProfessionRegistryModule;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.WorldManager;

public final class EntityUtil {
    public static final BlockPos HANGING_OFFSET_EAST = new BlockPos(1, 1, 0);
    public static final BlockPos HANGING_OFFSET_WEST = new BlockPos(-1, 1, 0);
    public static final BlockPos HANGING_OFFSET_NORTH = new BlockPos(0, 1, -1);
    public static final BlockPos HANGING_OFFSET_SOUTH = new BlockPos(0, 1, 1);
    private static final BiMap<Profession, net.minecraft.entity.monster.ZombieType> ZOMBIE_TYPE_MAP = ImmutableBiMap.builder().put((Object)Professions.BLACKSMITH, (Object)net.minecraft.entity.monster.ZombieType.VILLAGER_SMITH).put((Object)Professions.BUTCHER, (Object)net.minecraft.entity.monster.ZombieType.VILLAGER_BUTCHER).put((Object)Professions.FARMER, (Object)net.minecraft.entity.monster.ZombieType.VILLAGER_FARMER).put((Object)Professions.LIBRARIAN, (Object)net.minecraft.entity.monster.ZombieType.VILLAGER_LIBRARIAN).put((Object)Professions.PRIEST, (Object)net.minecraft.entity.monster.ZombieType.VILLAGER_PRIEST).build();
    static final Predicate<net.minecraft.entity.Entity> TRACEABLE = Predicates.and((Predicate)EntitySelectors.field_180132_d, (Predicate)new Predicate<net.minecraft.entity.Entity>(){

        public boolean apply(net.minecraft.entity.Entity entity) {
            return entity != null && entity.func_70067_L();
        }
    });
    public static boolean tempIsBedSpawn = false;

    private EntityUtil() {
    }

    @Nullable
    public static net.minecraft.entity.Entity transferEntityToDimension(IMixinEntity mixinEntity, int toSuggestedDimension) {
        net.minecraft.entity.Entity entity = EntityUtil.toNative(mixinEntity);
        MoveEntityEvent.Teleport.Portal event = EntityUtil.handleDisplaceEntityPortalEvent(entity, toSuggestedDimension, null);
        if (event == null || event.isCancelled()) {
            return null;
        }
        entity.field_70170_p.field_72984_F.func_76320_a("changeDimension");
        Transform<World> toTransform = event.getToTransform();
        WorldServer toWorld = (WorldServer)toTransform.getExtent();
        entity.field_70170_p.func_72900_e(entity);
        entity.field_70128_L = false;
        entity.field_70170_p.field_72984_F.func_76320_a("reposition");
        Vector3i toChunkPosition = toTransform.getLocation().getChunkPosition();
        toWorld.func_72863_F().func_186028_c(toChunkPosition.getX(), toChunkPosition.getZ());
        Vector3d toPosition = toTransform.getPosition();
        entity.func_70012_b(toPosition.getX(), toPosition.getY(), toPosition.getZ(), (float)toTransform.getYaw(), (float)toTransform.getPitch());
        entity.field_70170_p = toWorld;
        toWorld.func_72838_d(entity);
        toWorld.func_72866_a(entity, false);
        entity.field_70170_p.field_72984_F.func_76319_b();
        entity.field_70170_p.field_72984_F.func_76319_b();
        entity.field_70170_p.field_72984_F.func_76319_b();
        return entity;
    }

    @Nullable
    public static net.minecraft.entity.Entity teleportPlayerToDimension(EntityPlayerMP entityPlayerMP, int suggestedDimensionId) {
        WorldServer toWorld = SpongeImpl.getServer().func_71218_a(suggestedDimensionId);
        MoveEntityEvent.Teleport.Portal event = EntityUtil.handleDisplaceEntityPortalEvent((net.minecraft.entity.Entity)entityPlayerMP, suggestedDimensionId, toWorld.func_85176_s());
        if (event == null || event.isCancelled()) {
            return entityPlayerMP;
        }
        boolean sameDimension = entityPlayerMP.field_71093_bK == suggestedDimensionId;
        WorldServer fromWorldServer = (WorldServer)event.getFromTransform().getExtent();
        if (fromWorldServer.field_73011_w instanceof WorldProviderEnd && suggestedDimensionId == 1) {
            fromWorldServer.func_72900_e((net.minecraft.entity.Entity)entityPlayerMP);
            if (!entityPlayerMP.field_71136_j) {
                entityPlayerMP.field_71136_j = true;
                if (entityPlayerMP.func_189102_a(AchievementList.field_187971_D)) {
                    entityPlayerMP.field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(4, 0.0f));
                } else {
                    entityPlayerMP.func_71029_a((StatBase)AchievementList.field_187971_D);
                    entityPlayerMP.field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(4, 1.0f));
                }
            }
            return entityPlayerMP;
        }
        WorldServer toWorldServer = (WorldServer)event.getToTransform().getExtent();
        if (!sameDimension && fromWorldServer == toWorldServer) {
            return entityPlayerMP;
        }
        int targetDimensionId = ((IMixinWorldServer)toWorldServer).getDimensionId();
        if (fromWorldServer.field_73011_w instanceof WorldProviderSurface) {
            if (targetDimensionId == 1) {
                entityPlayerMP.func_71029_a((StatBase)AchievementList.field_76002_B);
            } else if (targetDimensionId == -1) {
                entityPlayerMP.func_71029_a((StatBase)AchievementList.field_187997_y);
            }
        }
        EntityUtil.transferPlayerToDimension(event, entityPlayerMP);
        entityPlayerMP.field_71135_a.func_147359_a((Packet)new SPacketEffect(1032, BlockPos.field_177992_a, 0, false));
        return entityPlayerMP;
    }

    public static void transferPlayerToDimension(MoveEntityEvent.Teleport.Portal event, EntityPlayerMP playerIn) {
        WorldServer fromWorld = (WorldServer)event.getFromTransform().getExtent();
        WorldServer toWorld = (WorldServer)event.getToTransform().getExtent();
        playerIn.field_71093_bK = WorldManager.getClientDimensionId(playerIn, (net.minecraft.world.World)toWorld);
        toWorld.func_72863_F().func_186028_c(event.getToTransform().getLocation().getChunkPosition().getX(), event.getToTransform().getLocation().getChunkPosition().getZ());
        int dimensionId = playerIn.field_71093_bK;
        if (((IMixinEntityPlayerMP)playerIn).usesCustomClient()) {
            WorldManager.sendDimensionRegistration(playerIn, toWorld.field_73011_w);
        } else if (fromWorld != toWorld && fromWorld.field_73011_w.func_186058_p() == toWorld.field_73011_w.func_186058_p()) {
            playerIn.field_71135_a.func_147359_a((Packet)new SPacketRespawn(dimensionId >= 0 ? -1 : 0, toWorld.func_175659_aa(), toWorld.func_72912_H().func_76067_t(), playerIn.field_71134_c.func_73081_b()));
        }
        playerIn.field_71135_a.func_147359_a((Packet)new SPacketRespawn(dimensionId, toWorld.func_175659_aa(), toWorld.func_72912_H().func_76067_t(), playerIn.field_71134_c.func_73081_b()));
        fromWorld.func_72973_f((net.minecraft.entity.Entity)playerIn);
        playerIn.field_70128_L = false;
        ((IMixinEntity)playerIn).setLocationAndAngles(event.getToTransform());
        playerIn.func_70029_a((net.minecraft.world.World)toWorld);
        toWorld.func_72838_d((net.minecraft.entity.Entity)playerIn);
        toWorld.func_72866_a((net.minecraft.entity.Entity)playerIn, false);
        SpongeImpl.getServer().func_184103_al().func_72375_a(playerIn, fromWorld);
        playerIn.field_71135_a.func_147364_a(playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, playerIn.field_70177_z, playerIn.field_70125_A);
        playerIn.field_71134_c.func_73080_a(toWorld);
        SpongeImpl.getServer().func_184103_al().func_72354_b(playerIn, toWorld);
        SpongeImpl.getServer().func_184103_al().func_72385_f(playerIn);
        playerIn.field_71135_a.func_147359_a((Packet)new SPacketEntityStatus((net.minecraft.entity.Entity)playerIn, toWorld.func_82736_K().func_82766_b("reducedDebugInfo") ? (byte)22 : 23));
        for (PotionEffect potioneffect : playerIn.func_70651_bq()) {
            playerIn.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(playerIn.func_145782_y(), potioneffect));
        }
        ((IMixinEntityPlayerMP)playerIn).refreshXpHealthAndFood();
        SpongeImplHooks.handlePostChangeDimensionEvent(playerIn, fromWorld, toWorld);
    }

    public static net.minecraft.entity.monster.ZombieType toNative(ZombieType type, @Nullable Profession profession) {
        if (type == ZombieTypes.NORMAL) {
            return net.minecraft.entity.monster.ZombieType.NORMAL;
        }
        if (type == ZombieTypes.HUSK) {
            return net.minecraft.entity.monster.ZombieType.HUSK;
        }
        return (net.minecraft.entity.monster.ZombieType)ZOMBIE_TYPE_MAP.getOrDefault((Object)profession, (Object)net.minecraft.entity.monster.ZombieType.NORMAL);
    }

    public static ZombieType typeFromNative(net.minecraft.entity.monster.ZombieType type) {
        if (type == net.minecraft.entity.monster.ZombieType.NORMAL) {
            return ZombieTypes.NORMAL;
        }
        if (type == net.minecraft.entity.monster.ZombieType.HUSK) {
            return ZombieTypes.HUSK;
        }
        return ZombieTypes.VILLAGER;
    }

    public static boolean isNative(ZombieType type, @Nullable Profession profession) {
        return profession == null || type == ZombieTypes.HUSK || ZOMBIE_TYPE_MAP.containsKey((Object)profession);
    }

    public static Optional<Profession> profFromNative(net.minecraft.entity.monster.ZombieType type) {
        return Optional.ofNullable(ZOMBIE_TYPE_MAP.inverse().get((Object)type));
    }

    public static boolean isEntityDead(Entity entity) {
        return EntityUtil.isEntityDead((net.minecraft.entity.Entity)entity);
    }

    public static boolean isEntityDead(net.minecraft.entity.Entity entity) {
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase base = (EntityLivingBase)entity;
            return base.func_110143_aJ() <= 0.0f || base.field_70725_aQ > 0 || base.field_70729_aU;
        }
        return entity.field_70128_L;
    }

    public static MoveEntityEvent.Teleport handleDisplaceEntityTeleportEvent(net.minecraft.entity.Entity entityIn, Location<World> location) {
        Transform<World> fromTransform = ((IMixinEntity)entityIn).getTransform();
        Transform<World> toTransform = fromTransform.setLocation(location).setRotation(new Vector3d(entityIn.field_70125_A, entityIn.field_70177_z, 0.0f));
        return EntityUtil.handleDisplaceEntityTeleportEvent(entityIn, fromTransform, toTransform, false);
    }

    public static MoveEntityEvent.Teleport handleDisplaceEntityTeleportEvent(net.minecraft.entity.Entity entityIn, double posX, double posY, double posZ, float yaw, float pitch) {
        Transform<World> fromTransform = ((IMixinEntity)entityIn).getTransform();
        Transform<World> toTransform = fromTransform.setPosition(new Vector3d(posX, posY, posZ)).setRotation(new Vector3d(pitch, yaw, 0.0f));
        return EntityUtil.handleDisplaceEntityTeleportEvent(entityIn, fromTransform, toTransform, false);
    }

    public static MoveEntityEvent.Teleport handleDisplaceEntityTeleportEvent(net.minecraft.entity.Entity entityIn, Transform<World> fromTransform, Transform<World> toTransform, boolean apiCall) {
        CauseTracker causeTracker = CauseTracker.getInstance();
        PhaseData peek = causeTracker.getCurrentPhaseData();
        IPhaseState state = peek.state;
        PhaseContext context = peek.context;
        Cause teleportCause = state.getPhase().generateTeleportCause(state, context);
        MoveEntityEvent.Teleport event = SpongeEventFactory.createMoveEntityEventTeleport(teleportCause, fromTransform, toTransform, (Entity)entityIn);
        SpongeImpl.postEvent(event);
        return event;
    }

    @Nullable
    public static MoveEntityEvent.Teleport.Portal handleDisplaceEntityPortalEvent(net.minecraft.entity.Entity entityIn, int targetDimensionId, @Nullable Teleporter teleporter) {
        boolean sameDimension;
        SpongeImplHooks.registerPortalAgentType(teleporter);
        MinecraftServer mcServer = SpongeImpl.getServer();
        IMixinPlayerList mixinPlayerList = (IMixinPlayerList)mcServer.func_184103_al();
        IMixinEntity mixinEntity = (IMixinEntity)entityIn;
        Transform<World> fromTransform = mixinEntity.getTransform();
        WorldServer fromWorld = (WorldServer)entityIn.field_70170_p;
        IMixinWorldServer fromMixinWorld = (IMixinWorldServer)fromWorld;
        boolean bl = sameDimension = entityIn.field_71093_bK == targetDimensionId;
        if (targetDimensionId == 1 && fromWorld.field_73011_w instanceof WorldProviderEnd) {
            targetDimensionId = 0;
        }
        WorldServer toWorld = mcServer.func_71218_a(targetDimensionId);
        if (!sameDimension && fromWorld == toWorld) {
            return null;
        }
        if (teleporter == null) {
            teleporter = toWorld.func_85176_s();
        }
        SpongeConfig<?> activeConfig = fromMixinWorld.getActiveConfig();
        String worldName = "";
        String teleporterClassName = teleporter.getClass().getName();
        if (teleporterClassName.equals("net.minecraft.world.Teleporter")) {
            if (toWorld.field_73011_w instanceof WorldProviderHell) {
                worldName = ((ConfigBase)activeConfig.getConfig()).getWorld().getPortalAgents().get("minecraft:default_nether");
            } else if (toWorld.field_73011_w instanceof WorldProviderEnd) {
                worldName = ((ConfigBase)activeConfig.getConfig()).getWorld().getPortalAgents().get("minecraft:default_the_end");
            }
        } else {
            worldName = ((ConfigBase)activeConfig.getConfig()).getWorld().getPortalAgents().get("minecraft:" + teleporter.getClass().getSimpleName());
        }
        if (worldName != null && !worldName.equals("")) {
            for (WorldProperties worldProperties : Sponge.getServer().getAllWorldProperties()) {
                Optional<World> spongeWorld;
                if (!worldProperties.getWorldName().equalsIgnoreCase(worldName) || !(spongeWorld = Sponge.getServer().loadWorld(worldProperties)).isPresent()) continue;
                toWorld = (WorldServer)spongeWorld.get();
                teleporter = toWorld.func_85176_s();
                ((IMixinTeleporter)teleporter).setPortalType(targetDimensionId);
            }
        }
        EntityUtil.adjustEntityPostionForTeleport(mixinPlayerList, entityIn, fromWorld, toWorld);
        PhaseContext context = PhaseContext.start();
        context.add(NamedCause.source(mixinEntity)).add(NamedCause.of("TargetWorld", toWorld)).addBlockCaptures().addEntityCaptures();
        Cause teleportCause = Cause.of(NamedCause.source(((PortalTeleportCause.Builder)((PortalTeleportCause.Builder)PortalTeleportCause.builder().agent((PortalAgent)teleporter)).type(TeleportTypes.PORTAL)).build()));
        context.complete();
        CauseTracker causeTracker = CauseTracker.getInstance();
        causeTracker.switchToPhase(EntityPhase.State.CHANGING_DIMENSION, context);
        if (entityIn.func_70089_S() && !(fromWorld.field_73011_w instanceof WorldProviderEnd)) {
            fromWorld.field_72984_F.func_76320_a("placing");
            teleporter.func_180266_a(entityIn, entityIn.field_70177_z);
            fromWorld.field_72984_F.func_76319_b();
        }
        causeTracker.completePhase(EntityPhase.State.CHANGING_DIMENSION);
        Transform<World> portalExitTransform = mixinEntity.getTransform().setExtent((World)toWorld);
        mixinEntity.setLocationAndAngles(fromTransform);
        MoveEntityEvent.Teleport.Portal event = SpongeEventFactory.createMoveEntityEventTeleportPortal(teleportCause, fromTransform, portalExitTransform, (PortalAgent)teleporter, mixinEntity, true);
        SpongeImpl.postEvent(event);
        Vector3i chunkPosition = mixinEntity.getLocation().getChunkPosition();
        IMixinTeleporter toMixinTeleporter = (IMixinTeleporter)teleporter;
        Transform<World> toTransform = event.getToTransform();
        List<BlockSnapshot> capturedBlocks = context.getCapturedBlocks();
        if (event.isCancelled()) {
            if (!portalExitTransform.getExtent().getUniqueId().equals(mixinEntity.getLocation().getExtent().getUniqueId())) {
                ((IMixinTeleporter)teleporter).removePortalPositionFromCache(ChunkPos.func_77272_a((int)chunkPosition.getX(), (int)chunkPosition.getZ()));
                if (!capturedBlocks.isEmpty()) {
                    for (BlockSnapshot original : Lists.reverse(capturedBlocks)) {
                        original.restore(true, BlockChangeFlag.NONE);
                    }
                    capturedBlocks.clear();
                }
                mixinEntity.setLocationAndAngles(fromTransform);
            } else {
                mixinEntity.setTransform(mixinEntity.getTransform());
            }
            return event;
        }
        if (!portalExitTransform.equals(toTransform)) {
            if (fromWorld == toTransform.getExtent()) {
                event.setCancelled(true);
                toMixinTeleporter.removePortalPositionFromCache(ChunkPos.func_77272_a((int)chunkPosition.getX(), (int)chunkPosition.getZ()));
                if (!capturedBlocks.isEmpty()) {
                    for (BlockSnapshot original : Lists.reverse(capturedBlocks)) {
                        original.restore(true, BlockChangeFlag.NONE);
                    }
                    capturedBlocks.clear();
                }
                mixinEntity.setLocationAndAngles(toTransform);
                return event;
            }
        } else if (toWorld.field_73011_w instanceof WorldProviderEnd) {
            BlockPos blockpos = entityIn.field_70170_p.func_175672_r(toWorld.func_175694_M());
            entityIn.func_174828_a(blockpos, entityIn.field_70177_z, entityIn.field_70125_A);
        }
        if (!capturedBlocks.isEmpty() && !TrackingUtil.processBlockCaptures(capturedBlocks, EntityPhase.State.CHANGING_DIMENSION, context)) {
            toMixinTeleporter.removePortalPositionFromCache(ChunkPos.func_77272_a((int)chunkPosition.getX(), (int)chunkPosition.getZ()));
        }
        if (!event.getKeepsVelocity()) {
            entityIn.field_70159_w = 0.0;
            entityIn.field_70181_x = 0.0;
            entityIn.field_70179_y = 0.0;
        }
        return event;
    }

    public static IMixinWorldServer getMixinWorld(Entity entity) {
        return (IMixinWorldServer)((Object)entity.getWorld());
    }

    public static IMixinWorldServer getMixinWorld(net.minecraft.entity.Entity entity) {
        return (IMixinWorldServer)entity.field_70170_p;
    }

    public static WorldServer getMinecraftWorld(Entity entity) {
        return (WorldServer)entity.getWorld();
    }

    public static World getSpongeWorld(net.minecraft.entity.Entity player) {
        return (World)player.field_70170_p;
    }

    public static RayTraceResult rayTraceFromEntity(net.minecraft.entity.Entity source, double traceDistance, float partialTicks, boolean includeEntities) {
        RayTraceResult blockRay = EntityUtil.rayTraceFromEntity(source, traceDistance, partialTicks);
        if (!includeEntities) {
            return blockRay;
        }
        Vec3d traceStart = EntityUtil.getPositionEyes(source, partialTicks);
        double blockDistance = blockRay != null ? blockRay.field_72307_f.func_72438_d(traceStart) : traceDistance;
        EntityTrace entityRay = EntityUtil.rayTraceEntities(source, traceDistance, partialTicks, blockDistance, traceStart);
        if (entityRay.entity != null && (entityRay.distance < blockDistance || blockRay == null)) {
            return entityRay.asRayTraceResult();
        }
        return blockRay;
    }

    private static EntityTrace rayTraceEntities(net.minecraft.entity.Entity source, double traceDistance, float partialTicks, double blockDistance, Vec3d traceStart) {
        EntityTrace trace = new EntityTrace(blockDistance);
        Vec3d lookDir = source.func_70676_i(partialTicks).func_186678_a(traceDistance);
        Vec3d traceEnd = traceStart.func_178787_e(lookDir);
        for (net.minecraft.entity.Entity entity : EntityUtil.getTraceEntities(source, traceDistance, lookDir, TRACEABLE)) {
            double distanceToEntity;
            AxisAlignedBB entityBB = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
            RayTraceResult entityRay = entityBB.func_72327_a(traceStart, traceEnd);
            if (entityBB.func_72318_a(traceStart)) {
                if (!(trace.distance >= 0.0)) continue;
                trace.entity = entity;
                trace.location = entityRay == null ? traceStart : entityRay.field_72307_f;
                trace.distance = 0.0;
                continue;
            }
            if (entityRay == null || !((distanceToEntity = traceStart.func_72438_d(entityRay.field_72307_f)) < trace.distance) && trace.distance != 0.0) continue;
            if (entity.func_184208_bv() == source.func_184208_bv()) {
                if (trace.distance != 0.0) continue;
                trace.entity = entity;
                trace.location = entityRay.field_72307_f;
                continue;
            }
            trace.entity = entity;
            trace.location = entityRay.field_72307_f;
            trace.distance = distanceToEntity;
        }
        return trace;
    }

    private static List<net.minecraft.entity.Entity> getTraceEntities(net.minecraft.entity.Entity source, double traceDistance, Vec3d dir, Predicate<net.minecraft.entity.Entity> filter) {
        AxisAlignedBB boundingBox = source.func_174813_aQ();
        AxisAlignedBB traceBox = boundingBox.func_72321_a(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c);
        List entities = source.field_70170_p.func_175674_a(source, traceBox.func_72314_b(1.0, 1.0, 1.0), filter);
        return entities;
    }

    public static RayTraceResult rayTraceFromEntity(net.minecraft.entity.Entity source, double traceDistance, float partialTicks) {
        Vec3d traceStart = EntityUtil.getPositionEyes(source, partialTicks);
        Vec3d lookDir = source.func_70676_i(partialTicks).func_186678_a(traceDistance);
        Vec3d traceEnd = traceStart.func_178787_e(lookDir);
        return source.field_70170_p.func_147447_a(traceStart, traceEnd, false, false, true);
    }

    public static Vec3d getPositionEyes(net.minecraft.entity.Entity entity, float partialTicks) {
        if (partialTicks == 1.0f) {
            return new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v);
        }
        double interpX = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks;
        double interpY = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks + (double)entity.func_70047_e();
        double interpZ = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks;
        return new Vec3d(interpX, interpY, interpZ);
    }

    public static boolean refreshPainting(EntityPainting painting, EntityPainting.EnumArt art) {
        EntityPainting.EnumArt oldArt = painting.field_70522_e;
        painting.field_70522_e = art;
        painting.func_174859_a(painting.field_174860_b);
        if (!painting.func_70518_d()) {
            painting.field_70522_e = oldArt;
            painting.func_174859_a(painting.field_174860_b);
            return false;
        }
        EntityTracker paintingTracker = ((WorldServer)painting.field_70170_p).func_73039_n();
        EntityTrackerEntry paintingEntry = (EntityTrackerEntry)paintingTracker.field_72794_c.func_76041_a(painting.func_145782_y());
        ArrayList<EntityPlayerMP> playerMPs = new ArrayList<EntityPlayerMP>();
        for (EntityPlayerMP player : paintingEntry.field_73134_o) {
            SPacketDestroyEntities packet = new SPacketDestroyEntities(new int[]{painting.func_145782_y()});
            player.field_71135_a.func_147359_a((Packet)packet);
            playerMPs.add(player);
        }
        for (EntityPlayerMP playerMP : playerMPs) {
            SpongeImpl.getGame().getScheduler().createTaskBuilder().delayTicks(SpongeImpl.getGlobalConfig().getConfig().getEntity().getPaintingRespawnDelaly()).execute(() -> {
                SPacketSpawnPainting packet = new SPacketSpawnPainting(painting);
                playerMP.field_71135_a.func_147359_a((Packet)packet);
            }).submit(SpongeImpl.getPlugin());
        }
        return true;
    }

    public static Profession validateProfession(int professionId) {
        List professions = (List)ProfessionRegistryModule.getInstance().getAll();
        for (Profession profession : professions) {
            if (!(profession instanceof SpongeProfession) || professionId != ((SpongeProfession)profession).type) continue;
            return profession;
        }
        return SpongeImplHooks.retrieveVillagerProfession(professionId);
    }

    public static List<EntityHanging> findHangingEntities(WorldServer worldIn, BlockPos pos) {
        return worldIn.func_175647_a(EntityHanging.class, new AxisAlignedBB(pos, pos).func_72314_b(1.1, 1.1, 1.1), entityIn -> {
            if (entityIn == null) {
                return false;
            }
            BlockPos entityPos = entityIn.func_180425_c();
            if (entityPos.equals((Object)pos.func_177982_a(0, 1, 0))) {
                return true;
            }
            EnumFacing entityFacing = entityIn.func_174811_aO();
            if (entityFacing == EnumFacing.NORTH) {
                return entityPos.equals((Object)pos.func_177971_a((Vec3i)HANGING_OFFSET_NORTH));
            }
            if (entityFacing == EnumFacing.SOUTH) {
                return entityIn.func_180425_c().equals((Object)pos.func_177971_a((Vec3i)HANGING_OFFSET_SOUTH));
            }
            if (entityFacing == EnumFacing.WEST) {
                return entityIn.func_180425_c().equals((Object)pos.func_177971_a((Vec3i)HANGING_OFFSET_WEST));
            }
            if (entityFacing == EnumFacing.EAST) {
                return entityIn.func_180425_c().equals((Object)pos.func_177971_a((Vec3i)HANGING_OFFSET_EAST));
            }
            return false;
        });
    }

    public static Location<World> getPlayerRespawnLocation(EntityPlayerMP playerIn, @Nullable WorldServer targetWorld) {
        Location<World> location = ((World)playerIn.field_70170_p).getSpawnLocation();
        tempIsBedSpawn = false;
        if (targetWorld == null) {
            return location;
        }
        Dimension targetDimension = (Dimension)targetWorld.field_73011_w;
        int targetDimensionId = ((IMixinWorldServer)targetWorld).getDimensionId();
        if (!targetDimension.allowsPlayerRespawns()) {
            targetDimensionId = ((IMixinWorldProvider)((Object)targetDimension)).getRespawnDimension(playerIn);
            targetWorld = targetWorld.func_73046_m().func_71218_a(targetDimensionId);
        }
        Vector3d targetSpawnVec = VecHelper.toVector3d(targetWorld.func_175694_M());
        BlockPos bedPos = ((IMixinEntityPlayer)playerIn).getBedLocation(targetDimensionId);
        if (bedPos != null) {
            boolean forceBedSpawn = ((IMixinEntityPlayer)playerIn).isSpawnForced(targetDimensionId);
            BlockPos bedSpawnLoc = EntityPlayer.func_180467_a((net.minecraft.world.World)targetWorld, (BlockPos)bedPos, (boolean)forceBedSpawn);
            if (bedSpawnLoc != null) {
                tempIsBedSpawn = true;
                targetSpawnVec = new Vector3d((double)bedSpawnLoc.func_177958_n() + 0.5, (double)bedSpawnLoc.func_177956_o() + 0.1, (double)bedSpawnLoc.func_177952_p() + 0.5);
            } else {
                playerIn.field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(0, 0.0f));
                bedPos = null;
            }
            int prevDim = playerIn.field_71093_bK;
            playerIn.field_71093_bK = targetDimensionId;
            playerIn.func_180473_a(bedPos, forceBedSpawn);
            playerIn.field_71093_bK = prevDim;
        }
        return new Location<World>((World)targetWorld, targetSpawnVec);
    }

    public static net.minecraft.entity.Entity toNative(Entity tickingEntity) {
        if (!(tickingEntity instanceof net.minecraft.entity.Entity)) {
            throw new IllegalArgumentException("Not a native Entity for this implementation!");
        }
        return (net.minecraft.entity.Entity)tickingEntity;
    }

    public static EntityPlayer toNative(IMixinEntityPlayer player) {
        if (!(player instanceof EntityPlayer)) {
            throw new IllegalArgumentException("Not a native EntityPlayer for this implementation!");
        }
        return (EntityPlayer)player;
    }

    @Nullable
    public static net.minecraft.entity.Entity toNullableNative(@Nullable Entity entity) {
        if (entity == null) {
            return null;
        }
        if (!(entity instanceof net.minecraft.entity.Entity)) {
            throw new IllegalArgumentException("Not a native Entity for this implementation!");
        }
        return (net.minecraft.entity.Entity)entity;
    }

    public static Entity fromNative(net.minecraft.entity.Entity entity) {
        return (Entity)entity;
    }

    public static Living fromNativeToLiving(net.minecraft.entity.Entity entity) {
        if (!(entity instanceof Living)) {
            throw new IllegalArgumentException("Entity is incompatible with SpongeAPI Living interface: " + entity);
        }
        return (Living)entity;
    }

    public static EntityLivingBase toNative(Living entity) {
        if (!(entity instanceof EntityLivingBase)) {
            throw new IllegalArgumentException("Living entity is not compatible with this implementation: " + entity);
        }
        return (EntityLivingBase)entity;
    }

    public static EntityPlayerMP toNative(Player player) {
        if (!(player instanceof EntityPlayerMP)) {
            throw new IllegalArgumentException("Player entity is not compatible with this implementation: " + player);
        }
        return (EntityPlayerMP)player;
    }

    public static EntityPlayerMP toNative(IMixinEntityPlayerMP playerMP) {
        if (!(playerMP instanceof EntityPlayerMP)) {
            throw new IllegalArgumentException("Player entity is not compatible with this implementation: " + playerMP);
        }
        return (EntityPlayerMP)playerMP;
    }

    public static IMixinEntity toMixin(net.minecraft.entity.Entity entity) {
        if (!(entity instanceof IMixinEntity)) {
            throw new IllegalArgumentException("Not a mixin Entity for this implementation!");
        }
        return (IMixinEntity)entity;
    }

    public static IMixinEntity toMixin(Entity entity) {
        if (!(entity instanceof IMixinEntity)) {
            throw new IllegalArgumentException("Not a mixin Entity for this implementation!");
        }
        return (IMixinEntity)entity;
    }

    public static Entity fromMixin(IMixinEntity mixinEntity) {
        if (!(mixinEntity instanceof Entity)) {
            throw new IllegalArgumentException("Not a native SpongeAPI entity!");
        }
        return mixinEntity;
    }

    public static EntitySnapshot createSnapshot(net.minecraft.entity.Entity entity) {
        return EntityUtil.fromNative(entity).createSnapshot();
    }

    public static boolean changeWorld(net.minecraft.entity.Entity entity, Location<World> location, int currentDim, int targetDim) {
        MinecraftServer mcServer = SpongeImpl.getServer();
        WorldServer fromWorld = mcServer.func_71218_a(currentDim);
        WorldServer toWorld = mcServer.func_71218_a(targetDim);
        if (entity instanceof EntityPlayer) {
            fromWorld.func_73039_n().func_72787_a((EntityPlayerMP)entity);
            fromWorld.func_184164_w().func_72695_c((EntityPlayerMP)entity);
            mcServer.func_184103_al().func_181057_v().remove(entity);
        } else {
            fromWorld.func_73039_n().func_72790_b(entity);
        }
        entity.field_70170_p.func_72973_f(entity);
        entity.field_70128_L = false;
        entity.field_71093_bK = targetDim;
        entity.func_70080_a(location.getX(), location.getY(), location.getZ(), 0.0f, 0.0f);
        while (!toWorld.func_184144_a(entity, entity.func_174813_aQ()).isEmpty() && entity.field_70163_u < 256.0) {
            entity.func_70107_b(entity.field_70165_t, entity.field_70163_u + 1.0, entity.field_70161_v);
        }
        toWorld.func_72863_F().func_186028_c((int)entity.field_70165_t >> 4, (int)entity.field_70161_v >> 4);
        if (entity instanceof EntityPlayerMP && ((EntityPlayerMP)entity).field_71135_a != null) {
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)entity;
            int toDimensionId = WorldManager.getClientDimensionId(entityPlayerMP, (net.minecraft.world.World)toWorld);
            if (((IMixinEntityPlayerMP)entityPlayerMP).usesCustomClient()) {
                WorldManager.sendDimensionRegistration(entityPlayerMP, toWorld.field_73011_w);
            } else if (fromWorld != toWorld && fromWorld.field_73011_w.func_186058_p() == toWorld.field_73011_w.func_186058_p()) {
                entityPlayerMP.field_71135_a.func_147359_a((Packet)new SPacketRespawn(toDimensionId >= 0 ? -1 : 0, toWorld.func_175659_aa(), toWorld.func_72912_H().func_76067_t(), entityPlayerMP.field_71134_c.func_73081_b()));
            }
            ((IMixinNetHandlerPlayServer)entityPlayerMP.field_71135_a).setLastMoveLocation(null);
            entityPlayerMP.field_71135_a.func_147359_a((Packet)new SPacketRespawn(toDimensionId, toWorld.func_175659_aa(), toWorld.func_72912_H().func_76067_t(), entityPlayerMP.field_71134_c.func_73081_b()));
            entity.func_70029_a((net.minecraft.world.World)toWorld);
            entityPlayerMP.field_71135_a.func_147364_a(entityPlayerMP.field_70165_t, entityPlayerMP.field_70163_u, entityPlayerMP.field_70161_v, entityPlayerMP.field_70177_z, entityPlayerMP.field_70125_A);
            entityPlayerMP.func_70095_a(false);
            mcServer.func_184103_al().func_72354_b(entityPlayerMP, toWorld);
            toWorld.func_184164_w().func_72683_a(entityPlayerMP);
            toWorld.func_72838_d((net.minecraft.entity.Entity)entityPlayerMP);
            mcServer.func_184103_al().func_181057_v().add(entityPlayerMP);
            entityPlayerMP.field_71134_c.func_73080_a(toWorld);
            entityPlayerMP.func_71116_b();
            ((IMixinEntityPlayerMP)entityPlayerMP).refreshXpHealthAndFood();
            for (Object effect : entityPlayerMP.func_70651_bq()) {
                entityPlayerMP.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(entityPlayerMP.func_145782_y(), (PotionEffect)effect));
            }
            entityPlayerMP.func_71016_p();
        } else {
            entity.func_70029_a((net.minecraft.world.World)toWorld);
            toWorld.func_72838_d(entity);
        }
        fromWorld.func_82742_i();
        toWorld.func_82742_i();
        return true;
    }

    public static void adjustEntityPostionForTeleport(IMixinPlayerList playerList, net.minecraft.entity.Entity entity, WorldServer fromWorld, WorldServer toWorld) {
        fromWorld.field_72984_F.func_76320_a("moving");
        WorldProvider pOld = fromWorld.field_73011_w;
        WorldProvider pNew = toWorld.field_73011_w;
        double moveFactor = playerList.getMovementFactor(pOld) / playerList.getMovementFactor(pNew);
        double x = entity.field_70165_t * moveFactor;
        double y = entity.field_70163_u;
        double z = entity.field_70161_v * moveFactor;
        if (pNew instanceof WorldProviderEnd) {
            BlockPos blockpos = pOld instanceof WorldProviderEnd ? toWorld.func_175694_M() : toWorld.func_180504_m();
            x = blockpos.func_177958_n();
            y = blockpos.func_177956_o();
            z = blockpos.func_177952_p();
            entity.func_70012_b(x, y, z, 90.0f, 0.0f);
        }
        if (!(pOld instanceof WorldProviderEnd)) {
            fromWorld.field_72984_F.func_76320_a("placing");
            x = MathHelper.func_76125_a((int)((int)x), (int)-29999872, (int)29999872);
            z = MathHelper.func_76125_a((int)((int)z), (int)-29999872, (int)29999872);
            if (entity.func_70089_S()) {
                entity.func_70012_b(x, y, z, entity.field_70177_z, entity.field_70125_A);
            }
            fromWorld.field_72984_F.func_76319_b();
        }
        if (entity.func_70089_S()) {
            fromWorld.func_72866_a(entity, false);
        }
        fromWorld.field_72984_F.func_76319_b();
    }

    public static EntityItem entityOnDropItem(net.minecraft.entity.Entity entity, ItemStack itemStack, float offsetY) {
        ItemStack item;
        IMixinEntity mixinEntity = EntityUtil.toMixin(entity);
        double posX = entity.field_70165_t;
        double posY = entity.field_70163_u + (double)offsetY;
        double posZ = entity.field_70161_v;
        if (itemStack.field_77994_a == 0 || itemStack.func_77973_b() == null) {
            return null;
        }
        ItemStackSnapshot snapshot = ItemStackUtil.createSnapshot(itemStack);
        ArrayList<ItemStackSnapshot> original = new ArrayList<ItemStackSnapshot>();
        original.add(snapshot);
        DropItemEvent.Pre dropEvent = SpongeEventFactory.createDropItemEventPre(Cause.of(NamedCause.source(entity)), (List)ImmutableList.of((Object)snapshot), original);
        SpongeImpl.postEvent(dropEvent);
        if (dropEvent.isCancelled()) {
            return null;
        }
        Transform<World> suggested = new Transform<World>(mixinEntity.getWorld(), new Vector3d(posX, entity.field_70163_u + (double)offsetY, posZ));
        Object cause = ((EntitySpawnCause.Builder)((EntitySpawnCause.Builder)EntitySpawnCause.builder().entity(mixinEntity)).type(SpawnTypes.DROPPED_ITEM)).build();
        ConstructEntityEvent.Pre event = SpongeEventFactory.createConstructEntityEventPre(Cause.of(NamedCause.source(cause)), EntityTypes.ITEM, suggested);
        SpongeImpl.postEvent(event);
        ItemStack itemStack2 = item = event.isCancelled() ? null : ItemStackUtil.fromSnapshotToNative(dropEvent.getDroppedItems().get(0));
        if (item == null) {
            return null;
        }
        PhaseData peek = CauseTracker.getInstance().getCurrentPhaseData();
        IPhaseState currentState = peek.state;
        PhaseContext phaseContext = peek.context;
        if (item.field_77994_a != 0 && item.func_77973_b() != null) {
            if (CauseTracker.ENABLED && !currentState.getPhase().ignoresItemPreMerging(currentState) && SpongeImpl.getGlobalConfig().getConfig().getOptimizations().doDropsPreMergeItemDrops()) {
                if (currentState.tracksEntitySpecificDrops()) {
                    ListMultimap<UUID, ItemDropData> multimap = phaseContext.getCapturedEntityDropSupplier().get();
                    Collection itemStacks = multimap.get((Object)entity.func_110124_au());
                    SpongeImplHooks.addItemStackToListForSpawning(itemStacks, ItemDropData.item(item).position(new Vector3d(posX, posY, posZ)).build());
                    return null;
                }
                Object itemStacks = phaseContext.getCapturedItemStackSupplier().get();
                SpongeImplHooks.addItemStackToListForSpawning((Collection<ItemDropData>)itemStacks, ItemDropData.item(item).position(new Vector3d(posX, posY, posZ)).build());
                return null;
            }
            EntityItem entityitem = new EntityItem(entity.field_70170_p, posX, posY, posZ, item);
            entityitem.func_174869_p();
            if (CauseTracker.ENABLED && currentState.getPhase().doesCaptureEntityDrops(currentState)) {
                if (currentState.tracksEntitySpecificDrops()) {
                    phaseContext.getCapturedEntityItemDropSupplier().get().put((Object)entity.func_110124_au(), (Object)entityitem);
                } else {
                    phaseContext.getCapturedItemsSupplier().get().add(entityitem);
                }
                return entityitem;
            }
            entity.field_70170_p.func_72838_d((net.minecraft.entity.Entity)entityitem);
            return entityitem;
        }
        return null;
    }

    @Nullable
    public static EntityItem playerDropItem(IMixinEntityPlayer mixinPlayer, ItemStack droppedItem, boolean dropAround, boolean traceItem) {
        ItemStack item;
        EntityPlayer player = EntityUtil.toNative(mixinPlayer);
        double posX = player.field_70165_t;
        double adjustedPosY = player.field_70163_u - (double)0.3f + (double)player.func_70047_e();
        double posZ = player.field_70161_v;
        ItemStackSnapshot snapshot = ItemStackUtil.createSnapshot(droppedItem);
        ArrayList<ItemStackSnapshot> original = new ArrayList<ItemStackSnapshot>();
        original.add(snapshot);
        DropItemEvent.Pre dropEvent = SpongeEventFactory.createDropItemEventPre(Cause.of(NamedCause.source(player)), (List)ImmutableList.of((Object)snapshot), original);
        SpongeImpl.postEvent(dropEvent);
        if (dropEvent.isCancelled()) {
            return null;
        }
        Transform<World> suggested = new Transform<World>(mixinPlayer.getWorld(), new Vector3d(posX, adjustedPosY, posZ));
        Object cause = ((EntitySpawnCause.Builder)((EntitySpawnCause.Builder)EntitySpawnCause.builder().entity(mixinPlayer)).type(SpawnTypes.DROPPED_ITEM)).build();
        ConstructEntityEvent.Pre event = SpongeEventFactory.createConstructEntityEventPre(Cause.of(NamedCause.source(cause)), EntityTypes.ITEM, suggested);
        SpongeImpl.postEvent(event);
        ItemStack itemStack = item = event.isCancelled() ? null : ItemStackUtil.fromSnapshotToNative(dropEvent.getDroppedItems().get(0));
        if (item == null) {
            return null;
        }
        PhaseData peek = CauseTracker.getInstance().getCurrentPhaseData();
        IPhaseState currentState = peek.state;
        PhaseContext phaseContext = peek.context;
        if (CauseTracker.ENABLED && !currentState.getPhase().ignoresItemPreMerging(currentState) && SpongeImpl.getGlobalConfig().getConfig().getOptimizations().doDropsPreMergeItemDrops()) {
            if (currentState.tracksEntitySpecificDrops()) {
                ListMultimap<UUID, ItemDropData> multimap = phaseContext.getCapturedEntityDropSupplier().get();
                Collection itemStacks = multimap.get((Object)player.func_110124_au());
                SpongeImplHooks.addItemStackToListForSpawning(itemStacks, ItemDropData.Player.player(player).stack(item).trace(traceItem).motion(EntityUtil.createDropMotion(dropAround, player, mixinPlayer.getRandom())).dropAround(dropAround).position(new Vector3d(posX, adjustedPosY, posZ)).build());
                return null;
            }
            Object itemStacks = phaseContext.getCapturedItemStackSupplier().get();
            SpongeImplHooks.addItemStackToListForSpawning((Collection<ItemDropData>)itemStacks, ItemDropData.Player.player(player).stack(item).trace(traceItem).motion(EntityUtil.createDropMotion(dropAround, player, mixinPlayer.getRandom())).dropAround(dropAround).position(new Vector3d(posX, adjustedPosY, posZ)).build());
            return null;
        }
        EntityItem entityitem = new EntityItem(player.field_70170_p, posX, adjustedPosY, posZ, droppedItem);
        entityitem.func_174867_a(40);
        if (traceItem) {
            entityitem.func_145799_b(player.func_70005_c_());
        }
        Random random = mixinPlayer.getRandom();
        if (dropAround) {
            float f = random.nextFloat() * 0.5f;
            float f1 = random.nextFloat() * ((float)Math.PI * 2);
            entityitem.field_70159_w = -MathHelper.func_76126_a((float)f1) * f;
            entityitem.field_70179_y = MathHelper.func_76134_b((float)f1) * f;
            entityitem.field_70181_x = 0.2f;
        } else {
            float f2 = 0.3f;
            entityitem.field_70159_w = -MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(player.field_70125_A * ((float)Math.PI / 180))) * f2;
            entityitem.field_70179_y = MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(player.field_70125_A * ((float)Math.PI / 180))) * f2;
            entityitem.field_70181_x = -MathHelper.func_76126_a((float)(player.field_70125_A * ((float)Math.PI / 180))) * f2 + 0.1f;
            float f3 = random.nextFloat() * ((float)Math.PI * 2);
            f2 = 0.02f * random.nextFloat();
            entityitem.field_70159_w += Math.cos(f3) * (double)f2;
            entityitem.field_70181_x += (double)((random.nextFloat() - random.nextFloat()) * 0.1f);
            entityitem.field_70179_y += Math.sin(f3) * (double)f2;
        }
        if (CauseTracker.ENABLED && currentState.getPhase().doesCaptureEntityDrops(currentState)) {
            if (currentState.tracksEntitySpecificDrops()) {
                phaseContext.getCapturedEntityItemDropSupplier().get().put((Object)player.func_110124_au(), (Object)entityitem);
            } else {
                phaseContext.getCapturedItemsSupplier().get().add(entityitem);
            }
            return entityitem;
        }
        ItemStack itemstack = EntityUtil.dropItemAndGetStack(player, entityitem);
        if (traceItem) {
            if (itemstack != null) {
                player.func_71064_a(StatList.func_188058_e((Item)itemstack.func_77973_b()), droppedItem.field_77994_a);
            }
            player.func_71029_a(StatList.field_75952_v);
        }
        return entityitem;
    }

    private static Vector3d createDropMotion(boolean dropAround, EntityPlayer player, Random random) {
        double y;
        double z;
        double x;
        if (dropAround) {
            float f = random.nextFloat() * 0.5f;
            float f1 = random.nextFloat() * ((float)Math.PI * 2);
            x = -MathHelper.func_76126_a((float)f1) * f;
            z = MathHelper.func_76134_b((float)f1) * f;
            y = 0.2f;
        } else {
            float f2 = 0.3f;
            x = -MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(player.field_70125_A * ((float)Math.PI / 180))) * f2;
            z = MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(player.field_70125_A * ((float)Math.PI / 180))) * f2;
            y = -MathHelper.func_76126_a((float)(player.field_70125_A * ((float)Math.PI / 180))) * f2 + 0.1f;
            float f3 = random.nextFloat() * ((float)Math.PI * 2);
            f2 = 0.02f * random.nextFloat();
            x += Math.cos(f3) * (double)f2;
            y += (double)((random.nextFloat() - random.nextFloat()) * 0.1f);
            z += Math.sin(f3) * (double)f2;
        }
        return new Vector3d(x, y, z);
    }

    private static ItemStack dropItemAndGetStack(EntityPlayer player, EntityItem item) {
        ItemStack stack = item.func_92059_d();
        if (stack != null) {
            player.field_70170_p.func_72838_d((net.minecraft.entity.Entity)item);
            return stack;
        }
        return null;
    }

    static final class EntityTrace {
        net.minecraft.entity.Entity entity;
        Vec3d location;
        double distance;

        EntityTrace(double entityDistance) {
            this.distance = entityDistance;
        }

        RayTraceResult asRayTraceResult() {
            return new RayTraceResult(this.entity, this.location);
        }
    }
}

