/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.MemoryDataContainer;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.nbt.NbtDataTypes;
import org.spongepowered.common.data.nbt.validation.Validations;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.data.util.DataQueries;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.SpongeEntityArchetype;

public class SpongeEntityArchetypeBuilder
extends AbstractDataBuilder<EntityArchetype>
implements EntityArchetype.Builder {
    EntityType entityType = EntityTypes.UNKNOWN;
    DataContainer entityData;

    public SpongeEntityArchetypeBuilder() {
        super(EntityArchetype.class, 1);
    }

    @Override
    public EntityArchetype.Builder reset() {
        this.entityType = EntityTypes.UNKNOWN;
        this.entityData = null;
        return this;
    }

    @Override
    public EntityArchetype.Builder from(EntityArchetype value) {
        this.entityType = value.getType();
        this.entityData = value.getEntityData();
        return this;
    }

    @Override
    protected Optional<EntityArchetype> buildContent(DataView container) throws InvalidDataException {
        SpongeEntityArchetypeBuilder builder = new SpongeEntityArchetypeBuilder();
        if (!container.contains(DataQueries.EntityArchetype.ENTITY_TYPE)) {
            throw new InvalidDataException("Missing the TileEntityType and BlockState! Cannot re-construct a TileEntityArchetype!");
        }
        builder.type(container.getCatalogType(DataQueries.EntityArchetype.ENTITY_TYPE, EntityType.class).orElseThrow(() -> new InvalidDataException("Could not deserialize a TileEntityType!")));
        if (container.contains(DataQueries.EntityArchetype.ENTITY_DATA)) {
            builder.entityData(container.getView(DataQueries.EntityArchetype.ENTITY_DATA).orElseThrow(() -> new InvalidDataException("No DataView found for the TileEntity data tag!")));
        }
        return Optional.of(builder.build());
    }

    @Override
    public EntityArchetype.Builder type(EntityType type) {
        Preconditions.checkNotNull((Object)type, (Object)"EntityType cannot be null!");
        Preconditions.checkArgument((type != EntityTypes.UNKNOWN ? 1 : 0) != 0, (Object)"EntityType cannot be set to UNKNOWN!");
        if (this.entityType != type) {
            this.entityData = null;
        }
        this.entityType = type;
        return this;
    }

    @Override
    public EntityArchetype.Builder from(org.spongepowered.api.entity.Entity entity) {
        Preconditions.checkNotNull((Object)entity, (Object)"Cannot build an EntityArchetype for a null entity!");
        this.entityType = (EntityType)Preconditions.checkNotNull((Object)entity.getType(), (Object)"Entity is returning a null EntityType!");
        Entity minecraftEntity = EntityUtil.toNative(entity);
        NBTTagCompound compound = new NBTTagCompound();
        minecraftEntity.func_189511_e(compound);
        compound.func_82580_o("UUID");
        this.entityData = NbtTranslator.getInstance().translate(compound);
        return this;
    }

    @Override
    public EntityArchetype.Builder entityData(DataView view) {
        Preconditions.checkNotNull((Object)view, (Object)"Provided DataView cannot be null!");
        DataContainer copy = view.copy();
        SpongeDataManager.getInstance().getValidators(Validations.ENTITY).validate(copy);
        this.entityData = copy;
        return this;
    }

    @Override
    public EntityArchetype.Builder setData(DataManipulator<?, ?> manipulator) {
        if (this.entityData == null) {
            this.entityData = new MemoryDataContainer();
        }
        SpongeDataManager.getInstance().getRawNbtProcessor(NbtDataTypes.ENTITY, manipulator.getClass()).ifPresent(processor -> processor.storeToView(this.entityData, manipulator));
        return this;
    }

    @Override
    public <E, V extends BaseValue<E>> EntityArchetype.Builder set(V value) {
        if (this.entityData == null) {
            this.entityData = new MemoryDataContainer();
        }
        SpongeDataManager.getInstance().getRawNbtProcessor(NbtDataTypes.TILE_ENTITY, value.getKey()).ifPresent(processor -> processor.offer(this.entityData, value));
        return this;
    }

    @Override
    public <E, V extends BaseValue<E>> EntityArchetype.Builder set(Key<V> key, E value) {
        if (this.entityData == null) {
            this.entityData = new MemoryDataContainer();
        }
        SpongeDataManager.getInstance().getRawNbtProcessor(NbtDataTypes.TILE_ENTITY, key).ifPresent(processor -> processor.offer(this.entityData, value));
        return this;
    }

    @Override
    public EntityArchetype build() {
        Preconditions.checkNotNull((Object)this.entityType);
        Preconditions.checkState((this.entityType != EntityTypes.UNKNOWN ? 1 : 0) != 0);
        if (this.entityData == null) {
            this.entityData = new MemoryDataContainer();
        } else {
            this.entityData.remove(DataQuery.of("Pos"));
            this.entityData.remove(DataQuery.of("UUID"));
        }
        return new SpongeEntityArchetype(this);
    }
}

