/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.MemoryDataContainer;
import org.spongepowered.api.data.Property;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.event.cause.entity.spawn.SpawnCause;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.DataProcessor;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.data.util.DataQueries;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.data.util.NbtDataUtil;
import org.spongepowered.common.entity.SpongeEntityArchetypeBuilder;
import org.spongepowered.common.entity.SpongeEntitySnapshotBuilder;
import org.spongepowered.common.interfaces.world.IMixinWorldInfo;

public class SpongeEntitySnapshot
implements EntitySnapshot {
    @Nullable
    private final UUID entityUuid;
    private final UUID worldUuid;
    private final EntityType entityType;
    private final Vector3d position;
    private final Vector3d rotation;
    private final Vector3d scale;
    private final ImmutableList<ImmutableDataManipulator<?, ?>> manipulators;
    private final ImmutableSet<Key<?>> keys;
    private final ImmutableSet<ImmutableValue<?>> values;
    @Nullable
    private final NBTTagCompound compound;
    @Nullable
    private final WeakReference<Entity> entityReference;
    private boolean isDirty = true;

    SpongeEntitySnapshot(SpongeEntitySnapshotBuilder builder) {
        this.entityType = builder.entityType;
        this.entityUuid = builder.entityId == null ? null : builder.entityId;
        this.manipulators = builder.manipulators == null ? ImmutableList.of() : ImmutableList.copyOf(builder.manipulators);
        if (this.manipulators.isEmpty()) {
            this.keys = ImmutableSet.of();
            this.values = ImmutableSet.of();
        } else {
            ImmutableSet.Builder keyBuilder = ImmutableSet.builder();
            ImmutableSet.Builder valueBuilder = ImmutableSet.builder();
            for (ImmutableDataManipulator manipulator : this.manipulators) {
                for (ImmutableValue<?> value : manipulator.getValues()) {
                    keyBuilder.add(value.getKey());
                    valueBuilder.add(value);
                }
            }
            this.keys = keyBuilder.build();
            this.values = valueBuilder.build();
        }
        this.compound = builder.compound == null ? null : builder.compound.func_74737_b();
        this.worldUuid = builder.worldId == null ? null : builder.worldId;
        this.position = builder.position == null ? null : builder.position;
        this.rotation = builder.rotation == null ? Vector3d.ZERO : builder.rotation;
        this.scale = builder.scale == null ? null : builder.scale;
        this.entityReference = builder.entityReference;
        if (this.compound != null) {
            this.compound.func_74782_a("Pos", (NBTBase)NbtDataUtil.newDoubleNBTList(this.position.getX(), this.position.getY(), this.position.getZ()));
        }
    }

    public WeakReference<Entity> getEntityReference() {
        return this.entityReference;
    }

    @Override
    public Optional<UUID> getUniqueId() {
        return Optional.ofNullable(this.entityUuid);
    }

    @Override
    public Optional<Transform<World>> getTransform() {
        if (this.worldUuid == null) {
            return Optional.empty();
        }
        Optional<World> optional = SpongeImpl.getGame().getServer().getWorld(this.worldUuid);
        if (optional.isPresent()) {
            Transform<Extent> transform = new Transform<Extent>(optional.get(), this.position, this.rotation);
            return Optional.of(transform);
        }
        return Optional.empty();
    }

    @Override
    public EntityType getType() {
        return this.entityType;
    }

    @Override
    public Optional<Location<World>> getLocation() {
        if (this.worldUuid == null) {
            return Optional.empty();
        }
        Optional<World> optional = SpongeImpl.getGame().getServer().getWorld(this.worldUuid);
        if (optional.isPresent()) {
            Location<Extent> location = new Location<Extent>((Extent)optional.get(), this.position);
            return Optional.of(location);
        }
        return Optional.empty();
    }

    @Override
    public List<ImmutableDataManipulator<?, ?>> getManipulators() {
        return this.manipulators;
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        List<DataView> dataList = DataUtil.getSerializedImmutableManipulatorList(this.manipulators);
        DataContainer container = new MemoryDataContainer().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion()).set(Queries.WORLD_ID, (Object)this.worldUuid.toString()).set(DataQueries.ENTITY_TYPE, (Object)this.entityType.getId()).createView(DataQueries.SNAPSHOT_WORLD_POSITION).set(Queries.POSITION_X, (Object)this.position.getX()).set(Queries.POSITION_Y, (Object)this.position.getY()).set(Queries.POSITION_Z, (Object)this.position.getZ()).getContainer().createView(DataQueries.ENTITY_ROTATION).set(Queries.POSITION_X, (Object)this.rotation.getX()).set(Queries.POSITION_Y, (Object)this.rotation.getY()).set(Queries.POSITION_Z, (Object)this.rotation.getZ()).getContainer().createView(DataQueries.ENTITY_SCALE).set(Queries.POSITION_X, (Object)this.scale.getX()).set(Queries.POSITION_Y, (Object)this.scale.getY()).set(Queries.POSITION_Z, (Object)this.scale.getZ()).getContainer().set(DataQueries.DATA_MANIPULATORS, dataList);
        if (this.entityUuid != null) {
            container.set(DataQueries.ENTITY_ID, (Object)this.entityUuid.toString());
        }
        if (this.compound != null) {
            container.set(DataQueries.UNSAFE_NBT, (Object)NbtTranslator.getInstance().translateFrom(this.compound));
        }
        return container;
    }

    @Override
    public <T extends ImmutableDataManipulator<?, ?>> Optional<T> get(Class<T> containerClass) {
        for (ImmutableDataManipulator manipulator : this.manipulators) {
            if (!containerClass.isInstance(manipulator)) continue;
            return Optional.of(manipulator);
        }
        return Optional.empty();
    }

    @Override
    public <T extends ImmutableDataManipulator<?, ?>> Optional<T> getOrCreate(Class<T> containerClass) {
        Optional<T> optional = this.get(containerClass);
        if (optional.isPresent()) {
            return optional;
        }
        Optional<DataProcessor> processorOptional = SpongeDataManager.getInstance().getWildImmutableProcessor(containerClass);
        if (processorOptional.isPresent() && processorOptional.get().supports(this.entityType)) {
            return Optional.of(SpongeDataManager.getInstance().getWildBuilderForImmutable(containerClass).get().create().asImmutable());
        }
        return Optional.empty();
    }

    @Override
    public boolean supports(Class<? extends ImmutableDataManipulator<?, ?>> containerClass) {
        for (ImmutableDataManipulator manipulator : this.manipulators) {
            if (!containerClass.isInstance(manipulator)) continue;
            return true;
        }
        Optional<DataProcessor> processorOptional = SpongeDataManager.getInstance().getWildImmutableProcessor(containerClass);
        return processorOptional.isPresent() && processorOptional.get().supports(this.entityType);
    }

    @Override
    public <E> Optional<EntitySnapshot> transform(Key<? extends BaseValue<E>> key, Function<E, E> function) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(function);
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean createNew = false;
        for (ImmutableDataManipulator manipulator : this.manipulators) {
            if (manipulator.supports(key)) {
                createNew = true;
                builder.add(manipulator.with(key, Preconditions.checkNotNull(function.apply(manipulator.get(key).orElse(null)))).get());
                continue;
            }
            builder.add((Object)manipulator);
        }
        if (createNew) {
            SpongeEntitySnapshotBuilder snapshotBuilder = this.createBuilder();
            snapshotBuilder.manipulators = builder.build();
            return Optional.of(snapshotBuilder.build());
        }
        return Optional.empty();
    }

    @Override
    public <E> Optional<EntitySnapshot> with(Key<? extends BaseValue<E>> key, E value) {
        return this.transform(key, input -> value);
    }

    @Override
    public Optional<EntitySnapshot> with(BaseValue<?> value) {
        return this.with(value.getKey(), value.get());
    }

    @Override
    public Optional<EntitySnapshot> with(ImmutableDataManipulator<?, ?> valueContainer) {
        return Optional.of(((SpongeEntitySnapshotBuilder)this.createBuilder().add((ImmutableDataManipulator)valueContainer)).build());
    }

    @Override
    public Optional<EntitySnapshot> with(Iterable<ImmutableDataManipulator<?, ?>> valueContainers) {
        SpongeEntitySnapshotBuilder builder = this.createBuilder();
        for (ImmutableDataManipulator<?, ?> manipulator : valueContainers) {
            builder.add(manipulator);
        }
        return Optional.of(builder.build());
    }

    @Override
    public Optional<EntitySnapshot> without(Class<? extends ImmutableDataManipulator<?, ?>> containerClass) {
        if (!this.supports((Class<? extends ImmutableDataManipulator<?, ?>>)containerClass)) {
            return Optional.empty();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ImmutableDataManipulator manipulator : this.manipulators) {
            if (containerClass.isAssignableFrom(manipulator.getClass())) continue;
            builder.add((Object)manipulator);
        }
        SpongeEntitySnapshotBuilder snapshotBuilder = this.createBuilder();
        snapshotBuilder.manipulators = builder.build();
        return Optional.of(snapshotBuilder.build());
    }

    @Override
    public EntitySnapshot merge(EntitySnapshot that) {
        return this;
    }

    @Override
    public EntitySnapshot merge(EntitySnapshot that, MergeFunction function) {
        return this;
    }

    @Override
    public List<ImmutableDataManipulator<?, ?>> getContainers() {
        return this.getManipulators();
    }

    @Override
    public <E> Optional<E> get(Key<? extends BaseValue<E>> key) {
        Preconditions.checkNotNull(key);
        for (ImmutableValue value : this.values) {
            if (!value.getKey().equals(key)) continue;
            return Optional.of(value.get());
        }
        return Optional.empty();
    }

    @Override
    public <E, V extends BaseValue<E>> Optional<V> getValue(Key<V> key) {
        Preconditions.checkNotNull(key);
        for (ImmutableValue value : this.values) {
            if (!value.getKey().equals(key)) continue;
            return Optional.of(value.asMutable());
        }
        return Optional.empty();
    }

    @Override
    public boolean supports(Key<?> key) {
        return this.keys.contains(key);
    }

    @Override
    public EntitySnapshot copy() {
        return this;
    }

    @Override
    public Set<Key<?>> getKeys() {
        return this.keys;
    }

    @Override
    public Set<ImmutableValue<?>> getValues() {
        return this.values;
    }

    @Override
    public UUID getWorldUniqueId() {
        return this.worldUuid;
    }

    @Override
    public Vector3i getPosition() {
        return this.position.toInt();
    }

    @Override
    public EntitySnapshot withLocation(Location<World> location) {
        Preconditions.checkNotNull(location, (Object)"location");
        SpongeEntitySnapshotBuilder builder = this.createBuilder();
        builder.position = location.getPosition();
        builder.worldId = location.getExtent().getUniqueId();
        NBTTagCompound newCompound = this.compound.func_74737_b();
        newCompound.func_74768_a("Dimension", ((IMixinWorldInfo)((Object)location.getExtent().getProperties())).getDimensionId().intValue());
        builder.compound = newCompound;
        return builder.build();
    }

    private SpongeEntitySnapshotBuilder createBuilder() {
        return new SpongeEntitySnapshotBuilder().type(this.getType()).rotation(this.rotation).scale(this.scale);
    }

    public Optional<NBTTagCompound> getCompound() {
        if (this.compound == null) {
            return Optional.empty();
        }
        return Optional.of(this.compound.func_74737_b());
    }

    @Override
    public Optional<Entity> restore() {
        Optional<Entity> entity;
        Entity entity2;
        if (this.entityReference != null && (entity2 = (Entity)this.entityReference.get()) != null) {
            return Optional.of(entity2);
        }
        Optional<World> world = SpongeImpl.getGame().getServer().getWorld(this.worldUuid);
        if (!world.isPresent()) {
            return Optional.empty();
        }
        if (this.entityUuid != null && (entity = world.get().getEntity(this.entityUuid)).isPresent()) {
            return entity;
        }
        Entity newEntity = world.get().createEntity(this.getType(), this.position);
        if (newEntity != null) {
            boolean spawnResult;
            net.minecraft.entity.Entity nmsEntity = (net.minecraft.entity.Entity)newEntity;
            if (this.compound != null) {
                nmsEntity.func_70020_e(this.compound);
            }
            if (spawnResult = world.get().spawnEntity((Entity)nmsEntity, Cause.of(NamedCause.source(((SpawnCause.Builder)SpawnCause.builder().type(SpawnTypes.PLUGIN)).build()), NamedCause.owner(world)))) {
                return Optional.of((Entity)nmsEntity);
            }
        }
        return Optional.empty();
    }

    @Override
    public <T extends Property<?, ?>> Optional<T> getProperty(Class<T> propertyClass) {
        return Optional.empty();
    }

    @Override
    public Collection<Property<?, ?>> getApplicableProperties() {
        return ImmutableList.of();
    }

    @Override
    public EntityArchetype createArchetype() {
        SpongeEntityArchetypeBuilder builder = new SpongeEntityArchetypeBuilder();
        builder.type(this.entityType);
        if (this.compound != null) {
            builder.entityData(NbtTranslator.getInstance().translate(this.compound));
        }
        return builder.build();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("uniqueId", (Object)this.entityUuid).add("entityType", (Object)this.entityType).add("position", (Object)this.position).add("rotation", (Object)this.rotation).add("scale", (Object)this.scale).toString();
    }
}

