/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.ai;

import com.google.common.base.Preconditions;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import org.spongepowered.api.entity.ai.task.builtin.creature.RangeAgentAITask;
import org.spongepowered.api.entity.living.Ranger;

public final class SpongeRangeAgentAIBuilder
implements RangeAgentAITask.Builder {
    private double maxSpeed;
    private int delayBetweenAttacks;
    private float attackRadius;

    public SpongeRangeAgentAIBuilder() {
        this.reset();
    }

    @Override
    public RangeAgentAITask.Builder moveSpeed(double speed) {
        this.maxSpeed = speed;
        return this;
    }

    @Override
    public RangeAgentAITask.Builder delayBetweenAttacks(int delay) {
        this.delayBetweenAttacks = delay;
        return this;
    }

    @Override
    public RangeAgentAITask.Builder attackRadius(float radius) {
        this.attackRadius = radius;
        return this;
    }

    @Override
    public RangeAgentAITask.Builder from(RangeAgentAITask value) {
        Preconditions.checkNotNull((Object)value);
        this.maxSpeed = value.getMoveSpeed();
        this.delayBetweenAttacks = value.getDelayBetweenAttacks();
        this.attackRadius = value.getAttackRadius();
        return this;
    }

    @Override
    public RangeAgentAITask.Builder reset() {
        this.maxSpeed = 1.25;
        this.delayBetweenAttacks = 20;
        this.attackRadius = 10.0f;
        return this;
    }

    @Override
    public RangeAgentAITask build(Ranger owner) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkArgument((boolean)(owner instanceof IRangedAttackMob), (Object)"Ranger must be an IRangedAttackMob!");
        return (RangeAgentAITask)new EntityAIAttackRanged((IRangedAttackMob)owner, this.maxSpeed, this.delayBetweenAttacks, this.attackRadius);
    }
}

