/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.player;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.storage.SaveHandler;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.MemoryDataContainer;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.entity.ArmorEquipable;
import org.spongepowered.api.entity.Tamer;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.util.RespawnLocation;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.nbt.CustomDataNbtUtil;
import org.spongepowered.common.data.util.DataQueries;
import org.spongepowered.common.entity.player.ISpongeUser;
import org.spongepowered.common.world.WorldManager;

public class SpongeUser
implements ArmorEquipable,
Tamer,
DataSerializable,
Carrier,
ISpongeUser {
    public static final Set<SpongeUser> dirtyUsers = Sets.newHashSet();
    private final User self = (User)((Object)this);
    private final GameProfile profile;
    private final Map<UUID, RespawnLocation> spawnLocations = Maps.newHashMap();

    public SpongeUser(GameProfile profile) {
        this.profile = profile;
    }

    private void reset() {
        this.spawnLocations.clear();
    }

    public void readFromNbt(NBTTagCompound compound) {
        this.reset();
        NBTTagCompound spongeCompound = compound.func_74775_l("ForgeData").func_74775_l("SpongeData");
        CustomDataNbtUtil.readCustomData(spongeCompound, (DataHolder)((Object)this));
        if (!spongeCompound.func_82582_d()) {
            NBTTagList spawnList = spongeCompound.func_150295_c("Spawns", 10);
            for (int i = 0; i < spawnList.func_74745_c(); ++i) {
                NBTTagCompound spawnCompound = spawnList.func_150305_b(i);
                UUID uuid = spawnCompound.func_186857_a("UUID");
                if (uuid.getLeastSignificantBits() == 0L || uuid.getMostSignificantBits() == 0L) continue;
                double xPos = spawnCompound.func_74769_h("SpawnX");
                double yPos = spawnCompound.func_74769_h("SpawnY");
                double zPos = spawnCompound.func_74769_h("SpawnZ");
                boolean forced = spawnCompound.func_74767_n("SpawnForced");
                this.spawnLocations.put(uuid, new RespawnLocation.Builder().forceSpawn(forced).position(new Vector3d(xPos, yPos, zPos)).world(uuid).build());
            }
        }
    }

    public void writeToNbt(NBTTagCompound compound) {
        NBTTagCompound forgeCompound = compound.func_74775_l("ForgeData");
        NBTTagCompound spongeCompound = forgeCompound.func_74775_l("SpongeData");
        spongeCompound.func_82580_o("Spawns");
        NBTTagList spawnList = new NBTTagList();
        for (Map.Entry<UUID, RespawnLocation> entry : this.spawnLocations.entrySet()) {
            RespawnLocation respawn = entry.getValue();
            NBTTagCompound spawnCompound = new NBTTagCompound();
            spawnCompound.func_186854_a("UUID", entry.getKey());
            spawnCompound.func_74780_a("SpawnX", respawn.getPosition().getX());
            spawnCompound.func_74780_a("SpawnY", respawn.getPosition().getY());
            spawnCompound.func_74780_a("SpawnZ", respawn.getPosition().getZ());
            spawnCompound.func_74757_a("SpawnForced", false);
            spawnList.func_74742_a((NBTBase)spawnCompound);
        }
        if (!spawnList.func_82582_d()) {
            spongeCompound.func_74782_a("Spawns", (NBTBase)spawnList);
            forgeCompound.func_74782_a("SpongeData", (NBTBase)spongeCompound);
            compound.func_74782_a("ForgeData", (NBTBase)forgeCompound);
        }
        CustomDataNbtUtil.writeCustomData(spongeCompound, (DataHolder)((Object)this));
    }

    @Override
    public UUID getUniqueId() {
        return this.profile.getId();
    }

    @Override
    public String getName() {
        return this.profile.getName();
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return new MemoryDataContainer().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion()).set(DataQueries.USER_UUID, (Object)this.profile.getId()).set(DataQueries.USER_NAME, (Object)this.profile.getName()).set(DataQueries.USER_SPAWNS, this.spawnLocations);
    }

    private Player getUserIfOnlineForInventory() {
        return this.self.getPlayer().orElseThrow(() -> new UnsupportedOperationException("User is offline, offline inventory API yet to be implemented"));
    }

    @Override
    public boolean canEquip(EquipmentType type) {
        return this.getUserIfOnlineForInventory().canEquip(type);
    }

    @Override
    public boolean canEquip(EquipmentType type, ItemStack equipment) {
        return this.getUserIfOnlineForInventory().canEquip(type, equipment);
    }

    @Override
    public Optional<ItemStack> getEquipped(EquipmentType type) {
        return this.getUserIfOnlineForInventory().getEquipped(type);
    }

    @Override
    public boolean equip(EquipmentType type, ItemStack equipment) {
        return this.getUserIfOnlineForInventory().equip(type, equipment);
    }

    @Override
    public CarriedInventory<? extends Carrier> getInventory() {
        return this.getUserIfOnlineForInventory().getInventory();
    }

    @Override
    public Optional<ItemStack> getHelmet() {
        return this.getUserIfOnlineForInventory().getHelmet();
    }

    @Override
    public void setHelmet(ItemStack helmet) {
        this.getUserIfOnlineForInventory().setHelmet(helmet);
    }

    @Override
    public Optional<ItemStack> getChestplate() {
        return this.getUserIfOnlineForInventory().getChestplate();
    }

    @Override
    public void setChestplate(ItemStack chestplate) {
        this.getUserIfOnlineForInventory().setChestplate(chestplate);
    }

    @Override
    public Optional<ItemStack> getLeggings() {
        return this.getUserIfOnlineForInventory().getLeggings();
    }

    @Override
    public void setLeggings(ItemStack leggings) {
        this.getUserIfOnlineForInventory().setLeggings(leggings);
    }

    @Override
    public Optional<ItemStack> getBoots() {
        return this.getUserIfOnlineForInventory().getBoots();
    }

    @Override
    public void setBoots(ItemStack boots) {
        this.getUserIfOnlineForInventory().setBoots(boots);
    }

    @Override
    public Optional<ItemStack> getItemInHand(HandType handType) {
        return this.getUserIfOnlineForInventory().getItemInHand(handType);
    }

    @Override
    public void setItemInHand(HandType handType, @Nullable ItemStack itemInHand) {
        this.getUserIfOnlineForInventory().setItemInHand(handType, itemInHand);
    }

    @Override
    public Map<UUID, RespawnLocation> getBedlocations() {
        Optional<Player> player = this.self.getPlayer();
        if (player.isPresent()) {
            return ((ISpongeUser)((Object)player.get())).getBedlocations();
        }
        return this.spawnLocations;
    }

    @Override
    public boolean setBedLocations(Map<UUID, RespawnLocation> value) {
        Optional<Player> player = this.self.getPlayer();
        if (player.isPresent()) {
            return ((ISpongeUser)((Object)player.get())).setBedLocations(value);
        }
        this.spawnLocations.clear();
        this.spawnLocations.putAll(value);
        this.markDirty();
        return true;
    }

    @Override
    public ImmutableMap<UUID, RespawnLocation> removeAllBeds() {
        Optional<Player> player = this.self.getPlayer();
        if (player.isPresent()) {
            return ((ISpongeUser)((Object)player.get())).removeAllBeds();
        }
        ImmutableMap locations = ImmutableMap.copyOf(this.spawnLocations);
        this.spawnLocations.clear();
        this.markDirty();
        return locations;
    }

    private void markDirty() {
        dirtyUsers.add(this);
    }

    public void save() {
        NBTTagCompound tag;
        SaveHandler saveHandler = (SaveHandler)WorldManager.getWorldByDimensionId(0).get().func_72860_G();
        File dataFile = new File(saveHandler.field_75771_c, this.getUniqueId() + ".dat");
        if (dataFile.isFile()) {
            try {
                tag = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(dataFile));
            }
            catch (IOException ignored) {
                tag = new NBTTagCompound();
            }
        } else {
            tag = new NBTTagCompound();
        }
        this.writeToNbt(tag);
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)new FileOutputStream(dataFile));
            dirtyUsers.remove(this);
        }
        catch (IOException e) {
            SpongeImpl.getLogger().warn("Failed to save user file [{}]!", new Object[]{dataFile, e});
        }
    }
}

