/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.damage;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.api.effect.potion.PotionEffect;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.event.cause.entity.damage.DamageModifier;
import org.spongepowered.api.event.cause.entity.damage.DamageModifierTypes;
import org.spongepowered.api.event.cause.entity.damage.source.BlockDamageSource;
import org.spongepowered.api.event.cause.entity.damage.source.FallingBlockDamageSource;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.item.inventory.equipment.EquipmentTypes;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.damage.DamageObject;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.entity.IMixinEntity;
import org.spongepowered.common.interfaces.world.IMixinLocation;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.interfaces.world.gen.IMixinChunkProviderServer;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

public class DamageEventHandler {
    public static final Function<Double, Double> HARD_HAT_FUNCTION = damage -> -(damage - damage * 0.75);
    public static final Function<Double, Double> BLOCKING_FUNCTION = damage -> -(damage - (1.0 + damage) * 0.5);
    private static double damageToHandle;
    private static double enchantmentDamageTracked;

    public static Function<Double, Double> createResistanceFunction(int resistanceAmplifier) {
        int base = (resistanceAmplifier + 1) * 5;
        int modifier = 25 - base;
        return damage -> -(damage - (double)(damage.floatValue() * (float)modifier / 25.0f));
    }

    public static Optional<Tuple<DamageModifier, Function<? super Double, Double>>> createHardHatModifier(EntityLivingBase entityLivingBase, DamageSource damageSource) {
        if (damageSource instanceof FallingBlockDamageSource && entityLivingBase.func_184582_a(EntityEquipmentSlot.HEAD) != null) {
            DamageModifier modifier = DamageModifier.builder().cause(Cause.of(NamedCause.of("HardHat", ((ItemStack)entityLivingBase.func_184582_a(EntityEquipmentSlot.HEAD)).createSnapshot()))).type(DamageModifierTypes.HARD_HAT).build();
            return Optional.of(new Tuple<DamageModifier, Function<Double, Double>>(modifier, HARD_HAT_FUNCTION));
        }
        return Optional.empty();
    }

    public static Optional<List<Tuple<DamageModifier, Function<? super Double, Double>>>> createArmorModifiers(EntityLivingBase entityLivingBase, DamageSource damageSource, double damage) {
        if (!damageSource.func_151517_h()) {
            DamageObject object;
            damage *= 25.0;
            net.minecraft.item.ItemStack[] inventory = (net.minecraft.item.ItemStack[])Iterables.toArray((Iterable)entityLivingBase.func_184193_aE(), net.minecraft.item.ItemStack.class);
            ArrayList<Tuple<DamageModifier, Function<Double, Double>>> modifiers = new ArrayList<Tuple<DamageModifier, Function<Double, Double>>>();
            ArrayList<DamageObject> damageObjects = new ArrayList<DamageObject>();
            for (int index = 0; index < inventory.length; ++index) {
                Item item;
                net.minecraft.item.ItemStack itemStack = inventory[index];
                if (itemStack == null || !((item = itemStack.func_77973_b()) instanceof ItemArmor)) continue;
                ItemArmor armor = (ItemArmor)item;
                double reduction = (double)armor.field_77879_b / 25.0;
                object = new DamageObject();
                object.slot = index;
                object.ratio = reduction;
                damageObjects.add(object);
            }
            boolean first = true;
            double ratio = 0.0;
            for (DamageObject prop : damageObjects) {
                EquipmentType type = DamageEventHandler.resolveEquipment(prop.slot);
                object = new DamageObject();
                object.ratio = ratio;
                if (first) {
                    object.previousDamage = damage;
                    object.augment = true;
                }
                Function<Double, Double> function = incomingDamage -> {
                    double functionDamage;
                    incomingDamage = incomingDamage * 25.0;
                    if (object.augment) {
                        damageToHandle = incomingDamage;
                    }
                    object.previousDamage = functionDamage = damageToHandle;
                    object.ratio = prop.ratio;
                    object.ratio += prop.ratio;
                    return -(functionDamage * prop.ratio / 25.0);
                };
                ratio += prop.ratio;
                DamageModifier modifier = DamageModifier.builder().cause(Cause.of(NamedCause.of("GeneralArmor:" + type.getId(), ((ItemStack)inventory[prop.slot]).createSnapshot()), NamedCause.of("ArmorProperty", prop), NamedCause.of("0xDEADBEEF", object))).type(DamageModifierTypes.ARMOR).build();
                modifiers.add(new Tuple<DamageModifier, Function<Double, Double>>(modifier, function));
                first = false;
            }
            if (modifiers.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(modifiers);
        }
        return Optional.empty();
    }

    public static void acceptArmorModifier(EntityLivingBase entity, DamageSource damageSource, DamageModifier modifier, double damage) {
        net.minecraft.item.ItemStack[] inventory;
        Optional<DamageObject> property = modifier.getCause().first(DamageObject.class);
        net.minecraft.item.ItemStack[] itemStackArray = inventory = entity instanceof EntityPlayer ? ((EntityPlayer)entity).field_71071_by.field_70460_b : entity.field_184631_bt;
        if (property.isPresent()) {
            damage = Math.abs(damage) * 25.0;
            net.minecraft.item.ItemStack stack = inventory[property.get().slot];
            int itemDamage = (int)(damage / 25.0 < 1.0 ? 1.0 : damage / 25.0);
            stack.func_77972_a(itemDamage, entity);
            if (stack.field_77994_a <= 0) {
                inventory[property.get().slot] = null;
            }
        }
    }

    public static EquipmentType resolveEquipment(int slot) {
        if (slot == 0) {
            return EquipmentTypes.BOOTS;
        }
        if (slot == 1) {
            return EquipmentTypes.LEGGINGS;
        }
        if (slot == 2) {
            return EquipmentTypes.CHESTPLATE;
        }
        if (slot == 3) {
            return EquipmentTypes.HEADWEAR;
        }
        return EquipmentTypes.WORN;
    }

    public static Optional<Tuple<DamageModifier, Function<? super Double, Double>>> createResistanceModifier(EntityLivingBase entityLivingBase, DamageSource damageSource) {
        if (!damageSource.func_151517_h() && entityLivingBase.func_70644_a(MobEffects.field_76429_m) && damageSource != DamageSource.field_76380_i) {
            PotionEffect effect = (PotionEffect)entityLivingBase.func_70660_b(MobEffects.field_76429_m);
            return Optional.of(new Tuple<DamageModifier, Function<Double, Double>>(DamageModifier.builder().cause(Cause.of(NamedCause.of("Resistance", effect))).type(DamageModifierTypes.DEFENSIVE_POTION_EFFECT).build(), DamageEventHandler.createResistanceFunction(effect.getAmplifier())));
        }
        return Optional.empty();
    }

    public static Optional<List<Tuple<DamageModifier, Function<? super Double, Double>>>> createEnchantmentModifiers(EntityLivingBase entityLivingBase, DamageSource damageSource) {
        net.minecraft.item.ItemStack[] inventory;
        net.minecraft.item.ItemStack[] itemStackArray = inventory = entityLivingBase instanceof EntityPlayer ? ((EntityPlayer)entityLivingBase).field_71071_by.field_70460_b : entityLivingBase.field_184631_bt;
        if (EnchantmentHelper.func_77508_a(Arrays.asList(inventory), (DamageSource)damageSource) == 0) {
            return Optional.empty();
        }
        ArrayList<Tuple<DamageModifier, Function<Double, Double>>> modifiers = new ArrayList<Tuple<DamageModifier, Function<Double, Double>>>();
        boolean first = true;
        int totalModifier = 0;
        for (net.minecraft.item.ItemStack itemStack : inventory) {
            NBTTagList enchantmentList;
            if (itemStack == null || (enchantmentList = itemStack.func_77986_q()) == null) continue;
            for (int i = 0; i < enchantmentList.func_74745_c(); ++i) {
                Enchantment enchantment;
                int temp;
                short enchantmentId = enchantmentList.func_150305_b(i).func_74765_d("id");
                short level = enchantmentList.func_150305_b(i).func_74765_d("lvl");
                if (Enchantment.func_185262_c((int)enchantmentId) == null || (temp = (enchantment = Enchantment.func_185262_c((int)enchantmentId)).func_77318_a((int)level, damageSource)) == 0) continue;
                ItemStackSnapshot snapshot = ((ItemStack)itemStack).createSnapshot();
                DamageObject object = new DamageObject();
                int modifier = enchantment.func_77318_a((int)level, damageSource);
                object.previousDamage = totalModifier;
                if (object.previousDamage > 25.0) {
                    object.previousDamage = 25.0;
                }
                totalModifier += modifier;
                object.augment = first;
                object.ratio = modifier;
                Function<Double, Double> enchantmentFunction = damageIn -> {
                    if (object.augment) {
                        enchantmentDamageTracked = damageIn;
                    }
                    if (damageIn <= 0.0) {
                        return 0.0;
                    }
                    double actualDamage = enchantmentDamageTracked;
                    if (object.previousDamage > 25.0) {
                        return 0.0;
                    }
                    double modifierDamage = actualDamage;
                    if (modifier > 0 && modifier <= 20) {
                        int j = 25 - modifier;
                        double magicModifier = modifierDamage * (double)j;
                        modifierDamage = magicModifier / 25.0;
                    }
                    return -Math.max(actualDamage - modifierDamage, 0.0);
                };
                if (first) {
                    first = false;
                }
                DamageModifier enchantmentModifier = DamageModifier.builder().cause(Cause.of(NamedCause.of("ArmorEnchantment", enchantment), NamedCause.of("ItemStack", snapshot), NamedCause.source(entityLivingBase))).type(DamageModifierTypes.ARMOR_ENCHANTMENT).build();
                modifiers.add(new Tuple<DamageModifier, Function<Double, Double>>(enchantmentModifier, enchantmentFunction));
            }
        }
        if (!modifiers.isEmpty()) {
            return Optional.of(modifiers);
        }
        return Optional.empty();
    }

    public static Optional<Tuple<DamageModifier, Function<? super Double, Double>>> createAbsorptionModifier(EntityLivingBase entityLivingBase, DamageSource damageSource) {
        float absorptionAmount = entityLivingBase.func_110139_bj();
        if (absorptionAmount > 0.0f) {
            Function<Double, Double> function = damage -> -Math.max(damage - Math.max(damage - (double)absorptionAmount, 0.0), 0.0);
            DamageModifier modifier = DamageModifier.builder().cause(Cause.of(NamedCause.of("AbsorptionPotion", entityLivingBase), NamedCause.of("Creator", entityLivingBase))).type(DamageModifierTypes.ABSORPTION).build();
            return Optional.of(new Tuple<DamageModifier, Function<Double, Double>>(modifier, function));
        }
        return Optional.empty();
    }

    public static Location<World> findFirstMatchingBlock(net.minecraft.entity.Entity entity, AxisAlignedBB bb, Predicate<IBlockState> predicate) {
        int i = MathHelper.func_76128_c((double)bb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(bb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)bb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(bb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)bb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(bb.field_72334_f + 1.0));
        IMixinChunkProviderServer spongeChunkProvider = (IMixinChunkProviderServer)entity.field_70170_p.func_72863_F();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    BlockPos blockPos = new BlockPos(k1, l1, i2);
                    Chunk chunk = spongeChunkProvider.getLoadedChunkWithoutMarkingActive(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4);
                    if (chunk == null || !predicate.test(chunk.func_177435_g(blockPos))) continue;
                    return new Location<World>((World)entity.field_70170_p, k1, l1, i2);
                }
            }
        }
        return ((Entity)entity).getLocation();
    }

    public static Cause generateCauseFor(DamageSource damageSource) {
        if (damageSource instanceof EntityDamageSourceIndirect) {
            net.minecraft.entity.Entity source = damageSource.func_76346_g();
            ArrayList<NamedCause> causeObjects = new ArrayList<NamedCause>();
            causeObjects.add(NamedCause.source(damageSource));
            if (!(source instanceof EntityPlayer) && source != null) {
                IMixinEntity mixinEntity = EntityUtil.toMixin(source);
                mixinEntity.getNotifierUser().ifPresent(notifier -> causeObjects.add(NamedCause.notifier(notifier)));
                mixinEntity.getCreatorUser().ifPresent(owner -> causeObjects.add(NamedCause.owner(owner)));
            }
            return Cause.builder().addAll(causeObjects).build();
        }
        if (damageSource instanceof EntityDamageSource) {
            net.minecraft.entity.Entity source = damageSource.func_76346_g();
            ArrayList<NamedCause> causeObjects = new ArrayList<NamedCause>();
            causeObjects.add(NamedCause.source(damageSource));
            if (!(source instanceof EntityPlayer) && source != null) {
                IMixinEntity mixinEntity = EntityUtil.toMixin(source);
                mixinEntity.getNotifier().ifPresent(notifier -> causeObjects.add(NamedCause.notifier(notifier)));
                mixinEntity.getCreator().ifPresent(creator -> causeObjects.add(NamedCause.of("Creator", creator)));
            }
            return Cause.builder().addAll(causeObjects).build();
        }
        if (damageSource instanceof BlockDamageSource) {
            Cause.Builder builder = Cause.source(damageSource);
            Location<World> location = ((BlockDamageSource)damageSource).getLocation();
            BlockPos blockPos = ((IMixinLocation)((Object)location)).getBlockPos();
            IMixinChunk mixinChunk = (IMixinChunk)((net.minecraft.world.World)location.getExtent()).func_175726_f(blockPos);
            mixinChunk.getBlockNotifier(blockPos).ifPresent(notifier -> builder.named(NamedCause.notifier(notifier)));
            mixinChunk.getBlockOwner(blockPos).ifPresent(owner -> builder.named(NamedCause.of("Creator", owner)));
            return builder.build();
        }
        return Cause.of(NamedCause.source(damageSource));
    }

    public static List<Tuple<DamageModifier, Function<? super Double, Double>>> createAttackEnchamntmentFunction(final @Nullable net.minecraft.item.ItemStack heldItem, EnumCreatureAttribute creatureAttribute, float attackStrength) {
        ArrayList<Tuple<DamageModifier, Function<? super Double, Double>>> damageModifierFunctions = new ArrayList<Tuple<DamageModifier, Function<? super Double, Double>>>();
        if (heldItem != null) {
            Supplier<ItemStackSnapshot> supplier = new Supplier<ItemStackSnapshot>(){
                private ItemStackSnapshot snapshot;

                @Override
                public ItemStackSnapshot get() {
                    if (this.snapshot == null) {
                        this.snapshot = ItemStackUtil.createSnapshot(heldItem);
                    }
                    return this.snapshot;
                }
            };
            NBTTagList nbttaglist = heldItem.func_77986_q();
            if (nbttaglist != null) {
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    short j = nbttaglist.func_150305_b(i).func_74765_d("id");
                    short enchantmentLevel = nbttaglist.func_150305_b(i).func_74765_d("lvl");
                    Enchantment enchantment = Enchantment.func_185262_c((int)j);
                    if (enchantment == null) continue;
                    DamageModifier enchantmentModifier = DamageModifier.builder().type(DamageModifierTypes.WEAPON_ENCHANTMENT).cause(Cause.builder().named("Weapon", supplier.get()).named("Enchantment", enchantment).build()).build();
                    Function<Double, Double> enchantmentFunction = damage -> (double)enchantment.func_152376_a(enchantmentLevel, creatureAttribute) * (double)attackStrength;
                    damageModifierFunctions.add(new Tuple<DamageModifier, Function<Double, Double>>(enchantmentModifier, enchantmentFunction));
                }
            }
        }
        return damageModifierFunctions;
    }

    public static Tuple<DamageModifier, Function<? super Double, Double>> provideCriticalAttackTuple(EntityPlayer player) {
        DamageModifier modifier = DamageModifier.builder().cause(Cause.source(player).build()).type(DamageModifierTypes.CRITICAL_HIT).build();
        Function<Double, Double> function = damage -> damage * 1.5;
        return new Tuple<DamageModifier, Function<? super Double, Double>>(modifier, function);
    }

    public static DamageSource getEntityDamageSource(@Nullable net.minecraft.entity.Entity entity) {
        if (entity == null) {
            return null;
        }
        if (entity.field_70170_p instanceof IMixinWorldServer) {
            PhaseData peek = CauseTracker.getInstance().getCurrentPhaseData();
            return peek.state.getPhase().createDestructionDamageSource(peek.state, peek.context, entity).orElse(null);
        }
        return null;
    }

    public static Tuple<DamageModifier, Function<? super Double, Double>> provideCooldownAttackStrengthFunction(EntityPlayer player, float attackStrength) {
        DamageModifier modifier = DamageModifier.builder().cause(Cause.source(player).build()).type(DamageModifierTypes.ATTACK_COOLDOWN).build();
        Function<Double, Double> function = damage -> -damage.doubleValue() + damage * (double)(0.2f + attackStrength * attackStrength * 0.8f);
        return new Tuple<DamageModifier, Function<? super Double, Double>>(modifier, function);
    }
}

