/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public abstract class CapturedMultiMapSupplier<K, V>
implements Supplier<ListMultimap<K, V>> {
    @Nullable
    private ListMultimap<K, V> captured;

    CapturedMultiMapSupplier() {
    }

    @Override
    public ListMultimap<K, V> get() {
        if (this.captured == null) {
            this.captured = ArrayListMultimap.create();
        }
        return this.captured;
    }

    public final boolean isEmpty() {
        return this.captured == null || this.captured.isEmpty();
    }

    public final void ifPresentAndNotEmpty(Consumer<ListMultimap<K, V>> consumer) {
        if (this.captured != null && !this.captured.isEmpty()) {
            consumer.accept(this.captured);
        }
    }

    public final void ifPresentAndNotEmpty(BiConsumer<K, List<V>> biConsumer) {
        if (this.captured != null && !this.captured.isEmpty()) {
            for (Object key : this.captured.asMap().keySet()) {
                biConsumer.accept(key, this.captured.get(key));
            }
        }
    }

    public final void ifPresentAndNotEmpty(K key, Consumer<List<V>> consumer) {
        if (this.captured != null && !this.captured.isEmpty() && this.captured.containsKey(key)) {
            consumer.accept(this.captured.get(key));
        }
    }

    public final ListMultimap<K, V> orElse(ListMultimap<K, V> list) {
        return this.captured == null ? list : this.captured;
    }

    public final Stream<V> stream(K key) {
        return this.captured == null ? Stream.empty() : (this.captured.containsKey(key) ? this.captured.get(key).stream() : Stream.empty());
    }

    @Nullable
    public final <U> U map(K key, Function<List<V>, ? extends U> function) {
        return this.captured == null ? null : (U)function.apply(this.captured.get(key));
    }

    public int hashCode() {
        return Objects.hashCode(this.captured);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CapturedMultiMapSupplier other = (CapturedMultiMapSupplier)obj;
        return Objects.equals(this.captured, other.captured);
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("Captured", this.captured == null ? 0 : this.captured.size()).toString();
    }
}

