/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.helpers.Booleans;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.CauseStack;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.UnwindingPhaseContext;
import org.spongepowered.common.event.tracking.phase.TrackingPhase;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.entity.IMixinEntity;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;

public final class CauseTracker {
    public static final boolean ENABLED = Booleans.parseBoolean((String)System.getProperty("sponge.causeTracking"), (boolean)true);
    static final BiConsumer<PrettyPrinter, PhaseContext> CONTEXT_PRINTER = (printer, context) -> context.forEach(namedCause -> {
        printer.add("        - Name: %s", namedCause.getName());
        printer.addWrapped(100, "          Object: %s", namedCause.getCauseObject());
    });
    private static final BiConsumer<PrettyPrinter, PhaseData> PHASE_PRINTER = (printer, data) -> {
        printer.add("  - Phase: %s", data.state);
        printer.add("    Context:");
        data.context.forEach(namedCause -> {
            printer.add("    - Name: %s", namedCause.getName());
            Object causeObject = namedCause.getCauseObject();
            if (causeObject instanceof PhaseContext) {
                CONTEXT_PRINTER.accept((PrettyPrinter)printer, (PhaseContext)causeObject);
            } else {
                printer.addWrapped(100, "      Object: %s", causeObject);
            }
        });
    };
    private final CauseStack stack = new CauseStack();
    @Nullable
    private PhaseData currentProcessingState = null;
    public final boolean isVerbose = SpongeImpl.getGlobalConfig().getConfig().getCauseTracker().isVerbose();
    public final boolean verboseErrors = SpongeImpl.getGlobalConfig().getConfig().getCauseTracker().verboseErrors();
    private static final CauseTracker INSTANCE = new CauseTracker();

    private CauseTracker() {
        Preconditions.checkState((INSTANCE == null ? 1 : 0) != 0, (Object)"More than one CauseTracker instance is being created!!! Two cannot exist at once!");
    }

    public static CauseTracker getInstance() {
        return (CauseTracker)Preconditions.checkNotNull((Object)INSTANCE, (Object)"CauseTracker instance was illegally set to null!");
    }

    public void switchToPhase(IPhaseState state, PhaseContext phaseContext) {
        Preconditions.checkNotNull((Object)state, (Object)"State cannot be null!");
        Preconditions.checkNotNull((Object)state.getPhase(), (Object)"Phase cannot be null!");
        Preconditions.checkNotNull((Object)phaseContext, (Object)"PhaseContext cannot be null!");
        Preconditions.checkArgument((boolean)phaseContext.isComplete(), (Object)"PhaseContext must be complete!");
        IPhaseState currentState = this.stack.peek().state;
        if (this.isVerbose) {
            if (this.stack.size() > 6 && !currentState.isExpectedForReEntrance()) {
                this.printRunawayPhase(state, phaseContext);
            }
            if (!currentState.canSwitchTo(state) && state != GeneralPhase.Post.UNWINDING && currentState == GeneralPhase.Post.UNWINDING) {
                this.printPhaseIncompatibility(currentState, state);
            }
        }
        this.stack.push(state, phaseContext);
    }

    public void switchToPhase(IPhaseState state, PhaseContext context, Callable<Void> phaseBody) {
        this.switchToPhase(state, context);
        try {
            phaseBody.call();
        }
        catch (Exception | NoClassDefFoundError e) {
            this.abortCurrentPhase(e);
            return;
        }
        this.completePhase(state);
    }

    public void abortCurrentPhase(Throwable t) {
        PhaseData data = this.stack.peek();
        this.printMessageWithCaughtException("Exception during phase body", "Something happened trying to run the main body of a phase", data.state, data.context, t);
        this.stack.pop();
    }

    public void completePhase(IPhaseState prevState) {
        PhaseData currentPhaseData = this.stack.peek();
        IPhaseState state = currentPhaseData.state;
        boolean isEmpty = this.stack.isEmpty();
        if (isEmpty) {
            this.printEmptyStackOnCompletion();
            return;
        }
        if (prevState != state) {
            this.printIncorrectPhaseCompletion(prevState, state);
            this.stack.pop();
        }
        if (this.isVerbose && this.stack.size() > 6 && state != GeneralPhase.Post.UNWINDING && !state.isExpectedForReEntrance()) {
            this.printRunnawayPhaseCompletion(state);
        }
        this.stack.pop();
        TrackingPhase phase = state.getPhase();
        PhaseContext context = currentPhaseData.context;
        try {
            if (state != GeneralPhase.Post.UNWINDING && phase.requiresPost(state)) {
                this.switchToPhase(GeneralPhase.Post.UNWINDING, UnwindingPhaseContext.unwind(state, context).addCaptures().addEntityDropCaptures().complete());
            }
            try {
                this.currentProcessingState = currentPhaseData;
                phase.unwind(state, context);
                this.currentProcessingState = null;
            }
            catch (Exception | NoClassDefFoundError e) {
                this.printMessageWithCaughtException("Exception Exiting Phase", "Something happened when trying to unwind", state, context, e);
            }
            if (state != GeneralPhase.Post.UNWINDING && phase.requiresPost(state)) {
                try {
                    this.completePhase(GeneralPhase.Post.UNWINDING);
                }
                catch (Exception | NoClassDefFoundError e) {
                    this.printMessageWithCaughtException("Exception attempting to capture or spawn an Entity!", "Something happened trying to unwind", state, context, e);
                }
            }
        }
        catch (Exception | NoClassDefFoundError e) {
            this.printMessageWithCaughtException("Exception Post Dispatching Phase", "Something happened when trying to post dispatch state", state, context, e);
        }
    }

    private void printRunnawayPhaseCompletion(IPhaseState state) {
        PrettyPrinter printer = new PrettyPrinter(60);
        printer.add("Completing Phase").centre().hr();
        printer.addWrapped(50, "Detecting a runaway phase! Potentially a problem where something isn't completing a phase!!!", new Object[0]);
        printer.add();
        printer.addWrapped(60, "%s : %s", "Completing phase", state);
        printer.add(" Phases Remaining:");
        this.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseData)data));
        printer.add("Stacktrace:");
        printer.add(new Exception("Stack trace"));
        printer.add();
        this.generateVersionInfo(printer);
        printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
    }

    public void generateVersionInfo(PrettyPrinter printer) {
        for (PluginContainer pluginContainer : SpongeImpl.getInternalPlugins()) {
            pluginContainer.getVersion().ifPresent(version -> printer.add("%s : %s", pluginContainer.getName(), version));
        }
    }

    private void printIncorrectPhaseCompletion(IPhaseState prevState, IPhaseState state) {
        PrettyPrinter printer = new PrettyPrinter(60).add("Completing incorrect phase").centre().hr().addWrapped(50, "Sponge's tracking system is very dependent on knowing whena change to any world takes place, however, we are attemptingto complete a \"phase\" other than the one we most recently entered.This is an error usually on Sponge's part, so a reportis required on the issue tracker on GitHub.", new Object[0]).hr().add("Expected to exit phase: %s", prevState).add("But instead found phase: %s", state).add("StackTrace:").add(new Exception());
        printer.add(" Phases Remaining:");
        this.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseData)data));
        printer.add();
        this.generateVersionInfo(printer);
        printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
    }

    private void printEmptyStackOnCompletion() {
        PrettyPrinter printer = new PrettyPrinter(60).add("Unexpected ").centre().hr().addWrapped(50, "Sponge's tracking system is very dependent on knowing whena change to any world takes place, however, we have been toldto complete a \"phase\" without having entered any phases.This is an error usually on Sponge's part, so a reportis required on the issue tracker on GitHub.", new Object[0]).hr().add("StackTrace:").add(new Exception()).add();
        this.generateVersionInfo(printer);
        printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
    }

    private void printRunawayPhase(IPhaseState state, PhaseContext context) {
        PrettyPrinter printer = new PrettyPrinter(40);
        printer.add("Switching Phase").centre().hr();
        printer.addWrapped(50, "Detecting a runaway phase! Potentially a problem where something isn't completing a phase!!!", new Object[0]);
        printer.add("  %s : %s", "Entering Phase", state.getPhase());
        printer.add("  %s : %s", "Entering State", state);
        CONTEXT_PRINTER.accept(printer, context);
        printer.addWrapped(60, "%s :", "Phases remaining");
        this.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseData)data));
        printer.add("  %s :", "Printing stack trace").add(new Exception("Stack trace"));
        printer.add();
        this.generateVersionInfo(printer);
        printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
    }

    private void printPhaseIncompatibility(IPhaseState currentState, IPhaseState incompatibleState) {
        PrettyPrinter printer = new PrettyPrinter(80);
        printer.add("Switching Phase").centre().hr();
        printer.add("Phase incompatibility detected! Attempting to switch to an invalid phase!");
        printer.add("  %s : %s", "Current Phase", currentState.getPhase());
        printer.add("  %s : %s", "Current State", currentState);
        printer.add("  %s : %s", "Entering incompatible Phase", incompatibleState.getPhase());
        printer.add("  %s : %s", "Entering incompatible State", incompatibleState);
        printer.add("%s :", "Current phases");
        this.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseData)data));
        printer.add("  %s :", "Printing stack trace");
        printer.add(new Exception("Stack trace"));
        printer.add();
        this.generateVersionInfo(printer);
        printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
    }

    public void printMessageWithCaughtException(String header, String subHeader, Exception e) {
        this.printMessageWithCaughtException(header, subHeader, this.getCurrentState(), this.getCurrentContext(), e);
    }

    public void printMessageWithCaughtException(String header, String subHeader, IPhaseState state, PhaseContext context, Throwable t) {
        PrettyPrinter printer = new PrettyPrinter(40);
        printer.add(header).centre().hr().add("%s %s", subHeader, state).addWrapped(40, "%s :", "PhaseContext");
        CONTEXT_PRINTER.accept(printer, context);
        printer.addWrapped(60, "%s :", "Phases remaining");
        this.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseData)data));
        printer.add("Stacktrace:").add(t);
        printer.add();
        this.generateVersionInfo(printer);
        printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
    }

    public String dumpStack() {
        if (this.stack.isEmpty()) {
            return "[Empty stack]";
        }
        PrettyPrinter printer = new PrettyPrinter(40);
        this.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseData)data));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        printer.print(new PrintStream(stream));
        return stream.toString();
    }

    public PhaseData getCurrentPhaseData() {
        return this.stack.peek();
    }

    public IPhaseState getCurrentState() {
        return this.stack.peekState();
    }

    public PhaseContext getCurrentContext() {
        return this.stack.peekContext();
    }

    public PhaseData getCurrentProcessingPhase() {
        return this.currentProcessingState == null ? CauseStack.EMPTY_DATA : this.currentProcessingState;
    }

    public void notifyBlockOfStateChange(IMixinWorldServer mixinWorld, BlockPos notifyPos, Block sourceBlock, @Nullable BlockPos sourcePos) {
        IBlockState iblockstate = ((WorldServer)mixinWorld).func_180495_p(notifyPos);
        try {
            if (ENABLED) {
                PhaseData peek = this.stack.peek();
                IPhaseState state = peek.state;
                state.getPhase().associateNeighborStateNotifier(state, peek.context, sourcePos, iblockstate.func_177230_c(), notifyPos, (WorldServer)mixinWorld, PlayerTracker.Type.NOTIFIER);
            }
            iblockstate.func_189546_a((net.minecraft.world.World)((WorldServer)mixinWorld), notifyPos, sourceBlock);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Exception while updating neighbours");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being updated");
            crashreportcategory.func_189529_a("Source block type", () -> {
                try {
                    return String.format("ID #%d (%s // %s)", Block.func_149682_b((Block)sourceBlock), sourceBlock.func_149739_a(), sourceBlock.getClass().getCanonicalName());
                }
                catch (Throwable var2) {
                    return "ID #" + Block.func_149682_b((Block)sourceBlock);
                }
            });
            CrashReportCategory.func_175750_a((CrashReportCategory)crashreportcategory, (BlockPos)notifyPos, (IBlockState)iblockstate);
            throw new ReportedException(crashreport);
        }
    }

    public boolean setBlockState(IMixinWorldServer mixinWorld, BlockPos pos, IBlockState newState, int flags) {
        boolean isComplete;
        WorldServer minecraftWorld = mixinWorld.asMinecraftWorld();
        Chunk chunk = minecraftWorld.func_175726_f(pos);
        if (chunk.func_76621_g()) {
            return false;
        }
        Block newBlock = newState.func_177230_c();
        IBlockState currentState = chunk.func_177435_g(pos);
        if (currentState == newState) {
            return false;
        }
        PhaseData phaseData = this.stack.peek();
        IPhaseState phaseState = phaseData.state;
        boolean bl = isComplete = phaseState == GeneralPhase.State.COMPLETE;
        if (ENABLED && this.isVerbose && isComplete) {
            new PrettyPrinter(60).add("Unexpected World Change Detected").centre().hr().add("Sponge's tracking system is very dependent on knowing when\na change to any world takes place, however there are chances\nwhere Sponge does not know of changes that mods may perform.\nIn cases like this, it is best to report to Sponge to get this\nchange tracked correctly and accurately.").hr().add("StackTrace:").add(new Exception()).trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
        }
        if (ENABLED && phaseState.getPhase().requiresBlockCapturing(phaseState)) {
            try {
                return TrackingUtil.trackBlockChange(this, mixinWorld, chunk, currentState, newState, pos, flags, phaseData.context, phaseState);
            }
            catch (Exception | NoClassDefFoundError e) {
                PrettyPrinter printer = new PrettyPrinter(60).add("Exception attempting to capture a block change!").centre().hr();
                printer.addWrapped(40, "%s :", "PhaseContext");
                CONTEXT_PRINTER.accept(printer, phaseData.context);
                printer.addWrapped(60, "%s :", "Phases remaining");
                this.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseData)data));
                printer.add("Stacktrace:");
                printer.add(e);
                printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
                return false;
            }
        }
        IBlockState iblockstate = chunk.func_177436_a(pos, newState);
        if (iblockstate == null) {
            return false;
        }
        if (newState.func_185891_c() != iblockstate.func_185891_c() || newState.func_185906_d() != iblockstate.func_185906_d()) {
            minecraftWorld.field_72984_F.func_76320_a("checkLight");
            minecraftWorld.func_175664_x(pos);
            minecraftWorld.field_72984_F.func_76319_b();
        }
        if ((flags & 2) != 0 && (flags & 4) == 0 && chunk.func_150802_k()) {
            minecraftWorld.func_184138_a(pos, iblockstate, newState, flags);
        }
        if (!minecraftWorld.field_72995_K && (flags & 1) != 0) {
            minecraftWorld.func_175722_b(pos, iblockstate.func_177230_c());
            if (newState.func_185912_n()) {
                minecraftWorld.func_175666_e(pos, newBlock);
            }
        }
        return true;
    }

    public boolean setBlockStateWithFlag(IMixinWorldServer mixinWorld, BlockPos pos, IBlockState newState, BlockChangeFlag flag) {
        WorldServer minecraftWorld = mixinWorld.asMinecraftWorld();
        Chunk chunk = minecraftWorld.func_175726_f(pos);
        IMixinChunk mixinChunk = (IMixinChunk)chunk;
        Block newBlock = newState.func_177230_c();
        IBlockState currentState = chunk.func_177435_g(pos);
        if (currentState == newState) {
            return false;
        }
        IBlockState iblockstate = mixinChunk.setBlockState(pos, newState, currentState, null, flag);
        if (iblockstate == null) {
            return false;
        }
        if (newState.func_185891_c() != iblockstate.func_185891_c() || newState.func_185906_d() != iblockstate.func_185906_d()) {
            minecraftWorld.field_72984_F.func_76320_a("checkLight");
            minecraftWorld.func_175664_x(pos);
            minecraftWorld.field_72984_F.func_76319_b();
        }
        if (chunk.func_150802_k()) {
            minecraftWorld.func_184138_a(pos, iblockstate, newState, flag.updateNeighbors() ? 3 : 2);
        }
        if (flag.updateNeighbors()) {
            minecraftWorld.func_175722_b(pos, iblockstate.func_177230_c());
            if (newState.func_185912_n()) {
                minecraftWorld.func_175666_e(pos, newBlock);
            }
        }
        return true;
    }

    public boolean spawnEntity(World world, Entity entity) {
        EntityThrowable throwable;
        EntityLivingBase thrower;
        boolean isForced;
        Preconditions.checkNotNull((Object)entity, (Object)"Entity cannot be null!");
        if (((IMixinEntity)entity).isInConstructPhase()) {
            ((IMixinEntity)entity).firePostConstructEvents();
        }
        net.minecraft.entity.Entity minecraftEntity = EntityUtil.toNative(entity);
        WorldServer minecraftWorld = (WorldServer)world;
        IMixinWorldServer mixinWorldServer = (IMixinWorldServer)minecraftWorld;
        PhaseData phaseData = this.stack.peek();
        IPhaseState phaseState = phaseData.state;
        PhaseContext context = phaseData.context;
        TrackingPhase phase = phaseState.getPhase();
        boolean bl = isForced = minecraftEntity.field_98038_p || minecraftEntity instanceof EntityPlayer;
        if (!isForced && !phase.allowEntitySpawns(phaseState)) {
            return false;
        }
        int chunkX = MathHelper.func_76128_c((double)(minecraftEntity.field_70165_t / 16.0));
        int chunkZ = MathHelper.func_76128_c((double)(minecraftEntity.field_70161_v / 16.0));
        if (!isForced && !mixinWorldServer.isMinecraftChunkLoaded(chunkX, chunkZ, true)) {
            return false;
        }
        if (minecraftEntity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)minecraftEntity;
            minecraftWorld.field_73010_i.add(entityplayer);
            minecraftWorld.func_72854_c();
            SpongeImplHooks.firePlayerJoinSpawnEvent((EntityPlayerMP)entityplayer);
        } else if (minecraftEntity instanceof IEntityOwnable) {
            IEntityOwnable ownable = (IEntityOwnable)entity;
            net.minecraft.entity.Entity owner = ownable.func_70902_q();
            if (owner != null && owner instanceof EntityPlayer) {
                context.owner = (User)owner;
                entity.setCreator(ownable.func_184753_b());
            }
        } else if (minecraftEntity instanceof EntityThrowable && (thrower = (throwable = (EntityThrowable)minecraftEntity).func_85052_h()) != null) {
            User user = null;
            user = !(thrower instanceof EntityPlayer) ? (User)((IMixinEntity)thrower).getCreatorUser().orElse(null) : (User)thrower;
            if (user != null) {
                context.owner = user;
                entity.setCreator(user.getUniqueId());
            }
        }
        if (!isForced) {
            try {
                return phase.spawnEntityOrCapture(phaseState, context, entity, chunkX, chunkZ);
            }
            catch (Exception | NoClassDefFoundError e) {
                PrettyPrinter printer = new PrettyPrinter(60).add("Exception attempting to capture or spawn an Entity!").centre().hr();
                printer.addWrapped(40, "%s :", "PhaseContext");
                CONTEXT_PRINTER.accept(printer, context);
                printer.addWrapped(60, "%s :", "Phases remaining");
                this.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseData)data));
                printer.add("Stacktrace:");
                printer.add(e);
                printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
                return false;
            }
        }
        minecraftWorld.func_72964_e(chunkX, chunkZ).func_76612_a(minecraftEntity);
        minecraftWorld.field_72996_f.add(minecraftEntity);
        mixinWorldServer.onSpongeEntityAdded(minecraftEntity);
        return true;
    }

    public boolean spawnEntityWithCause(World world, Entity entity, Cause cause) {
        boolean isForced;
        Preconditions.checkNotNull((Object)entity, (Object)"Entity cannot be null!");
        Preconditions.checkNotNull((Object)cause, (Object)"Cause cannot be null!");
        if (((IMixinEntity)entity).isInConstructPhase()) {
            ((IMixinEntity)entity).firePostConstructEvents();
        }
        net.minecraft.entity.Entity minecraftEntity = EntityUtil.toNative(entity);
        World spongeWorld = world;
        WorldServer worldServer = (WorldServer)world;
        IMixinWorldServer mixinWorldServer = (IMixinWorldServer)worldServer;
        int chunkX = MathHelper.func_76128_c((double)(minecraftEntity.field_70165_t / 16.0));
        int chunkZ = MathHelper.func_76128_c((double)(minecraftEntity.field_70161_v / 16.0));
        boolean bl = isForced = minecraftEntity.field_98038_p || minecraftEntity instanceof EntityPlayer;
        if (!isForced && !mixinWorldServer.isMinecraftChunkLoaded(chunkX, chunkZ, true)) {
            return false;
        }
        ArrayList<Entity> entities = new ArrayList<Entity>(1);
        entities.add(entity);
        SpawnEntityEvent.Custom event = SpongeEventFactory.createSpawnEntityEventCustom(cause, entities, spongeWorld);
        SpongeImpl.postEvent(event);
        if (entity instanceof EntityPlayer || !event.isCancelled()) {
            mixinWorldServer.forceSpawnEntity(entity);
        }
        return true;
    }
}

