/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.common.event.tracking.CapturedMultiMapSupplier;
import org.spongepowered.common.event.tracking.CapturedSupplier;
import org.spongepowered.common.event.tracking.ItemDropData;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;

public class PhaseContext {
    private boolean isCompleted = false;
    private final ArrayList<NamedCause> contextObjects = new ArrayList(10);
    @Nullable
    private Cause cause = null;
    @Nullable
    private CapturedBlocksSupplier blocksSupplier;
    @Nullable
    private BlockItemDropsSupplier blockItemDropsSupplier;
    @Nullable
    private BlockItemEntityDropsSupplier blockItemEntityDropsSupplier;
    @Nullable
    private CapturedItemsSupplier capturedItemsSupplier;
    @Nullable
    private CapturedEntitiesSupplier capturedEntitiesSupplier;
    @Nullable
    private CapturedItemStackSupplier capturedItemStackSupplier;
    @Nullable
    private EntityItemDropsSupplier entityItemDropsSupplier;
    @Nullable
    private EntityItemEntityDropsSupplier entityItemEntityDropsSupplier;
    @Nullable
    private CapturedMultiMapSupplier<BlockPos, Entity> blockEntitySpawnSupplier;
    @Nullable
    private CaptureBlockPos captureBlockPos;
    @Nullable
    protected User owner;
    @Nullable
    protected User notifier;
    private Object source;
    @Nullable
    private Class<?> cachedClass;
    @Nullable
    private Object cachedObject;
    @Nullable
    private String cachedName;

    public static PhaseContext start() {
        return new PhaseContext();
    }

    public PhaseContext add(@Nullable NamedCause namedCause) {
        if (namedCause == null) {
            return this;
        }
        Preconditions.checkState((!this.isCompleted ? 1 : 0) != 0, (Object)"Cannot add a new object to the context if it's already marked as completed!");
        this.contextObjects.add(namedCause);
        if (namedCause.getName().equals("Source")) {
            this.source = namedCause.getCauseObject();
        }
        return this;
    }

    public PhaseContext owner(User owner) {
        Preconditions.checkState((!this.isCompleted ? 1 : 0) != 0, (Object)"Cannot add a new object to the context if it's already marked as completed!");
        if (this.owner != null) {
            throw new IllegalStateException("Owner for this phase context is already set!");
        }
        this.owner = (User)Preconditions.checkNotNull((Object)owner, (Object)"Owner cannot be null!");
        this.contextObjects.add(NamedCause.owner(owner));
        return this;
    }

    public PhaseContext notifier(User notifier) {
        Preconditions.checkState((!this.isCompleted ? 1 : 0) != 0, (Object)"Cannot add a new object to the context if it's already marked as completed!");
        if (this.notifier != null) {
            throw new IllegalStateException("Notifier for this phase context is already set!");
        }
        this.notifier = (User)Preconditions.checkNotNull((Object)notifier, (Object)"Notifier cannot be null!");
        this.contextObjects.add(NamedCause.notifier(notifier));
        return this;
    }

    private void checkBlockSuppliers() {
        Preconditions.checkState((this.blocksSupplier == null ? 1 : 0) != 0, (Object)"BlocksSuppler is already set!");
        Preconditions.checkState((this.blockItemEntityDropsSupplier == null ? 1 : 0) != 0, (Object)"BlockItemEntityDropsSupplier is already set!");
        Preconditions.checkState((this.blockItemDropsSupplier == null ? 1 : 0) != 0, (Object)"BlockItemDropsSupplier is already set!");
        Preconditions.checkState((this.blockEntitySpawnSupplier == null ? 1 : 0) != 0, (Object)"BlockEntitySpawnSupplier is already set!");
        Preconditions.checkState((this.captureBlockPos == null ? 1 : 0) != 0, (Object)"CaptureBlockPos is already set!");
    }

    public PhaseContext addBlockCaptures() {
        CaptureBlockPos blockPos;
        CapturedBlockEntitySpawnSupplier capturedBlockEntitySpawnSupplier;
        BlockItemDropsSupplier blockItemDropsSupplier;
        BlockItemEntityDropsSupplier blockItemEntityDropsSupplier;
        Preconditions.checkState((!this.isCompleted ? 1 : 0) != 0, (Object)"Cannot add a new object to the context if it's already marked as completed!");
        this.checkBlockSuppliers();
        CapturedBlocksSupplier blocksSupplier = new CapturedBlocksSupplier();
        this.contextObjects.add(NamedCause.of("CapturedBlocks", blocksSupplier));
        this.blocksSupplier = blocksSupplier;
        this.blockItemEntityDropsSupplier = blockItemEntityDropsSupplier = new BlockItemEntityDropsSupplier();
        this.blockItemDropsSupplier = blockItemDropsSupplier = new BlockItemDropsSupplier();
        this.blockEntitySpawnSupplier = capturedBlockEntitySpawnSupplier = new CapturedBlockEntitySpawnSupplier();
        this.captureBlockPos = blockPos = new CaptureBlockPos();
        return this;
    }

    public PhaseContext addCaptures() {
        CapturedBlockEntitySpawnSupplier capturedBlockEntitySpawnSupplier;
        CapturedItemStackSupplier capturedItemStackSupplier;
        CapturedItemsSupplier capturedItemsSupplier;
        BlockItemDropsSupplier blockItemDropsSupplier;
        BlockItemEntityDropsSupplier blockItemEntityDropsSupplier;
        Preconditions.checkState((!this.isCompleted ? 1 : 0) != 0, (Object)"Cannot add a new object to the context if it's already marked as completed!");
        this.checkBlockSuppliers();
        Preconditions.checkState((this.capturedItemsSupplier == null ? 1 : 0) != 0, (Object)"CapturedItemsSupplier is already set!");
        Preconditions.checkState((this.capturedEntitiesSupplier == null ? 1 : 0) != 0, (Object)"CapturedEntitiesSupplier is already set!");
        Preconditions.checkState((this.capturedItemStackSupplier == null ? 1 : 0) != 0, (Object)"CapturedItemStackSupplier is already set!");
        CapturedBlocksSupplier blocksSupplier = new CapturedBlocksSupplier();
        this.contextObjects.add(NamedCause.of("CapturedBlocks", blocksSupplier));
        this.blocksSupplier = blocksSupplier;
        this.blockItemEntityDropsSupplier = blockItemEntityDropsSupplier = new BlockItemEntityDropsSupplier();
        this.blockItemDropsSupplier = blockItemDropsSupplier = new BlockItemDropsSupplier();
        this.capturedItemsSupplier = capturedItemsSupplier = new CapturedItemsSupplier();
        CapturedEntitiesSupplier capturedEntitiesSupplier = new CapturedEntitiesSupplier();
        this.contextObjects.add(NamedCause.of("CapturedEntities", capturedEntitiesSupplier));
        this.capturedEntitiesSupplier = capturedEntitiesSupplier;
        this.capturedItemStackSupplier = capturedItemStackSupplier = new CapturedItemStackSupplier();
        this.blockEntitySpawnSupplier = capturedBlockEntitySpawnSupplier = new CapturedBlockEntitySpawnSupplier();
        return this;
    }

    public PhaseContext addEntityCaptures() {
        CapturedItemStackSupplier capturedItemStackSupplier;
        CapturedItemsSupplier capturedItemsSupplier;
        Preconditions.checkState((!this.isCompleted ? 1 : 0) != 0, (Object)"Cannot add a new object to the context if it's already marked as completed!");
        Preconditions.checkState((this.capturedItemsSupplier == null ? 1 : 0) != 0, (Object)"CapturedItemsSupplier is already set!");
        Preconditions.checkState((this.capturedEntitiesSupplier == null ? 1 : 0) != 0, (Object)"CapturedEntitiesSupplier is already set!");
        Preconditions.checkState((this.capturedItemStackSupplier == null ? 1 : 0) != 0, (Object)"CapturedItemStackSupplier is already set!");
        this.capturedItemsSupplier = capturedItemsSupplier = new CapturedItemsSupplier();
        CapturedEntitiesSupplier capturedEntitiesSupplier = new CapturedEntitiesSupplier();
        this.contextObjects.add(NamedCause.of("CapturedEntities", capturedEntitiesSupplier));
        this.capturedEntitiesSupplier = capturedEntitiesSupplier;
        this.capturedItemStackSupplier = capturedItemStackSupplier = new CapturedItemStackSupplier();
        return this;
    }

    public PhaseContext addEntityDropCaptures() {
        EntityItemEntityDropsSupplier entityItemEntityDropsSupplier;
        EntityItemDropsSupplier entityItemDropsSupplier;
        Preconditions.checkState((!this.isCompleted ? 1 : 0) != 0, (Object)"Cannot add a new object to the context if it's already marked as completed!");
        Preconditions.checkState((this.entityItemDropsSupplier == null ? 1 : 0) != 0, (Object)"EntityItemDropsSupplier is already set!");
        Preconditions.checkState((this.entityItemEntityDropsSupplier == null ? 1 : 0) != 0, (Object)"EntityItemEntityDropsSupplier is already set!");
        this.entityItemDropsSupplier = entityItemDropsSupplier = new EntityItemDropsSupplier();
        this.entityItemEntityDropsSupplier = entityItemEntityDropsSupplier = new EntityItemEntityDropsSupplier();
        return this;
    }

    public PhaseContext player() {
        Preconditions.checkState((!this.isCompleted ? 1 : 0) != 0, (Object)"Cannot add a new object to the context if it's already marked as completed!");
        this.contextObjects.add(NamedCause.of("CapturedPlayer", new CapturePlayer()));
        return this;
    }

    public PhaseContext player(@Nullable Player player) {
        Preconditions.checkState((!this.isCompleted ? 1 : 0) != 0, (Object)"Cannot add a new object to the context if it's already marked as completed!");
        this.contextObjects.add(NamedCause.of("CapturedPlayer", new CapturePlayer(player)));
        return this;
    }

    public PhaseContext explosion() {
        Preconditions.checkState((!this.isCompleted ? 1 : 0) != 0, (Object)"CAnnot add a new object to the context if it's already marked as completed!");
        this.contextObjects.add(NamedCause.of("CapturedExplosion", new CaptureExplosion()));
        return this;
    }

    public PhaseContext explosion(@Nullable Explosion explosion) {
        Preconditions.checkState((!this.isCompleted ? 1 : 0) != 0, (Object)"CAnnot add a new object to the context if it's already marked as completed!");
        this.contextObjects.add(NamedCause.of("CapturedExplosion", new CaptureExplosion(explosion)));
        return this;
    }

    public CaptureExplosion getCaptureExplosion() {
        return this.firstNamed("CapturedExplosion", CaptureExplosion.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be capturing an Explosion, but we're not capturing them!", this));
    }

    public Optional<Explosion> getExplosion() {
        return this.getCaptureExplosion().getExplosion();
    }

    public PhaseContext complete() {
        this.isCompleted = true;
        return this;
    }

    public boolean isComplete() {
        return this.isCompleted;
    }

    public <T> Optional<T> first(Class<T> tClass) {
        if (this.cachedClass != null && this.cachedClass == tClass && this.cachedObject != null) {
            return Optional.of(this.cachedObject);
        }
        for (NamedCause cause : this.contextObjects) {
            if (!tClass.isInstance(cause.getCauseObject())) continue;
            Object causeObject = cause.getCauseObject();
            this.cachedClass = tClass;
            this.cachedObject = causeObject;
            this.cachedName = cause.getName();
            return Optional.of(causeObject);
        }
        return Optional.empty();
    }

    public <T> Optional<T> firstNamed(String name, Class<T> tClass) {
        if (name.equals(this.cachedName) && tClass == this.cachedClass && this.cachedObject != null) {
            return Optional.of(this.cachedObject);
        }
        for (NamedCause cause : this.contextObjects) {
            if (!cause.getName().equalsIgnoreCase(name) || !tClass.isInstance(cause.getCauseObject())) continue;
            this.cachedObject = cause.getCauseObject();
            this.cachedClass = tClass;
            this.cachedName = name;
            return Optional.of(cause.getCauseObject());
        }
        return Optional.empty();
    }

    public <T> Optional<T> getSource(Class<T> sourceClass) {
        if (this.source == null) {
            return Optional.empty();
        }
        if (sourceClass.isInstance(this.source)) {
            return Optional.of(this.source);
        }
        return Optional.empty();
    }

    public Optional<User> getOwner() {
        return Optional.ofNullable(this.owner);
    }

    public Optional<User> getNotifier() {
        return Optional.ofNullable(this.notifier);
    }

    public List<org.spongepowered.api.entity.Entity> getCapturedEntities() throws IllegalStateException {
        return this.firstNamed("CapturedEntities", CapturedEntitiesSupplier.class).map(CapturedSupplier::get).orElseThrow(TrackingUtil.throwWithContext("Intended to capture entity spawns!", this));
    }

    public CapturedSupplier<org.spongepowered.api.entity.Entity> getCapturedEntitySupplier() throws IllegalStateException {
        if (this.capturedEntitiesSupplier == null) {
            throw TrackingUtil.throwWithContext("Intended to capture entity spawns!", this).get();
        }
        return this.capturedEntitiesSupplier;
    }

    public List<EntityItem> getCapturedItems() throws IllegalStateException {
        if (this.capturedItemsSupplier == null) {
            throw TrackingUtil.throwWithContext("Intended to capture dropped item entities!", this).get();
        }
        return this.capturedItemsSupplier.get();
    }

    public CapturedSupplier<EntityItem> getCapturedItemsSupplier() throws IllegalStateException {
        if (this.capturedItemsSupplier == null) {
            throw TrackingUtil.throwWithContext("Intended to capture dropped item entities!", this).get();
        }
        return this.capturedItemsSupplier;
    }

    public List<BlockSnapshot> getCapturedBlocks() throws IllegalStateException {
        return this.firstNamed("CapturedBlocks", CapturedBlocksSupplier.class).map(CapturedSupplier::get).orElseThrow(TrackingUtil.throwWithContext("Intended to capture block changes, but there is no list available!", this));
    }

    public CapturedSupplier<BlockSnapshot> getCapturedBlockSupplier() throws IllegalStateException {
        if (this.blocksSupplier == null) {
            throw TrackingUtil.throwWithContext("Expected to be capturing blocks, but we're not capturing them!", this).get();
        }
        return this.blocksSupplier;
    }

    public Multimap<BlockPos, ItemDropData> getCapturedBlockDrops() throws IllegalStateException {
        if (this.blockItemDropsSupplier == null) {
            throw TrackingUtil.throwWithContext("Expected to be capturing block drops!", this).get();
        }
        return this.blockItemDropsSupplier.get();
    }

    public CapturedMultiMapSupplier<BlockPos, ItemDropData> getBlockDropSupplier() throws IllegalStateException {
        if (this.blockItemDropsSupplier == null) {
            throw TrackingUtil.throwWithContext("Expected to be capturing block drops!", this).get();
        }
        return this.blockItemDropsSupplier;
    }

    public CapturedMultiMapSupplier<BlockPos, EntityItem> getBlockItemDropSupplier() throws IllegalStateException {
        if (this.blockItemEntityDropsSupplier == null) {
            throw TrackingUtil.throwWithContext("Intended to track block item drops!", this).get();
        }
        return this.blockItemEntityDropsSupplier;
    }

    public CapturedMultiMapSupplier<UUID, ItemDropData> getCapturedEntityDropSupplier() throws IllegalStateException {
        if (this.entityItemDropsSupplier == null) {
            throw TrackingUtil.throwWithContext("Intended to capture entity drops!", this).get();
        }
        return this.entityItemDropsSupplier;
    }

    public CapturedMultiMapSupplier<UUID, EntityItem> getCapturedEntityItemDropSupplier() throws IllegalStateException {
        if (this.entityItemEntityDropsSupplier == null) {
            throw TrackingUtil.throwWithContext("Intended to capture entity drops!", this).get();
        }
        return this.entityItemEntityDropsSupplier;
    }

    public CapturedSupplier<ItemDropData> getCapturedItemStackSupplier() throws IllegalStateException {
        if (this.capturedItemStackSupplier == null) {
            throw TrackingUtil.throwWithContext("Expected to be capturing ItemStack drops from entities!", this).get();
        }
        return this.capturedItemStackSupplier;
    }

    public CapturedMultiMapSupplier<BlockPos, Entity> getBlockEntitySpawnSupplier() throws IllegalStateException {
        if (this.blockEntitySpawnSupplier == null) {
            throw TrackingUtil.throwWithContext("Intended to track block entity spawns!", this).get();
        }
        return this.blockEntitySpawnSupplier;
    }

    public CaptureBlockPos getCaptureBlockPos() throws IllegalStateException {
        if (this.captureBlockPos == null) {
            throw TrackingUtil.throwWithContext("Intended to capture a block position!", this).get();
        }
        return this.captureBlockPos;
    }

    public Optional<BlockPos> getBlockPosition() {
        return this.getCaptureBlockPos().getPos();
    }

    public CapturePlayer getCapturedPlayerSupplier() throws IllegalStateException {
        return this.firstNamed("CapturedPlayer", CapturePlayer.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be capturing a Player from an event listener, but we're not capturing them!", this));
    }

    public Optional<Player> getCapturedPlayer() throws IllegalStateException {
        return this.firstNamed("CapturedPlayer", CapturePlayer.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be capturing a Player from an event listener, but we're not capturing them!", this)).getPlayer();
    }

    public void forEach(Consumer<NamedCause> consumer) {
        this.contextObjects.forEach(consumer);
    }

    PhaseContext() {
    }

    public int hashCode() {
        return Objects.hash(this.isCompleted, this.contextObjects, this.cause);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PhaseContext other = (PhaseContext)obj;
        return Objects.equals(this.isCompleted, other.isCompleted) && Objects.equals(this.contextObjects, other.contextObjects) && Objects.equals(this.cause, other.cause);
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("isCompleted", this.isCompleted).add("contextObjects", this.contextObjects).add("cause", (Object)this.cause).toString();
    }

    public static final class CaptureBlockPos {
        @Nullable
        private BlockPos pos;
        @Nullable
        private WeakReference<IMixinWorldServer> mixinWorldReference;

        public CaptureBlockPos() {
        }

        public CaptureBlockPos(@Nullable BlockPos pos) {
            this.pos = pos;
        }

        public Optional<BlockPos> getPos() {
            return Optional.ofNullable(this.pos);
        }

        public void setPos(@Nullable BlockPos pos) {
            this.pos = pos;
        }

        public void setWorld(@Nullable IMixinWorldServer world) {
            this.mixinWorldReference = world == null ? null : new WeakReference<IMixinWorldServer>(world);
        }

        public void setWorld(@Nullable WorldServer world) {
            this.mixinWorldReference = world == null ? null : new WeakReference<IMixinWorldServer>((IMixinWorldServer)world);
        }

        public Optional<IMixinWorldServer> getMixinWorld() {
            return this.mixinWorldReference == null ? Optional.empty() : Optional.ofNullable(this.mixinWorldReference.get());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CaptureBlockPos that = (CaptureBlockPos)o;
            return com.google.common.base.Objects.equal((Object)this.pos, (Object)that.pos);
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.pos});
        }
    }

    public static final class CaptureFlag {
        @Nullable
        private BlockChangeFlag flag;

        public CaptureFlag() {
        }

        public CaptureFlag(@Nullable BlockChangeFlag flag) {
            this.flag = flag;
        }

        public Optional<BlockChangeFlag> getFlag() {
            return Optional.ofNullable(this.flag);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CaptureFlag that = (CaptureFlag)o;
            return this.flag == that.flag;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.flag});
        }

        public void addFlag(BlockChangeFlag flag) {
            this.flag = flag;
        }
    }

    public static final class CaptureExplosion {
        @Nullable
        private Explosion explosion;

        CaptureExplosion() {
        }

        CaptureExplosion(@Nullable Explosion explosion) {
            this.explosion = explosion;
        }

        public Optional<Explosion> getExplosion() {
            return Optional.ofNullable(this.explosion);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CaptureExplosion that = (CaptureExplosion)o;
            return com.google.common.base.Objects.equal((Object)this.explosion, (Object)that.explosion);
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.explosion});
        }

        public String toString() {
            return com.google.common.base.Objects.toStringHelper((Object)this).add("explosion", (Object)this.explosion).toString();
        }

        public void addExplosion(Explosion explosion) {
            this.explosion = explosion;
        }
    }

    public static final class CapturePlayer {
        @Nullable
        private Player player;

        CapturePlayer() {
        }

        CapturePlayer(@Nullable Player player) {
            this.player = player;
        }

        public Optional<Player> getPlayer() {
            return Optional.ofNullable(this.player);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CapturePlayer that = (CapturePlayer)o;
            return com.google.common.base.Objects.equal((Object)this.player, (Object)that.player);
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.player});
        }

        public String toString() {
            return com.google.common.base.Objects.toStringHelper((Object)this).add("player", (Object)this.player).toString();
        }

        public void addPlayer(EntityPlayerMP playerMP) {
            this.player = (Player)playerMP;
        }
    }

    static final class CapturedBlockEntitySpawnSupplier
    extends CapturedMultiMapSupplier<BlockPos, Entity> {
        CapturedBlockEntitySpawnSupplier() {
        }
    }

    static final class BlockItemEntityDropsSupplier
    extends CapturedMultiMapSupplier<BlockPos, EntityItem> {
        BlockItemEntityDropsSupplier() {
        }
    }

    static final class EntityItemEntityDropsSupplier
    extends CapturedMultiMapSupplier<UUID, EntityItem> {
        EntityItemEntityDropsSupplier() {
        }
    }

    static final class CapturedEntitiesSupplier
    extends CapturedSupplier<org.spongepowered.api.entity.Entity> {
        CapturedEntitiesSupplier() {
        }
    }

    static final class CapturedBlocksSupplier
    extends CapturedSupplier<BlockSnapshot> {
        CapturedBlocksSupplier() {
        }
    }

    static final class CapturedItemStackSupplier
    extends CapturedSupplier<ItemDropData> {
        CapturedItemStackSupplier() {
        }
    }

    static final class CapturedItemsSupplier
    extends CapturedSupplier<EntityItem> {
        CapturedItemsSupplier() {
        }
    }

    static class EntityItemDropsSupplier
    extends CapturedMultiMapSupplier<UUID, ItemDropData> {
        EntityItemDropsSupplier() {
        }
    }

    static class BlockItemDropsSupplier
    extends CapturedMultiMapSupplier<BlockPos, ItemDropData> {
        BlockItemDropsSupplier() {
        }
    }
}

