/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import co.aikar.timings.Timing;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEventData;
import net.minecraft.block.BlockRedstoneLight;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.block.TickBlockEvent;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.event.cause.entity.spawn.BlockSpawnCause;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.CapturedMultiMapSupplier;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.ItemDropData;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.event.tracking.phase.tick.TickPhase;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.block.IMixinBlock;
import org.spongepowered.common.interfaces.block.IMixinBlockEventData;
import org.spongepowered.common.interfaces.block.tile.IMixinTileEntity;
import org.spongepowered.common.interfaces.entity.IMixinEntity;
import org.spongepowered.common.interfaces.world.IMixinLocation;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.mixin.plugin.blockcapturing.IModData_BlockCapturing;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;
import org.spongepowered.common.util.SpongeHooks;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.SpongeProxyBlockAccess;

public final class TrackingUtil {
    public static final int BREAK_BLOCK_INDEX = 0;
    public static final int PLACE_BLOCK_INDEX = 1;
    public static final int DECAY_BLOCK_INDEX = 2;
    public static final int CHANGE_BLOCK_INDEX = 3;
    public static final int MULTI_CHANGE_INDEX = 4;
    public static final Function<ImmutableList.Builder<Transaction<BlockSnapshot>>[], Consumer<Transaction<BlockSnapshot>>> TRANSACTION_PROCESSOR = builders -> transaction -> {
        BlockChange blockChange = ((SpongeBlockSnapshot)transaction.getOriginal()).blockChange;
        builders[blockChange.ordinal()].add(transaction);
        builders[4].add(transaction);
    };
    public static final int EVENT_COUNT = 5;
    public static final Function<BlockSnapshot, Transaction<BlockSnapshot>> TRANSACTION_CREATION = blockSnapshot -> {
        Location<World> originalLocation = blockSnapshot.getLocation().get();
        WorldServer worldServer = (WorldServer)originalLocation.getExtent();
        BlockPos blockPos = ((IMixinLocation)((Object)originalLocation)).getBlockPos();
        IBlockState newState = worldServer.func_180495_p(blockPos);
        IBlockState newActualState = newState.func_185899_b((IBlockAccess)worldServer, blockPos);
        SpongeBlockSnapshot newSnapshot = ((IMixinWorldServer)worldServer).createSpongeBlockSnapshot(newState, newActualState, blockPos, 0);
        return new Transaction<SpongeBlockSnapshot>((SpongeBlockSnapshot)blockSnapshot, newSnapshot);
    };

    public static void tickEntity(net.minecraft.entity.Entity entityIn) {
        Preconditions.checkArgument((boolean)(entityIn instanceof Entity), (String)"Entity %s is not an instance of SpongeAPI's Entity!", (Object[])new Object[]{entityIn});
        Preconditions.checkNotNull((Object)entityIn, (Object)"Cannot capture on a null ticking entity!");
        IMixinChunk chunk = ((IMixinEntity)entityIn).getActiveChunk();
        if (chunk != null && chunk.isQueuedForUnload() && !chunk.isPersistedChunk()) {
            return;
        }
        PhaseContext phaseContext = PhaseContext.start().add(NamedCause.source(entityIn)).addEntityCaptures().addBlockCaptures();
        IMixinEntity mixinEntity = EntityUtil.toMixin(entityIn);
        mixinEntity.getNotifierUser().ifPresent(phaseContext::notifier);
        mixinEntity.getCreatorUser().ifPresent(phaseContext::owner);
        CauseTracker.getInstance().switchToPhase(TickPhase.Tick.ENTITY, phaseContext.complete());
        Timing entityTiming = mixinEntity.getTimingsHandler();
        entityTiming.startTiming();
        try {
            entityIn.func_70071_h_();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            entityTiming.stopTiming();
            CauseTracker.getInstance().completePhase(TickPhase.Tick.ENTITY);
        }
    }

    public static void tickRidingEntity(net.minecraft.entity.Entity entity) {
        Preconditions.checkArgument((boolean)(entity instanceof Entity), (String)"Entity %s is not an instance of SpongeAPI's Entity!", (Object[])new Object[]{entity});
        Preconditions.checkNotNull((Object)entity, (Object)"Cannot capture on a null ticking entity!");
        IMixinChunk chunk = ((IMixinEntity)entity).getActiveChunk();
        if (chunk != null && chunk.isQueuedForUnload() && !chunk.isPersistedChunk()) {
            return;
        }
        PhaseContext phaseContext = PhaseContext.start().add(NamedCause.source(entity)).addEntityCaptures().addBlockCaptures();
        IMixinEntity mixinEntity = EntityUtil.toMixin(entity);
        mixinEntity.getNotifierUser().ifPresent(phaseContext::notifier);
        mixinEntity.getCreatorUser().ifPresent(phaseContext::owner);
        CauseTracker.getInstance().switchToPhase(TickPhase.Tick.ENTITY, phaseContext.complete());
        Timing entityTiming = mixinEntity.getTimingsHandler();
        entityTiming.startTiming();
        entity.func_70098_U();
        entityTiming.stopTiming();
        CauseTracker.getInstance().completePhase(TickPhase.Tick.ENTITY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tickTileEntity(IMixinWorldServer mixinWorldServer, ITickable tile) {
        Preconditions.checkArgument((boolean)(tile instanceof org.spongepowered.api.block.tileentity.TileEntity), (String)"ITickable %s is not a TileEntity!", (Object[])new Object[]{tile});
        Preconditions.checkNotNull((Object)tile, (Object)"Cannot capture on a null ticking tile entity!");
        TileEntity tileEntity = (TileEntity)tile;
        BlockPos pos = tileEntity.func_174877_v();
        IMixinChunk chunk = ((IMixinTileEntity)tile).getActiveChunk();
        if (chunk == null || chunk.isQueuedForUnload() && !chunk.isPersistedChunk()) {
            return;
        }
        PhaseContext phaseContext = PhaseContext.start().add(NamedCause.source(tile)).addEntityCaptures().addBlockCaptures();
        IMixinChunk mixinChunk = chunk;
        mixinChunk.getBlockNotifier(pos).ifPresent(phaseContext::notifier);
        IMixinTileEntity mixinTileEntity = (IMixinTileEntity)tile;
        User blockOwner = mixinTileEntity.getSpongeOwner();
        if (!mixinTileEntity.hasSetOwner()) {
            blockOwner = mixinChunk.getBlockOwner(pos).orElse(null);
            mixinTileEntity.setSpongeOwner(blockOwner);
        }
        phaseContext.owner = blockOwner;
        CauseTracker causeTracker = CauseTracker.getInstance();
        causeTracker.switchToPhase(TickPhase.Tick.TILE_ENTITY, phaseContext.complete());
        mixinTileEntity.getTimingsHandler().startTiming();
        try {
            tile.func_73660_a();
        }
        finally {
            mixinTileEntity.getTimingsHandler().stopTiming();
            causeTracker.completePhase(TickPhase.Tick.TILE_ENTITY);
        }
    }

    public static void updateTickBlock(IMixinWorldServer mixinWorld, Block block, BlockPos pos, IBlockState state, Random random) {
        WorldServer minecraftWorld = mixinWorld.asMinecraftWorld();
        if (ShouldFire.TICK_BLOCK_EVENT) {
            SpongeBlockSnapshot snapshot = mixinWorld.createSpongeBlockSnapshot(state, state, pos, 0);
            TickBlockEvent.Scheduled event = SpongeEventFactory.createTickBlockEventScheduled(Cause.of(NamedCause.source(minecraftWorld)), snapshot);
            SpongeImpl.postEvent(event);
            if (event.isCancelled()) {
                return;
            }
        }
        LocatableBlock locatable = LocatableBlock.builder().location(new Location<World>(mixinWorld.asSpongeWorld(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())).state((BlockState)state).build();
        PhaseContext phaseContext = PhaseContext.start().add(NamedCause.source(locatable)).addBlockCaptures().addEntityCaptures();
        TrackingUtil.checkAndAssignBlockTickConfig(block, minecraftWorld, phaseContext);
        CauseTracker causeTracker = CauseTracker.getInstance();
        PhaseData current = causeTracker.getCurrentPhaseData();
        IPhaseState currentState = current.state;
        currentState.getPhase().appendNotifierPreBlockTick(mixinWorld, pos, currentState, current.context, phaseContext);
        IPhaseState phase = ((IMixinBlock)block).requiresBlockCapture() ? TickPhase.Tick.BLOCK : TickPhase.Tick.NO_CAPTURE_BLOCK;
        causeTracker.switchToPhase(phase, phaseContext.complete());
        block.func_180650_b((net.minecraft.world.World)minecraftWorld, pos, state, random);
        causeTracker.completePhase(phase);
    }

    public static void randomTickBlock(CauseTracker causeTracker, IMixinWorldServer mixinWorld, Block block, BlockPos pos, IBlockState state, Random random) {
        WorldServer minecraftWorld = mixinWorld.asMinecraftWorld();
        if (ShouldFire.TICK_BLOCK_EVENT) {
            SpongeBlockSnapshot currentTickBlock = mixinWorld.createSpongeBlockSnapshot(state, state, pos, 0);
            TickBlockEvent.Random event = SpongeEventFactory.createTickBlockEventRandom(Cause.of(NamedCause.source(minecraftWorld)), currentTickBlock);
            SpongeImpl.postEvent(event);
            if (event.isCancelled()) {
                return;
            }
        }
        LocatableBlock locatable = LocatableBlock.builder().location(new Location<World>(mixinWorld.asSpongeWorld(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())).state((BlockState)state).build();
        PhaseContext phaseContext = PhaseContext.start().add(NamedCause.source(locatable)).addEntityCaptures().addBlockCaptures();
        TrackingUtil.checkAndAssignBlockTickConfig(block, minecraftWorld, phaseContext);
        PhaseData current = causeTracker.getCurrentPhaseData();
        IPhaseState currentState = current.state;
        currentState.getPhase().appendNotifierPreBlockTick(mixinWorld, pos, currentState, current.context, phaseContext);
        IPhaseState phase = ((IMixinBlock)block).requiresBlockCapture() ? TickPhase.Tick.RANDOM_BLOCK : TickPhase.Tick.NO_CAPTURE_BLOCK;
        causeTracker.switchToPhase(phase, phaseContext.complete());
        block.func_180645_a((net.minecraft.world.World)minecraftWorld, pos, state, random);
        causeTracker.completePhase(phase);
    }

    private static void checkAndAssignBlockTickConfig(Block block, WorldServer minecraftWorld, PhaseContext phaseContext) {
        if (block instanceof IModData_BlockCapturing) {
            IModData_BlockCapturing capturingBlock = (IModData_BlockCapturing)block;
            if (capturingBlock.requiresBlockCapturingRefresh()) {
                capturingBlock.initializeBlockCapturingState((net.minecraft.world.World)minecraftWorld);
                capturingBlock.requiresBlockCapturingRefresh(false);
            }
            phaseContext.add(NamedCause.of("ProcessImmediately", ((IModData_BlockCapturing)block).processTickChangesImmediately()));
        } else {
            phaseContext.add(NamedCause.of("ProcessImmediately", false));
        }
    }

    public static void tickWorldProvider(IMixinWorldServer worldServer) {
        CauseTracker causeTracker = CauseTracker.getInstance();
        WorldProvider worldProvider = ((WorldServer)worldServer).field_73011_w;
        causeTracker.switchToPhase(TickPhase.Tick.DIMENSION, PhaseContext.start().add(NamedCause.source(worldProvider)).add(NamedCause.of("World", worldServer)).addBlockCaptures().addEntityCaptures().addEntityDropCaptures().complete());
        worldProvider.func_186059_r();
        causeTracker.completePhase(TickPhase.Tick.DIMENSION);
    }

    public static boolean fireMinecraftBlockEvent(CauseTracker causeTracker, WorldServer worldIn, BlockEventData event) {
        DataSerializable source;
        IBlockState currentState = worldIn.func_180495_p(event.func_180328_a());
        IMixinBlockEventData blockEvent = (IMixinBlockEventData)event;
        PhaseContext phaseContext = PhaseContext.start().addBlockCaptures().addEntityCaptures();
        DataSerializable dataSerializable = source = blockEvent.getTickBlock() != null ? blockEvent.getTickBlock() : blockEvent.getTickTileEntity();
        if (source == null) {
            boolean result = currentState.func_189547_a((net.minecraft.world.World)worldIn, event.func_180328_a(), event.func_151339_d(), event.func_151338_e());
            return result;
        }
        phaseContext.add(NamedCause.source(source));
        if (blockEvent.getSourceUser() != null) {
            phaseContext.add(NamedCause.notifier(blockEvent.getSourceUser()));
        }
        IPhaseState phase = blockEvent.getCaptureBlocks() ? TickPhase.Tick.BLOCK_EVENT : TickPhase.Tick.NO_CAPTURE_BLOCK;
        causeTracker.switchToPhase(phase, phaseContext.complete());
        boolean result = currentState.func_189547_a((net.minecraft.world.World)worldIn, event.func_180328_a(), event.func_151339_d(), event.func_151338_e());
        causeTracker.completePhase(phase);
        return result;
    }

    public static void performBlockDrop(Block block, IMixinWorldServer mixinWorld, BlockPos pos, IBlockState state, float chance, int fortune) {
        boolean shouldEnterBlockDropPhase;
        CauseTracker causeTracker = CauseTracker.getInstance();
        IPhaseState currentState = causeTracker.getCurrentState();
        boolean bl = shouldEnterBlockDropPhase = !currentState.getPhase().alreadyCapturingItemSpawns(currentState) && !currentState.getPhase().isWorldGeneration(currentState);
        if (shouldEnterBlockDropPhase) {
            PhaseContext context = PhaseContext.start().add(NamedCause.source(mixinWorld.createSpongeBlockSnapshot(state, state, pos, 4))).addBlockCaptures().addEntityCaptures();
            context.notifier = causeTracker.getCurrentContext().notifier;
            context.owner = causeTracker.getCurrentContext().owner;
            context.complete();
            causeTracker.switchToPhase(BlockPhase.State.BLOCK_DROP_ITEMS, context);
        }
        block.func_180653_a((net.minecraft.world.World)((WorldServer)mixinWorld), pos, state, chance, fortune);
        if (shouldEnterBlockDropPhase) {
            causeTracker.completePhase(BlockPhase.State.BLOCK_DROP_ITEMS);
        }
    }

    static boolean trackBlockChange(CauseTracker causeTracker, IMixinWorldServer mixinWorld, Chunk chunk, IBlockState currentState, IBlockState newState, BlockPos pos, int flags, PhaseContext phaseContext, IPhaseState phaseState) {
        WorldServer minecraftWorld = mixinWorld.asMinecraftWorld();
        if (phaseState.shouldCaptureBlockChangeOrSkip(phaseContext, pos)) {
            SpongeBlockSnapshot originalBlockSnapshot = mixinWorld.createSpongeBlockSnapshot(currentState, currentState, pos, flags);
            List<BlockSnapshot> capturedSnapshots = phaseContext.getCapturedBlocks();
            Block newBlock = newState.func_177230_c();
            TrackingUtil.associateBlockChangeWithSnapshot(phaseState, newBlock, currentState, originalBlockSnapshot, capturedSnapshots);
            IMixinChunk mixinChunk = (IMixinChunk)chunk;
            IBlockState originalBlockState = mixinChunk.setBlockState(pos, newState, currentState, originalBlockSnapshot);
            if (originalBlockState == null) {
                capturedSnapshots.remove(originalBlockSnapshot);
                return false;
            }
            phaseState.postTrackBlock(originalBlockSnapshot, causeTracker, phaseContext);
        } else {
            IMixinChunk mixinChunk = (IMixinChunk)chunk;
            SpongeBlockSnapshot originalBlockSnapshot = (SpongeBlockSnapshot)BlockSnapshot.NONE;
            IBlockState originalBlockState = mixinChunk.setBlockState(pos, newState, currentState, originalBlockSnapshot);
            if (originalBlockState == null) {
                return false;
            }
        }
        if (newState.func_185891_c() != currentState.func_185891_c() || newState.func_185906_d() != currentState.func_185906_d()) {
            minecraftWorld.field_72984_F.func_76320_a("checkLight");
            minecraftWorld.func_175664_x(pos);
            minecraftWorld.field_72984_F.func_76319_b();
        }
        return true;
    }

    private static void associateBlockChangeWithSnapshot(IPhaseState phaseState, Block newBlock, IBlockState currentState, SpongeBlockSnapshot snapshot, List<BlockSnapshot> capturedSnapshots) {
        Block originalBlock = currentState.func_177230_c();
        if (phaseState == BlockPhase.State.BLOCK_DECAY) {
            if (newBlock == Blocks.field_150350_a) {
                snapshot.blockChange = BlockChange.DECAY;
                capturedSnapshots.add(snapshot);
            }
        } else if (newBlock == Blocks.field_150350_a) {
            snapshot.blockChange = BlockChange.BREAK;
            capturedSnapshots.add(snapshot);
        } else if (newBlock != originalBlock && !TrackingUtil.forceModify(originalBlock, newBlock)) {
            snapshot.blockChange = BlockChange.PLACE;
            capturedSnapshots.add(snapshot);
        } else {
            snapshot.blockChange = BlockChange.MODIFY;
            capturedSnapshots.add(snapshot);
        }
    }

    private static boolean forceModify(Block originalBlock, Block newBlock) {
        if (originalBlock instanceof BlockRedstoneRepeater && newBlock instanceof BlockRedstoneRepeater) {
            return true;
        }
        if (originalBlock instanceof BlockRedstoneTorch && newBlock instanceof BlockRedstoneTorch) {
            return true;
        }
        return originalBlock instanceof BlockRedstoneLight && newBlock instanceof BlockRedstoneLight;
    }

    private TrackingUtil() {
    }

    public static User getNotifierOrOwnerFromBlock(Location<World> location) {
        BlockPos blockPos = ((IMixinLocation)((Object)location)).getBlockPos();
        return TrackingUtil.getNotifierOrOwnerFromBlock((WorldServer)location.getExtent(), blockPos);
    }

    public static User getNotifierOrOwnerFromBlock(WorldServer world, BlockPos blockPos) {
        IMixinChunk mixinChunk = (IMixinChunk)world.func_175726_f(blockPos);
        User notifier = mixinChunk.getBlockNotifier(blockPos).orElse(null);
        if (notifier != null) {
            return notifier;
        }
        User owner = mixinChunk.getBlockOwner(blockPos).orElse(null);
        return owner;
    }

    public static Supplier<IllegalStateException> throwWithContext(String s, PhaseContext phaseContext) {
        return () -> {
            PrettyPrinter printer = new PrettyPrinter(60);
            printer.add("Exception trying to process over a phase!").centre().hr();
            printer.addWrapped(40, "%s :", "PhaseContext");
            CauseTracker.CONTEXT_PRINTER.accept(printer, phaseContext);
            printer.add("Stacktrace:");
            IllegalStateException exception = new IllegalStateException(s + " Please analyze the current phase context. ");
            printer.add(exception);
            printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
            return exception;
        };
    }

    public static boolean processBlockCaptures(List<BlockSnapshot> snapshots, IPhaseState state, PhaseContext context) {
        if (snapshots.isEmpty()) {
            return false;
        }
        ImmutableList[] transactionArrays = new ImmutableList[5];
        ImmutableList.Builder[] transactionBuilders = new ImmutableList.Builder[5];
        for (int i = 0; i < 5; ++i) {
            transactionBuilders[i] = new ImmutableList.Builder();
        }
        ArrayList<ChangeBlockEvent> blockEvents = new ArrayList<ChangeBlockEvent>();
        for (BlockSnapshot snapshot : snapshots) {
            TRANSACTION_PROCESSOR.apply(transactionBuilders).accept(TRANSACTION_CREATION.apply(snapshot));
        }
        for (int i = 0; i < 5; ++i) {
            transactionArrays[i] = transactionBuilders[i].build();
        }
        ChangeBlockEvent[] mainEvents = new ChangeBlockEvent[BlockChange.values().length];
        Cause.Builder builder = Cause.source(context.getSource(Object.class).orElseThrow(TrackingUtil.throwWithContext("There was no root source object for this phase!", context)));
        context.getNotifier().ifPresent(builder::notifier);
        context.getOwner().ifPresent(builder::owner);
        try {
            state.getPhase().associateAdditionalCauses(state, context, builder);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TrackingUtil.iterateChangeBlockEvents(transactionArrays, blockEvents, mainEvents, builder);
        ChangeBlockEvent.Post postEvent = TrackingUtil.throwMultiEventsAndCreatePost(transactionArrays, blockEvents, mainEvents, builder);
        if (postEvent == null) {
            return false;
        }
        ArrayList<Transaction> invalid = new ArrayList<Transaction>();
        boolean noCancelledTransactions = true;
        for (ChangeBlockEvent changeBlockEvent : blockEvents) {
            if (!changeBlockEvent.isCancelled()) continue;
            noCancelledTransactions = false;
            for (Transaction transaction : Lists.reverse(changeBlockEvent.getTransactions())) {
                transaction.setValid(false);
            }
        }
        if (postEvent.isCancelled()) {
            noCancelledTransactions = false;
            for (Transaction transaction : postEvent.getTransactions()) {
                transaction.setValid(false);
            }
        }
        for (Transaction transaction : postEvent.getTransactions()) {
            if (transaction.isValid()) continue;
            invalid.add(transaction);
            BlockPos blockPos = ((IMixinLocation)((Object)((BlockSnapshot)transaction.getOriginal()).getLocation().get())).getBlockPos();
            context.getBlockItemDropSupplier().ifPresentAndNotEmpty(map -> {
                if (map.containsKey((Object)blockPos)) {
                    map.get((Object)blockPos).clear();
                }
            });
            context.getBlockEntitySpawnSupplier().ifPresentAndNotEmpty(map -> {
                if (map.containsKey((Object)blockPos)) {
                    map.get((Object)blockPos).clear();
                }
            });
            context.getBlockEntitySpawnSupplier().ifPresentAndNotEmpty(blockPosEntityMultimap -> {
                if (blockPosEntityMultimap.containsKey((Object)blockPos)) {
                    blockPosEntityMultimap.get((Object)blockPos).clear();
                }
            });
        }
        if (!invalid.isEmpty()) {
            noCancelledTransactions = false;
            for (Transaction transaction : Lists.reverse(invalid)) {
                ((BlockSnapshot)transaction.getOriginal()).restore(true, BlockChangeFlag.NONE);
                if (!state.tracksBlockSpecificDrops()) continue;
                BlockPos position = ((IMixinLocation)((Object)((BlockSnapshot)transaction.getOriginal()).getLocation().get())).getBlockPos();
                context.getBlockDropSupplier().ifPresentAndNotEmpty(map -> {
                    if (map.containsKey((Object)position)) {
                        map.get((Object)position).clear();
                    }
                });
            }
        }
        return TrackingUtil.performBlockAdditions(postEvent.getTransactions(), builder, state, context, noCancelledTransactions);
    }

    public static void iterateChangeBlockEvents(ImmutableList<Transaction<BlockSnapshot>>[] transactionArrays, List<ChangeBlockEvent> blockEvents, ChangeBlockEvent[] mainEvents, Cause.Builder builder) {
        for (BlockChange blockChange : BlockChange.values()) {
            ChangeBlockEvent event;
            if (blockChange == BlockChange.DECAY || transactionArrays[blockChange.ordinal()].isEmpty()) continue;
            mainEvents[blockChange.ordinal()] = event = blockChange.createEvent(builder.build(), transactionArrays[blockChange.ordinal()]);
            if (event == null) continue;
            SpongeImpl.postEvent(event);
            blockEvents.add(event);
        }
        if (!transactionArrays[BlockChange.DECAY.ordinal()].isEmpty()) {
            ChangeBlockEvent event;
            mainEvents[BlockChange.DECAY.ordinal()] = event = BlockChange.DECAY.createEvent(builder.build(), transactionArrays[BlockChange.DECAY.ordinal()]);
            if (event != null) {
                SpongeImpl.postEvent(event);
                blockEvents.add(event);
            }
        }
    }

    public static boolean performBlockAdditions(List<Transaction<BlockSnapshot>> transactions, Cause.Builder builder, IPhaseState phaseState, PhaseContext phaseContext, boolean noCancelledTransactions) {
        SpongeProxyBlockAccess proxyBlockAccess = new SpongeProxyBlockAccess(transactions);
        CapturedMultiMapSupplier<BlockPos, ItemDropData> capturedBlockDrops = phaseContext.getBlockDropSupplier();
        CapturedMultiMapSupplier<BlockPos, EntityItem> capturedBlockItemEntityDrops = phaseContext.getBlockItemDropSupplier();
        CapturedMultiMapSupplier<BlockPos, net.minecraft.entity.Entity> capturedBlockEntitySpawns = phaseContext.getBlockEntitySpawnSupplier();
        for (Transaction<BlockSnapshot> transaction : transactions) {
            if (!transaction.isValid()) {
                noCancelledTransactions = false;
                continue;
            }
            if (transaction.getCustom().isPresent()) {
                transaction.getFinal().restore(true, BlockChangeFlag.NONE);
            }
            SpongeBlockSnapshot oldBlockSnapshot = (SpongeBlockSnapshot)transaction.getOriginal();
            SpongeBlockSnapshot newBlockSnapshot = (SpongeBlockSnapshot)transaction.getFinal();
            Location<World> worldLocation = oldBlockSnapshot.getLocation().get();
            IMixinWorldServer mixinWorldServer = (IMixinWorldServer)((Object)worldLocation.getExtent());
            BlockPos pos = ((IMixinLocation)((Object)oldBlockSnapshot.getLocation().get())).getBlockPos();
            capturedBlockDrops.ifPresentAndNotEmpty(map -> TrackingUtil.spawnItemDataForBlockDrops(map.containsKey((Object)pos) ? map.removeAll((Object)pos) : Collections.emptyList(), newBlockSnapshot, phaseContext, phaseState));
            capturedBlockItemEntityDrops.ifPresentAndNotEmpty(map -> TrackingUtil.spawnItemEntitiesForBlockDrops(map.containsKey((Object)pos) ? map.removeAll((Object)pos) : Collections.emptyList(), newBlockSnapshot, phaseContext, phaseState));
            capturedBlockEntitySpawns.ifPresentAndNotEmpty(map -> TrackingUtil.spawnEntitiesForBlock(map.containsKey((Object)pos) ? map.removeAll((Object)pos) : Collections.emptyList(), newBlockSnapshot, phaseContext, phaseState));
            SpongeHooks.logBlockAction(builder, (net.minecraft.world.World)mixinWorldServer.asMinecraftWorld(), oldBlockSnapshot.blockChange, transaction);
            BlockChangeFlag changeFlag = oldBlockSnapshot.getChangeFlag();
            IBlockState originalState = (IBlockState)oldBlockSnapshot.getState();
            IBlockState newState = (IBlockState)newBlockSnapshot.getState();
            CauseTracker causeTracker = CauseTracker.getInstance();
            if (changeFlag.performBlockPhysics() && originalState.func_177230_c() != newState.func_177230_c()) {
                newState.func_177230_c().func_176213_c((net.minecraft.world.World)mixinWorldServer.asMinecraftWorld(), pos, newState);
                PhaseData peek = causeTracker.getCurrentPhaseData();
                if (peek.state == GeneralPhase.Post.UNWINDING) {
                    peek.state.getPhase().unwind(peek.state, peek.context);
                }
            }
            proxyBlockAccess.proceed();
            phaseState.handleBlockChangeWithUser(oldBlockSnapshot.blockChange, transaction, phaseContext);
            int minecraftChangeFlag = oldBlockSnapshot.getUpdateFlag();
            if ((minecraftChangeFlag & 2) != 0) {
                mixinWorldServer.asMinecraftWorld().func_184138_a(pos, originalState, newState, minecraftChangeFlag);
            }
            if (changeFlag.updateNeighbors()) {
                mixinWorldServer.spongeNotifyNeighborsPostBlockChange(pos, originalState, newState, oldBlockSnapshot.getUpdateFlag());
            }
            PhaseData peek = causeTracker.getCurrentPhaseData();
            if (peek.state != GeneralPhase.Post.UNWINDING) continue;
            peek.state.getPhase().unwind(peek.state, peek.context);
        }
        return noCancelledTransactions;
    }

    public static void spawnItemEntitiesForBlockDrops(Collection<EntityItem> entityItems, SpongeBlockSnapshot newBlockSnapshot, PhaseContext phaseContext, IPhaseState phaseState) {
        World spongeWorld = Sponge.getServer().getWorld(newBlockSnapshot.getWorldUniqueId()).get();
        List itemDrops = entityItems.stream().map(EntityUtil::fromNative).collect(Collectors.toList());
        Cause.Builder builder = Cause.source(((BlockSpawnCause.Builder)((BlockSpawnCause.Builder)BlockSpawnCause.builder().block(newBlockSnapshot)).type(InternalSpawnTypes.DROPPED_ITEM)).build());
        Optional<User> owner = phaseContext.getOwner();
        Optional<User> notifier = phaseContext.getNotifier();
        notifier.ifPresent(builder::notifier);
        User entityCreator = notifier.orElseGet(() -> owner.orElse(null));
        Cause spawnCauses = builder.build();
        DropItemEvent.Destruct destruct = SpongeEventFactory.createDropItemEventDestruct(spawnCauses, itemDrops, spongeWorld);
        SpongeImpl.postEvent(destruct);
        if (!destruct.isCancelled()) {
            for (Entity entity : destruct.getEntities()) {
                if (entityCreator != null) {
                    EntityUtil.toMixin(entity).setCreator(entityCreator.getUniqueId());
                }
                EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
            }
        }
    }

    public static void spawnItemDataForBlockDrops(Collection<ItemDropData> itemStacks, SpongeBlockSnapshot oldBlockSnapshot, PhaseContext phaseContext, IPhaseState state) {
        World spongeWorld = Sponge.getServer().getWorld(oldBlockSnapshot.getWorldUniqueId()).get();
        Vector3i position = oldBlockSnapshot.getPosition();
        List itemSnapshots = itemStacks.stream().map(ItemDropData::getStack).map(ItemStackUtil::createSnapshot).collect(Collectors.toList());
        ImmutableList originalSnapshots = ImmutableList.copyOf(itemSnapshots);
        Cause cause = Cause.source(oldBlockSnapshot).build();
        DropItemEvent.Pre dropItemEventPre = SpongeEventFactory.createDropItemEventPre(cause, (List)originalSnapshots, itemSnapshots);
        SpongeImpl.postEvent(dropItemEventPre);
        if (dropItemEventPre.isCancelled()) {
            itemStacks.clear();
        }
        if (itemStacks.isEmpty()) {
            return;
        }
        World world = oldBlockSnapshot.getLocation().get().getExtent();
        WorldServer worldServer = (WorldServer)world;
        List itemDrops = itemStacks.stream().map(itemStack -> {
            ItemStack minecraftStack = itemStack.getStack();
            float f = 0.5f;
            double offsetX = (double)(worldServer.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double offsetY = (double)(worldServer.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double offsetZ = (double)(worldServer.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double x = (double)position.getX() + offsetX;
            double y = (double)position.getY() + offsetY;
            double z = (double)position.getZ() + offsetZ;
            EntityItem entityitem = new EntityItem((net.minecraft.world.World)worldServer, x, y, z, minecraftStack);
            entityitem.func_174869_p();
            return entityitem;
        }).map(EntityUtil::fromNative).collect(Collectors.toList());
        Cause.Builder builder = Cause.source(((BlockSpawnCause.Builder)((BlockSpawnCause.Builder)BlockSpawnCause.builder().block(oldBlockSnapshot)).type(InternalSpawnTypes.DROPPED_ITEM)).build());
        phaseContext.getNotifier().ifPresent(builder::notifier);
        User entityCreator = phaseContext.getNotifier().orElseGet(() -> phaseContext.getOwner().orElse(null));
        Cause spawnCauses = builder.build();
        DropItemEvent.Destruct destruct = SpongeEventFactory.createDropItemEventDestruct(spawnCauses, itemDrops, spongeWorld);
        SpongeImpl.postEvent(destruct);
        if (!destruct.isCancelled()) {
            for (Entity entity : destruct.getEntities()) {
                if (entityCreator != null) {
                    EntityUtil.toMixin(entity).setCreator(entityCreator.getUniqueId());
                }
                EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
            }
        }
    }

    public static void spawnEntitiesForBlock(Collection<net.minecraft.entity.Entity> entities, SpongeBlockSnapshot newBlockSnapshot, PhaseContext phaseContext, IPhaseState phaseState) {
        World spongeWorld = Sponge.getServer().getWorld(newBlockSnapshot.getWorldUniqueId()).get();
        List entitiesSpawned = entities.stream().map(EntityUtil::fromNative).collect(Collectors.toList());
        Cause.Builder builder = Cause.source(((BlockSpawnCause.Builder)((BlockSpawnCause.Builder)BlockSpawnCause.builder().block(newBlockSnapshot)).type(InternalSpawnTypes.BLOCK_SPAWNING)).build());
        Optional<User> owner = phaseContext.getOwner();
        Optional<User> notifier = phaseContext.getNotifier();
        notifier.ifPresent(builder::notifier);
        User entityCreator = notifier.orElseGet(() -> owner.orElse(null));
        Cause spawnCauses = builder.build();
        SpawnEntityEvent destruct = SpongeEventFactory.createSpawnEntityEvent(spawnCauses, entitiesSpawned, spongeWorld);
        SpongeImpl.postEvent(destruct);
        if (!destruct.isCancelled()) {
            for (Entity entity : destruct.getEntities()) {
                if (entityCreator != null) {
                    EntityUtil.toMixin(entity).setCreator(entityCreator.getUniqueId());
                }
                EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
            }
        }
    }

    public static ChangeBlockEvent.Post throwMultiEventsAndCreatePost(ImmutableList<Transaction<BlockSnapshot>>[] transactionArrays, List<ChangeBlockEvent> blockEvents, ChangeBlockEvent[] mainEvents, Cause.Builder builder) {
        if (!blockEvents.isEmpty()) {
            for (BlockChange blockChange : BlockChange.values()) {
                ChangeBlockEvent mainEvent = mainEvents[blockChange.ordinal()];
                if (mainEvent == null) continue;
                blockChange.suggestNamed(builder, mainEvent);
            }
            ImmutableList<Transaction<BlockSnapshot>> transactions = transactionArrays[4];
            World world = ((BlockSnapshot)((Transaction)transactions.get(0)).getOriginal()).getLocation().get().getExtent();
            ChangeBlockEvent.Post post = SpongeEventFactory.createChangeBlockEventPost(builder.build(), world, transactions);
            SpongeImpl.postEvent(post);
            return post;
        }
        return null;
    }

    public static void splitAndSpawnEntities(Cause cause, List<Entity> entities) {
        TrackingUtil.splitAndSpawnEntities(cause, entities, entity -> {});
    }

    public static void splitAndSpawnEntities(Cause cause, List<Entity> entities, Consumer<IMixinEntity> mixinEntityConsumer) {
        if (entities.size() > 1) {
            HashMultimap entityListMap = HashMultimap.create();
            for (Entity entity : entities) {
                entityListMap.put((Object)entity.getWorld(), (Object)entity);
            }
            for (Map.Entry entry : entityListMap.asMap().entrySet()) {
                World world = (World)entry.getKey();
                ArrayList worldEntities = new ArrayList((Collection)entry.getValue());
                SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(cause, worldEntities, world);
                SpongeImpl.postEvent(event);
                if (event.isCancelled()) continue;
                for (Entity entity : event.getEntities()) {
                    mixinEntityConsumer.accept(EntityUtil.toMixin(entity));
                    ((IMixinWorldServer)((Object)world)).forceSpawnEntity(entity);
                }
            }
            return;
        }
        Entity singleEntity = entities.get(0);
        World world = singleEntity.getWorld();
        SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(cause, entities, world);
        SpongeImpl.postEvent(spawnEntityEvent);
        if (!spawnEntityEvent.isCancelled()) {
            for (Entity entity : spawnEntityEvent.getEntities()) {
                mixinEntityConsumer.accept(EntityUtil.toMixin(entity));
                ((IMixinWorldServer)((Object)world)).forceSpawnEntity(entity);
            }
        }
    }
}

