/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.block;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.entity.spawn.BlockSpawnCause;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.block.BlockPhaseState;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;

final class DispensePhaseState
extends BlockPhaseState {
    DispensePhaseState() {
    }

    @Override
    void unwind(PhaseContext phaseContext) {
        BlockSnapshot blockSnapshot = phaseContext.getSource(BlockSnapshot.class).orElseThrow(TrackingUtil.throwWithContext("Could not find a block dispensing items!", phaseContext));
        World spongeWorld = blockSnapshot.getLocation().get().getExtent();
        phaseContext.getCapturedBlockSupplier().ifPresentAndNotEmpty(blockSnapshots -> TrackingUtil.processBlockCaptures(blockSnapshots, this, phaseContext));
        phaseContext.getCapturedItemsSupplier().ifPresentAndNotEmpty(items -> {
            Cause.Builder builder = Cause.source(((BlockSpawnCause.Builder)((BlockSpawnCause.Builder)BlockSpawnCause.builder().block(blockSnapshot)).type(InternalSpawnTypes.DISPENSE)).build());
            phaseContext.getNotifier().ifPresent(builder::notifier);
            phaseContext.getOwner().ifPresent(builder::owner);
            Cause cause = builder.build();
            ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>();
            for (EntityItem item : items) {
                entities.add(EntityUtil.fromNative((Entity)item));
            }
            DropItemEvent.Dispense event = SpongeEventFactory.createDropItemEventDispense(cause, entities, spongeWorld);
            SpongeImpl.postEvent(event);
            if (!event.isCancelled()) {
                for (org.spongepowered.api.entity.Entity entity : event.getEntities()) {
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                }
            }
        });
        phaseContext.getCapturedEntitySupplier().ifPresentAndNotEmpty(entities -> {
            Cause.Builder builder = Cause.source(((BlockSpawnCause.Builder)((BlockSpawnCause.Builder)BlockSpawnCause.builder().block(blockSnapshot)).type(InternalSpawnTypes.DISPENSE)).build());
            phaseContext.getNotifier().ifPresent(builder::notifier);
            phaseContext.getOwner().ifPresent(builder::owner);
            Cause cause = builder.build();
            SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(cause, entities, spongeWorld);
            SpongeImpl.postEvent(event);
            User user = phaseContext.getNotifier().orElseGet(() -> phaseContext.getOwner().orElse(null));
            if (!event.isCancelled()) {
                for (org.spongepowered.api.entity.Entity entity : event.getEntities()) {
                    if (user != null) {
                        EntityUtil.toMixin(entity).setCreator(user.getUniqueId());
                    }
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                }
            }
        });
    }
}

