/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.entity.ExperienceOrb;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.entity.damage.source.DamageSource;
import org.spongepowered.api.event.cause.entity.spawn.EntitySpawnCause;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.entity.EntityPhaseState;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;

final class DeathPhase
extends EntityPhaseState {
    DeathPhase() {
    }

    @Override
    public boolean tracksBlockSpecificDrops() {
        return true;
    }

    @Override
    void unwind(PhaseContext context) {
        org.spongepowered.api.entity.Entity dyingEntity = context.getSource(org.spongepowered.api.entity.Entity.class).orElseThrow(TrackingUtil.throwWithContext("Dying entity not found!", context));
        DamageSource damageSource = context.firstNamed("DamageSource", DamageSource.class).get();
        Cause cause = Cause.source(((EntitySpawnCause.Builder)((EntitySpawnCause.Builder)EntitySpawnCause.builder().entity(dyingEntity)).type(InternalSpawnTypes.DROPPED_ITEM)).build()).named("DamageSource", damageSource).build();
        boolean isPlayer = dyingEntity instanceof EntityPlayer;
        EntityPlayer entityPlayer = isPlayer ? (EntityPlayer)dyingEntity : null;
        Optional<User> notifier = context.getNotifier();
        Optional<User> owner = context.getOwner();
        User entityCreator = notifier.orElseGet(() -> owner.orElse(null));
        context.getCapturedEntitySupplier().ifPresentAndNotEmpty(entities -> {
            List other;
            List experience = entities.stream().filter(entity -> entity instanceof ExperienceOrb).collect(Collectors.toList());
            if (!experience.isEmpty()) {
                Cause experienceCause = Cause.source(((EntitySpawnCause.Builder)((EntitySpawnCause.Builder)EntitySpawnCause.builder().entity(dyingEntity)).type(InternalSpawnTypes.EXPERIENCE)).build()).named("DamageSource", damageSource).build();
                SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(experienceCause, experience, dyingEntity.getWorld());
                SpongeImpl.postEvent(spawnEntityEvent);
                if (!spawnEntityEvent.isCancelled()) {
                    for (org.spongepowered.api.entity.Entity entity2 : spawnEntityEvent.getEntities()) {
                        EntityUtil.getMixinWorld(entity2).forceSpawnEntity(entity2);
                    }
                }
            }
            if (!(other = entities.stream().filter(entity -> !(entity instanceof ExperienceOrb)).collect(Collectors.toList())).isEmpty()) {
                Cause otherCause = Cause.source(((EntitySpawnCause.Builder)((EntitySpawnCause.Builder)EntitySpawnCause.builder().entity(dyingEntity)).type(InternalSpawnTypes.ENTITY_DEATH)).build()).named("DamageSource", damageSource).build();
                SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(otherCause, experience, dyingEntity.getWorld());
                SpongeImpl.postEvent(spawnEntityEvent);
                if (!spawnEntityEvent.isCancelled()) {
                    for (org.spongepowered.api.entity.Entity entity3 : spawnEntityEvent.getEntities()) {
                        EntityUtil.getMixinWorld(entity3).forceSpawnEntity(entity3);
                    }
                }
            }
        });
        if (context.getCapturedEntityItemDropSupplier().isEmpty() && context.getCapturedEntityDropSupplier().isEmpty()) {
            ArrayList entities2 = new ArrayList();
            DropItemEvent.Destruct destruct = SpongeEventFactory.createDropItemEventDestruct(cause, entities2, dyingEntity.getWorld());
            SpongeImpl.postEvent(destruct);
            if (!destruct.isCancelled()) {
                for (org.spongepowered.api.entity.Entity entity : destruct.getEntities()) {
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                }
            }
            return;
        }
        context.getCapturedEntityItemDropSupplier().ifPresentAndNotEmpty(map -> {
            List items = map.get((Object)dyingEntity.getUniqueId());
            ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>();
            for (EntityItem item : items) {
                entities.add(EntityUtil.fromNative((Entity)item));
            }
            if (isPlayer) {
                entityPlayer.field_71071_by.func_174888_l();
            }
            DropItemEvent.Destruct destruct = SpongeEventFactory.createDropItemEventDestruct(cause, entities, dyingEntity.getWorld());
            SpongeImpl.postEvent(destruct);
            if (!destruct.isCancelled()) {
                for (org.spongepowered.api.entity.Entity entity : destruct.getEntities()) {
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                }
            }
        });
        context.getCapturedEntityDropSupplier().ifPresentAndNotEmpty(map -> {
            List itemStacks = map.get((Object)dyingEntity.getUniqueId());
            if (itemStacks.isEmpty()) {
                return;
            }
            ArrayList items = new ArrayList();
            items.addAll(itemStacks);
            if (!items.isEmpty()) {
                Entity minecraftEntity = EntityUtil.toNative(dyingEntity);
                List itemEntities = items.stream().map(data -> data.create((WorldServer)minecraftEntity.field_70170_p)).map(EntityUtil::fromNative).collect(Collectors.toList());
                if (isPlayer) {
                    entityPlayer.field_71071_by.func_174888_l();
                }
                DropItemEvent.Destruct destruct = SpongeEventFactory.createDropItemEventDestruct(cause, itemEntities, dyingEntity.getWorld());
                SpongeImpl.postEvent(destruct);
                if (!destruct.isCancelled()) {
                    for (org.spongepowered.api.entity.Entity entity : destruct.getEntities()) {
                        if (entityCreator != null) {
                            EntityUtil.toMixin(entity).setCreator(entityCreator.getUniqueId());
                        }
                        EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                    }
                }
            }
        });
    }
}

