/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.general;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.event.cause.entity.spawn.BlockSpawnCause;
import org.spongepowered.api.event.cause.entity.spawn.EntitySpawnCause;
import org.spongepowered.api.event.cause.entity.spawn.SpawnCause;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.world.ExplosionEvent;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.GeneralState;
import org.spongepowered.common.interfaces.world.IMixinExplosion;
import org.spongepowered.common.interfaces.world.IMixinLocation;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.BlockChange;

final class ExplosionState
extends GeneralState {
    ExplosionState() {
    }

    @Override
    public boolean canSwitchTo(IPhaseState state) {
        return true;
    }

    @Override
    public boolean tracksEntitySpecificDrops() {
        return true;
    }

    @Override
    public boolean tracksBlockSpecificDrops() {
        return true;
    }

    @Override
    public boolean requiresBlockPosTracking() {
        return true;
    }

    @Override
    void unwind(PhaseContext context) {
        Optional<Explosion> explosion = context.getCaptureExplosion().getExplosion();
        if (!explosion.isPresent()) {
            return;
        }
        World spongeWorld = (World)((net.minecraft.world.Explosion)explosion.get()).field_77287_j;
        Cause cause = ((IMixinExplosion)((Object)explosion.get())).getCreatedCause();
        context.getCapturedBlockSupplier().ifPresentAndNotEmpty(blocks -> this.processBlockCaptures((List<BlockSnapshot>)blocks, (Explosion)explosion.get(), cause, context));
        context.getCapturedEntitySupplier().ifPresentAndNotEmpty(entities -> {
            Cause.Builder builder = Cause.builder();
            Object root = cause.root();
            if (root instanceof org.spongepowered.api.entity.Entity) {
                builder.named(NamedCause.source(((EntitySpawnCause.Builder)((EntitySpawnCause.Builder)EntitySpawnCause.builder().entity((org.spongepowered.api.entity.Entity)root)).type(InternalSpawnTypes.TNT_IGNITE)).build()));
            } else if (root instanceof BlockSnapshot) {
                builder.named(NamedCause.source(((BlockSpawnCause.Builder)((BlockSpawnCause.Builder)BlockSpawnCause.builder().block((BlockSnapshot)root)).type(InternalSpawnTypes.TNT_IGNITE)).build()));
            } else {
                builder.named(NamedCause.source(((SpawnCause.Builder)SpawnCause.builder().type(InternalSpawnTypes.TNT_IGNITE)).build()));
            }
            context.getNotifier().ifPresent(builder::notifier);
            context.getOwner().ifPresent(builder::owner);
            builder.named(NamedCause.of("Explosion", explosion.get()));
            User user = context.getNotifier().orElseGet(() -> context.getOwner().orElse(null));
            SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(builder.build(), entities, spongeWorld);
            SpongeImpl.postEvent(event);
            if (!event.isCancelled()) {
                for (org.spongepowered.api.entity.Entity entity : event.getEntities()) {
                    if (user != null) {
                        EntityUtil.toMixin(entity).setCreator(user.getUniqueId());
                    }
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                }
            }
        });
    }

    private void processBlockCaptures(List<BlockSnapshot> snapshots, Explosion explosion, Cause cause, PhaseContext context) {
        if (snapshots.isEmpty()) {
            return;
        }
        World spongeWorld = (World)((net.minecraft.world.Explosion)explosion).field_77287_j;
        ImmutableList[] transactionArrays = new ImmutableList[5];
        ImmutableList.Builder[] transactionBuilders = new ImmutableList.Builder[5];
        for (int i = 0; i < 5; ++i) {
            transactionBuilders[i] = new ImmutableList.Builder();
        }
        ArrayList<ChangeBlockEvent> blockEvents = new ArrayList<ChangeBlockEvent>();
        for (BlockSnapshot snapshot : snapshots) {
            TrackingUtil.TRANSACTION_PROCESSOR.apply(transactionBuilders).accept(TrackingUtil.TRANSACTION_CREATION.apply(snapshot));
        }
        for (int i = 0; i < 5; ++i) {
            transactionArrays[i] = transactionBuilders[i].build();
        }
        ChangeBlockEvent[] mainEvents = new ChangeBlockEvent[BlockChange.values().length];
        Cause.Builder builder = Cause.source(context.getSource(Object.class).orElseThrow(TrackingUtil.throwWithContext("There was no root source object for this phase!", context)));
        context.getNotifier().ifPresent(builder::notifier);
        context.getOwner().ifPresent(builder::owner);
        try {
            this.getPhase().associateAdditionalCauses(this, context, builder);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TrackingUtil.iterateChangeBlockEvents(transactionArrays, blockEvents, mainEvents, builder);
        for (BlockChange blockChange : BlockChange.values()) {
            ChangeBlockEvent mainEvent = mainEvents[blockChange.ordinal()];
            if (mainEvent == null) continue;
            blockChange.suggestNamed(builder, mainEvent);
        }
        ImmutableList transactions = transactionArrays[4];
        ExplosionEvent.Post postEvent = SpongeEventFactory.createExplosionEventPost(cause, explosion, spongeWorld, (List)transactions);
        if (postEvent == null) {
            return;
        }
        SpongeImpl.postEvent(postEvent);
        ArrayList<Transaction> invalid = new ArrayList<Transaction>();
        boolean noCancelledTransactions = true;
        for (ChangeBlockEvent changeBlockEvent : blockEvents) {
            if (!changeBlockEvent.isCancelled()) continue;
            noCancelledTransactions = false;
            for (Transaction transaction : Lists.reverse(changeBlockEvent.getTransactions())) {
                transaction.setValid(false);
            }
        }
        if (postEvent.isCancelled()) {
            noCancelledTransactions = false;
            for (Transaction transaction : postEvent.getTransactions()) {
                transaction.setValid(false);
            }
        }
        for (Transaction transaction : postEvent.getTransactions()) {
            if (transaction.isValid()) continue;
            invalid.add(transaction);
            BlockPos blockPos = ((IMixinLocation)((Object)((BlockSnapshot)transaction.getOriginal()).getLocation().get())).getBlockPos();
            context.getBlockItemDropSupplier().ifPresentAndNotEmpty(map -> {
                if (map.containsKey((Object)blockPos)) {
                    map.get((Object)blockPos).clear();
                }
            });
            context.getBlockEntitySpawnSupplier().ifPresentAndNotEmpty(map -> {
                if (map.containsKey((Object)blockPos)) {
                    map.get((Object)blockPos).clear();
                }
            });
            context.getBlockEntitySpawnSupplier().ifPresentAndNotEmpty(blockPosEntityMultimap -> {
                if (blockPosEntityMultimap.containsKey((Object)blockPos)) {
                    blockPosEntityMultimap.get((Object)blockPos).clear();
                }
            });
        }
        if (!invalid.isEmpty()) {
            noCancelledTransactions = false;
            for (Transaction transaction : Lists.reverse(invalid)) {
                ((BlockSnapshot)transaction.getOriginal()).restore(true, BlockChangeFlag.NONE);
                if (!this.tracksBlockSpecificDrops()) continue;
                BlockPos position = ((IMixinLocation)((Object)((BlockSnapshot)transaction.getOriginal()).getLocation().get())).getBlockPos();
                context.getBlockDropSupplier().ifPresentAndNotEmpty(map -> {
                    if (map.containsKey((Object)position)) {
                        map.get((Object)position).clear();
                    }
                });
            }
        }
        TrackingUtil.performBlockAdditions(postEvent.getTransactions(), builder, this, context, noCancelledTransactions);
    }

    @Override
    public boolean shouldCaptureBlockChangeOrSkip(PhaseContext phaseContext, BlockPos pos) {
        boolean match = false;
        Vector3i blockPos = VecHelper.toVector3i(pos);
        for (BlockSnapshot capturedSnapshot : phaseContext.getCapturedBlocks()) {
            if (!capturedSnapshot.getPosition().equals(blockPos)) continue;
            match = true;
        }
        return !match;
    }

    @Override
    public boolean spawnEntityOrCapture(PhaseContext context, org.spongepowered.api.entity.Entity entity, int chunkX, int chunkZ) {
        BlockPos blockPos = context.getBlockPosition().orElseThrow(TrackingUtil.throwWithContext("Expected to be capturing a block position during an explosion!", context));
        ListMultimap<BlockPos, Entity> blockPosEntityMultimap = context.getBlockEntitySpawnSupplier().get();
        ListMultimap<BlockPos, EntityItem> blockPosEntityItemMultimap = context.getBlockItemDropSupplier().get();
        if (entity instanceof EntityItem) {
            blockPosEntityItemMultimap.put((Object)blockPos, (Object)((EntityItem)entity));
        } else {
            blockPosEntityMultimap.put((Object)blockPos, (Object)((Entity)entity));
        }
        return true;
    }
}

